****************************************************************************
*         Copyright 1991 Thinking Machines Corporation, Inc.		    *
*	      of Cambridge, Mass.  All rights reserved.			    *
*									    *
*  This notice is intended as a precaution against inadvertent publication  *
*  and does not constitute an admission or acknowledgement that publication *
*  has occurred or constitute a waiver of confidentiality.		    *
*									    *
*  Connection Machine software is the proprietary and confidential property *
*  of Thinking Machines Corporation.					    *
*****************************************************************************/

C This file is a translation of attach.h
      
	
       integer ICM_PCOUNT_MAXIMUM
       parameter (ICM_PCOUNT_MAXIMUM=64* 1024)
	
       integer ICM_MSIZE_MAXIMUM
       parameter (ICM_MSIZE_MAXIMUM=4* (1024* 1024))

C  The largest interface-maximum is not (power-of-two)-1, like you'd
C  expect, but (power-of-two)-2.
C 
C  The reason for this is:
C 	   	
C 	0 is used to encode ANY interface in the bit-field (dictated by
C 	  the fact that the user doesn't have to say anything in
C 	  particular when they don't care about interfaces).
C 	BUT 0 is a legitimate selection, so interface-maximum+1 is the
C 	  highest number that can be encoded in our selection of bits --
C 	  i.e., interface-maximum+1=power-of-two - 1.
C 

       
       integer ICM_INTERFACE_MAXIMUM
       parameter (ICM_INTERFACE_MAXIMUM=6)

C  arguments to CM_attach_to() which select sequencer allocations, etc.

C  wait for the interface to become available (1 bit)

       
       integer ICMA_W_SHIFT
       parameter (ICMA_W_SHIFT=0)
       
       integer ICMA_W_MASK
       parameter (ICMA_W_MASK=1)
       
       integer ICMA_WAIT
       parameter (ICMA_WAIT=1)

C  memory size (64K, 256K, 1M, 4M, any (=0), plus a bit to indicate that
C  larger sizes are NOT acceptable) (4 bits)

       
       integer ICMA_MSHIFT
       parameter (ICMA_MSHIFT=1)
       
       integer ICMA_MMASK
       parameter (ICMA_MMASK=(7*(2**ICMA_MSHIFT)))

       
       integer ICMA_M64K
       parameter (ICMA_M64K=(1*(2**ICMA_MSHIFT)))
       
       integer ICMA_M64
       parameter (ICMA_M64=ICMA_M64K)

       
       integer ICMA_M256K
       parameter (ICMA_M256K=(2*(2**ICMA_MSHIFT)))
       
       integer ICMA_M256
       parameter (ICMA_M256=ICMA_M256K)

       
       integer ICMA_M1M
       parameter (ICMA_M1M=(3*(2**ICMA_MSHIFT)))
       
       integer ICMA_M1
       parameter (ICMA_M1=ICMA_M1M)

       
       integer ICMA_M4M
       parameter (ICMA_M4M=(4*(2**ICMA_MSHIFT)))
       
       integer ICMA_M4
       parameter (ICMA_M4=ICMA_M4M)

       
       integer ICMA_MEXACT
       parameter (ICMA_MEXACT=(8*(2**ICMA_MSHIFT)))

C  floating point (none, 32bit, 64bit, any) (2 bits)

       
       integer ICMA_FPU_SHIFT
       parameter (ICMA_FPU_SHIFT=(ICMA_MSHIFT+4) )
       
       integer ICMA_FPU_MASK
       parameter (ICMA_FPU_MASK=(3*(2**ICMA_FPU_SHIFT)))
       	
       
       integer ICMA_FPU_NONE
       parameter (ICMA_FPU_NONE=(1*(2**ICMA_FPU_SHIFT)))
       
       integer ICMA_FPU_32
       parameter (ICMA_FPU_32=(2*(2**ICMA_FPU_SHIFT)))
       
       integer ICMA_FPU_64
       parameter (ICMA_FPU_64=(3*(2**ICMA_FPU_SHIFT)))

C  devices wanted (framebuffer, datavault, 3 spares) (5 bits)

       
       integer ICMA_DEV_SHIFT
       parameter (ICMA_DEV_SHIFT=(ICMA_FPU_SHIFT+2) )
       
       integer ICMA_DEV_MASK
       parameter (ICMA_DEV_MASK=(15*(2**ICMA_DEV_SHIFT)))
       	
       integer ICMA_FRAMEBUFFER
       parameter (ICMA_FRAMEBUFFER=(1*(2**ICMA_DEV_SHIFT)))
       
       integer ICMA_DATAVAULT
       parameter (ICMA_DATAVAULT=(2*(2**ICMA_DEV_SHIFT)))
       
       integer ICMA_DEV_SPARE1
       parameter (ICMA_DEV_SPARE1=(4*(2**ICMA_DEV_SHIFT)))
       
       integer ICMA_DEV_SPARE2
       parameter (ICMA_DEV_SPARE2=(8*(2**ICMA_DEV_SHIFT)))
       
C  timeshared-only, exclusive-only, don't care (2 bits)

       
       integer ICMA_TS_SHIFT
       parameter (ICMA_TS_SHIFT=(ICMA_DEV_SHIFT+4) )
       
       integer ICMA_TS_MASK
       parameter (ICMA_TS_MASK=(3*(2**ICMA_TS_SHIFT)))

       
       integer ICMA_TIMESHARED
       parameter (ICMA_TIMESHARED=(1*(2**ICMA_TS_SHIFT)))
       
       integer ICMA_EXCLUSIVE
       parameter (ICMA_EXCLUSIVE=(2*(2**ICMA_TS_SHIFT)))
       	
C  sequencer count: 1, 2, or 4 sequencers (2 bits)

       
       integer ICMA_UCCS_SHIFT
       parameter (ICMA_UCCS_SHIFT=(ICMA_TS_SHIFT+2) )
       
       integer ICMA_UCCS_MASK
       parameter (ICMA_UCCS_MASK=(7*(2**ICMA_UCCS_SHIFT)))

       
       integer ICMA_UCCS_1
       parameter (ICMA_UCCS_1=(1*(2**ICMA_UCCS_SHIFT)))
       
       integer ICMA_UCCS_2
       parameter (ICMA_UCCS_2=(2*(2**ICMA_UCCS_SHIFT)))
       
       integer ICMA_UCCS_4
       parameter (ICMA_UCCS_4=(4*(2**ICMA_UCCS_SHIFT)) )

C  specific sequencer set: 0, 1, 2, 3, 0-1, 2-3, 0-3 (4 bits)

       
       integer ICMA_UCC_SET_SHIFT
       parameter (ICMA_UCC_SET_SHIFT=(ICMA_UCCS_SHIFT+3) )
       
       integer	ICMA_UCC_SET_MASK
       parameter  (ICMA_UCC_SET_MASK=
     $      15*(2**ICMA_UCC_SET_SHIFT))
       
       integer ICMA_UCC0
       parameter (ICMA_UCC0=(1*(2**ICMA_UCC_SET_SHIFT)))
       
       integer ICMA_UCC1
       parameter (ICMA_UCC1=(2*(2**ICMA_UCC_SET_SHIFT)))
       
       integer ICMA_UCC2
       parameter (ICMA_UCC2=(4*(2**ICMA_UCC_SET_SHIFT)))
       
       integer ICMA_UCC3
       parameter (ICMA_UCC3=(8*(2**ICMA_UCC_SET_SHIFT)))
       
       integer ICMA_UCC0_and_1
       parameter (ICMA_UCC0_and_1=(ICMA_UCC0+ICMA_UCC1))
       
       integer ICMA_UCC2_and_3
       parameter (ICMA_UCC2_and_3=(ICMA_UCC2+ICMA_UCC3))
       
       integer ICMA_UCC0_to_3
       parameter (ICMA_UCC0_to_3=ICMA_UCC_SET_MASK)

C  specific number of processors: 512, 1K, 4K, 8K, 16K, 32K, 64K, any,
C  plus a bit that indicates that larger sizes are NOT acceptable
C  least (5 bits) 

       
       integer ICMA_PSHIFT
       parameter (ICMA_PSHIFT=(ICMA_UCC_SET_SHIFT+4) )
       
       integer ICMA_PMASK
       parameter (ICMA_PMASK=(15*(2**ICMA_PSHIFT)))

       
       integer ICMA_P512
       parameter (ICMA_P512=(1*(2**ICMA_PSHIFT)))
       
       integer ICMA_P1K
       parameter (ICMA_P1K=(2*(2**ICMA_PSHIFT)))
       
       integer ICMA_P2K
       parameter (ICMA_P2K=(3*(2**ICMA_PSHIFT)))
       
       integer ICMA_P4K
       parameter (ICMA_P4K=(4*(2**ICMA_PSHIFT)))
       
       integer ICMA_P8K
       parameter (ICMA_P8K=(5*(2**ICMA_PSHIFT)))
       
       integer ICMA_P16K
       parameter (ICMA_P16K=(6*(2**ICMA_PSHIFT)))
       
       integer ICMA_P32K
       parameter (ICMA_P32K=(7*(2**ICMA_PSHIFT)))
       
       integer ICMA_P64K
       parameter (ICMA_P64K=(8*(2**ICMA_PSHIFT)))

C  Only an exact match on processor count is acceptable.

       
       integer ICMA_PEXACT
       parameter (ICMA_PEXACT=(16*(2**ICMA_PSHIFT)))

C  use the direct interface instead of the generic interface (1 bit)

       
       integer ICMA_IDSHIFT
       parameter (ICMA_IDSHIFT=(ICMA_PSHIFT+5) )
       
       integer ICMA_IDMASK
       parameter (ICMA_IDMASK=(1*(2**ICMA_IDSHIFT)))

       
       integer ICMA_IGENERIC
       parameter (ICMA_IGENERIC=0)
       
       integer ICMA_IDIRECT
       parameter (ICMA_IDIRECT=(1*(2**ICMA_IDSHIFT)))

C  specific interface to use (0-4 (could be 0-6), or any) (3 bits)

       
       integer ICMA_ISHIFT
       parameter (ICMA_ISHIFT=(ICMA_IDSHIFT+1) )
       
       integer ICMA_IMASK
       parameter (ICMA_IMASK=(7*(2**ICMA_ISHIFT)))

C  specific species: ICMA_TYPE_DEFAULT (expressed as 0 in this field, of
C  course), CM2, CM3, CM4, CM5, CM6, CM7, CM8 --- three bits).
       
       integer ICMA_TSHIFT
       parameter (ICMA_TSHIFT=(ICMA_ISHIFT+3) )
       
       integer ICMA_TMASK
       parameter (ICMA_TMASK=(3*(2**ICMA_TSHIFT)))
       
       integer ICMA_TDEFAULT
       parameter (ICMA_TDEFAULT=(0*(2**ICMA_TSHIFT)))
       
       integer ICMA_CM2
       parameter (ICMA_CM2=(1*(2**ICMA_TSHIFT) ))
       
       integer ICMA_CM200
       parameter (ICMA_CM200=(2*(2**ICMA_TSHIFT) ))


C  probably don't want to use bit 31, for fear of getting bitten by
C  sign-extension...

C     Declaration of macro types:

        integer ICMA_MBITS
        external ICMA_MBITS
        integer ICMA_MSIZE
        external ICMA_MSIZE
        integer ICMA_BITS_TO_UCCS
        external ICMA_BITS_TO_UCCS
        integer ICMA_UCCS_TO_BITS
        external ICMA_UCCS_TO_BITS
        integer ICMA_PBITS
        external ICMA_PBITS
        integer ICMA_PCOUNT
        external ICMA_PCOUNT
        integer ICMA_I
        external ICMA_I
        integer ICMA_BITS_FROM_INTERFACE
        external ICMA_BITS_FROM_INTERFACE
        integer ICMA_INTERFACE_FROM_BITS
        external ICMA_INTERFACE_FROM_BITS
