/*Avigo FwSDK Keyboard input routines
 *Written for Avigo FwSDK v0.92 beta 3
 *By Sam Rauch
  srauch@umich.edu

  ***IF YOU MAKE ANY ENHANCEMENTS OR FIND ANY BUGS PLEASE LET ME KNOW SO THAT I
     CAN UPDATE THE GENERAL RELEASE***

 */

#include <avsys.h>
#include "keyboard.h"

#include <avicons.h>

#define KBSTATE_CPS_OR_SHFT 3   /*KBSTATE_CAPS | KBSTATE_SHIFT*/
#define KBSTATE_ANY_ACCENT  60  /*KBSTATE_LFT_ACCENT | KBSTATE_RT_ACCENT KBSTATE_DOT_ACCENT | KBSTATE_HAT_ACCENT*/
#define KBSTATE_ANY_CAPS    129 /*KBSTATE_FIRSTCAP | KBSTATE_CAPS */
#define KBSTATE_CPS_SHIFT_OR_SYMB 67 /* KBSTATE_CAPS | KBSTATE_SHIFT | KBSTATE_SYMBOL */

#define KB_CHECKLOOKUP      128
#define KB_LANGUAGE_DEP     64
#define KB_ACCENT_DEP       32
#define KB_CHECKLU_LANG     192
#define KB_CHECKLU_ACC      160
#define KB_LOOKUP_IDMASK    31

#define KB_KEY_WIDTH 13
#define KB_KEY_HEIGHT 14
#define KB_SYMKEY_WIDTH  16
#define KB_SYMKEY_HEIGHT 17

#define KB_IMG_WIDTH 159
#define KB_IMG_HEIGHT 71
#define KB_ACCENTKEY_WIDTH 14
#define KB_BOTTOMROW_Y1  70
#define KB_SYMK_PY0 171  /*IMG_YO+2*/
#define KB_LASTCOL_X1   158 /*KB_IMG_WIDTH-1*/
#define KB_SYMK_YOFFSET  2
#define KB_SYMK_YOFFSET2 3
#define KB_SYMK_BOTTOMROW_Y0  53 /*3*KB_SYMKEY_HEIGHT+KB_SYMK_YOFFSET*/
#define KB_SYMK_CANCEL_X0     80 /*5*KB_SYMKEY_WIDTH*/
#define KB_SPACEROW_Y0 56
#define KB_SPACEBAR_X0 56
#define KB_SPACEBAR_X1 116
#define KB_SYMBOLBUTT_X0 116

#define KB_BAKBUF			0xa7d0

#pragma dataseg
unsigned char _kbmode = 0;
char _kblang = 0;
unsigned char _kb_bkup = 0;
int _kb_x0=0;
int _kb_y0=169;

#pragma codeseg
unsigned char _kb_language_map[][]={
	{'q'             ,'q'             ,KB_CHECKLU_ACC|0}, /*q*/
	{'w'             ,'w'             ,'z'}, /*w*/
	{KB_CHECKLU_ACC|5,'z'             ,KB_CHECKLU_ACC|5}, /*y*/
	{KB_CHECKLU_ACC|0,KB_CHECKLU_ACC|0,'q'},/*a*/
	{'z'             ,KB_CHECKLU_ACC|5,'w'}, /*z*/
	{'Q'             ,'Q'             ,KB_CHECKLU_ACC|6}, /*Q*/
	{'W'             ,'W'             ,'Z'}, /*W*/
	{KB_CHECKLU_ACC|11,'Z'             ,KB_CHECKLU_ACC|11}, /*Y*/
	{KB_CHECKLU_ACC|6,KB_CHECKLU_ACC|6,'Q'},/*A*/
	{'Z'             ,KB_CHECKLU_ACC|11,'W'} /*Z*/
};

unsigned char _kb_accent_map[][]={
    {'a','','','',''},
    {'e','','','',''},
    {'i','','','',''},
    {'o','','','',''},
    {'u','','','',''},
    {'y','y','','','y'},
    {'A','','','',''},
    {'E','','','',''},
    {'I','','','',''},
    {'O','','','',''},
    {'U','','','',''},
    {'Y','Y','','','Y'}
};

unsigned char _kb_key_map[][][]={
	{
		{'`','1','2','3','4','5','6','7','8','9','0',0},
		{KB_CHECKLU_LANG|0,KB_CHECKLU_LANG|1,KB_CHECKLU_ACC|1,'r','t',KB_CHECKLU_LANG|2,KB_CHECKLU_ACC|4,KB_CHECKLU_ACC|2,KB_CHECKLU_ACC|3,'p','-',0},
		{KB_CHECKLU_LANG|3,'s','d','f','g','h','j','k','l',0  ,0  ,0},
		{KB_CHECKLU_LANG|4,'x','c','v','b','n','m',',','.','/',0  ,0}
	},{
		{'`','1','2','3','4','5','6','7','8','9','0',0},
		{KB_CHECKLU_LANG|5,KB_CHECKLU_LANG|6,KB_CHECKLU_ACC|7,'R','T',KB_CHECKLU_LANG|7,KB_CHECKLU_ACC|10,KB_CHECKLU_ACC|8,KB_CHECKLU_ACC|9,'P','-',0},
		{KB_CHECKLU_LANG|8,'S','D','F','G','H','J','K','L', 0 ,0  ,0},
		{KB_CHECKLU_LANG|9,'X','C','V','B','N','M',',','.','/',0  ,0}
	},{
		{'~','!','@','#','$','%','^','&','*','(',')',0},
		{KB_CHECKLU_LANG|5,KB_CHECKLU_LANG|6,KB_CHECKLU_ACC|7,'R','T',KB_CHECKLU_LANG|7,KB_CHECKLU_ACC|10,KB_CHECKLU_ACC|8,KB_CHECKLU_ACC|9,'P','_',0},
		{KB_CHECKLU_LANG|8,'S','D','F','G','H','J','K','L',0  ,0  ,0},
		{KB_CHECKLU_LANG|9,'X','C','V','B','N','M','<','>','?',0  ,0}
	},{
		{'~','!','@','#','$','%','^','&','*','(',')',0},
		{KB_CHECKLU_LANG|0,KB_CHECKLU_LANG|1,KB_CHECKLU_ACC|1,'r','t',KB_CHECKLU_LANG|2,KB_CHECKLU_ACC|4,KB_CHECKLU_ACC|2,KB_CHECKLU_ACC|3,'p','_',0},
		{KB_CHECKLU_LANG|3,'s','d','f','g','h','j','k','l',0  ,0  ,0},
		{KB_CHECKLU_LANG|4,'x','c','v','b','n','m','<','>','?',0  ,0}
	}
};
unsigned char _kb_symbol_map[][] = {
	{'','','','','','','\'','\"','\\','|'},
	{'','','','','','',':',';','[',']'},
	{'','','','','','','+','=','{','}'},
	{'','','','','',0  ,0  ,0  ,0  ,0  }
};


int _kb_line_offset[] = {
	0,15,21,28
};

unsigned char _kb_line_end[] = {
	143,158,138,158
};

unsigned char _kb_sidekey_map[][][] = {
	{
		{0,0}, {0,KBKEY_BACKSPACE}
	}, {
		{0,KBKEY_TAB}, {0,0}
	}, {
		{KBSTATE_CAPS,0}, {0,KBKEY_CR}
	}, {
		{KBSTATE_SHIFT,0}, {0,0}
	}
};

#pragma defaultseg

void _show_keyboard() 
{
    int keyboard_index = I_KEYBOARD_LOWER;
    if (_kbmode == KBSTATE_PASSWORD) {
		keyboard_index = I_KEYBOARD_PASSWORD;
    } else { if (_kbmode & KBSTATE_FIRSTCAP) {
		keyboard_index = I_KEYBOARD_UPPER;
    } else { if (_kbmode & KBSTATE_SYMBOL) {
		keyboard_index = I_KEYBOARD_SYMBOL;
    } else { 
		if (_kbmode & KBSTATE_ANY_ACCENT) {
			if (KBSTATE_LFT_ACCENT & _kbmode) {keyboard_index = I_KEYBOARD_LOWER_ACCENT_1;}
			if (KBSTATE_RT_ACCENT  & _kbmode) {keyboard_index = I_KEYBOARD_LOWER_ACCENT_2;}
			if (KBSTATE_DOT_ACCENT & _kbmode) {keyboard_index = I_KEYBOARD_LOWER_ACCENT_3;} 
			if (KBSTATE_HAT_ACCENT & _kbmode) {keyboard_index = I_KEYBOARD_LOWER_ACCENT_4;}
		}
		keyboard_index = keyboard_index + (_kbmode & KBSTATE_CPS_OR_SHFT);
	}
	}
	}
	DrawSystemIcon(_kb_x0,_kb_y0,keyboard_index,PUT);
}

void open_keyboard_extended(unsigned char mode, unsigned char backup, int x, int y)
{
	_kb_x0 = x;
	_kb_y0 = y;
	
	_kb_bkup = backup;
	if (_kb_bkup<1 || _kb_bkup>4) {
		_kb_bkup = KB_BUFFER_BACKUP;
	}
	switch ((int)_kb_bkup) {
	case KB_BUFFER_BACKUP:
		BackupWindow(_kb_x0, _kb_y0, 
			_kb_x0+KB_IMG_WIDTH-1, _kb_y0+KB_IMG_HEIGHT,
			(unsigned char *)KB_BAKBUF);
		break;
	case KB_SWAPLCD_BACKUP:
		SwapLCD(_kb_x0<<8|_kb_y0, _kb_x0<<8|_kb_y0, 
			KB_IMG_WIDTH<<8|KB_IMG_HEIGHT, 0, 0);
		break;
	case KB_LCDCOPY_BACKUP:
		LCDCopy(REALTOVIRT);
		break;
	}
	
    _kblang = GetLanguageType();
    /*Spanish and Italian same as English*/
    if (_kblang>2) { _kblang = 0; }
	
    if (mode!=KBSTATE_PASSWORD) {
		if (mode & KBSTATE_FIRSTCAP) {
			mode = KBSTATE_FIRSTCAP | KBSTATE_CAPS;
		} 
		if (mode & KBSTATE_SYMBOL) {
			mode = KBSTATE_SYMBOL;
		} 
		if (mode & KBSTATE_LFT_ACCENT) {
			mode = mode & (KBSTATE_LFT_ACCENT | KBSTATE_CPS_OR_SHFT);
		}
		if (mode & KBSTATE_RT_ACCENT) {
			mode = mode & (KBSTATE_RT_ACCENT | KBSTATE_CPS_OR_SHFT);
		}
		if (mode & KBSTATE_DOT_ACCENT) {
			mode = mode & (KBSTATE_DOT_ACCENT | KBSTATE_CPS_OR_SHFT);
		}
		if (mode & KBSTATE_HAT_ACCENT) {
			mode = mode & (KBSTATE_HAT_ACCENT | KBSTATE_CPS_OR_SHFT);
		}
    }
    _kbmode = mode;
    _show_keyboard();
}

void open_keyboard(unsigned char mode)
{
	open_keyboard_extended(mode, KB_BUFFER_BACKUP, 0, 169);
}

void _keyboard_transition(char ctrl) 
{
    unsigned char newmode;
	
    if (( (_kbmode==KBSTATE_NORMAL || _kbmode==KBSTATE_CAPS) && !ctrl) || _kbmode==KBSTATE_PASSWORD) {
		return;
    }
    newmode = _kbmode;
    if (newmode & KBSTATE_SYMBOL) {
		newmode = KBSTATE_NORMAL;
    } else {
		if (newmode & KBSTATE_FIRSTCAP) {
			newmode = KBSTATE_NORMAL;
		}
		switch (ctrl) {
		case KBSTATE_LFT_ACCENT:
		case KBSTATE_RT_ACCENT:
		case KBSTATE_DOT_ACCENT:
		case KBSTATE_HAT_ACCENT:
			newmode = (newmode & (KBSTATE_CPS_OR_SHFT | ctrl)) ^ ctrl;
			break;
		case KBSTATE_SHIFT:
		case KBSTATE_CAPS:
			newmode = newmode ^ ctrl;
			break;
		case KBSTATE_SYMBOL:
			newmode = KBSTATE_SYMBOL;
			break;
		default:
			newmode = newmode & KBSTATE_CAPS;
			break;
		}
    }
    _kbmode = newmode;
    _show_keyboard();
}

char keyboard_is_open() {
	return (_kb_bkup!=0);
}

void close_keyboard()
{
	switch (_kb_bkup) {
	case KB_BUFFER_BACKUP:
		RestoreWindow(_kb_x0,_kb_y0,(unsigned char *)KB_BAKBUF, PUT);
		break;
	case KB_SWAPLCD_BACKUP:
		SwapLCD(_kb_x0<<8|_kb_y0, _kb_x0<<8|_kb_y0, 
			KB_IMG_WIDTH<<8|KB_IMG_HEIGHT, 0, 1);
		break;
	case KB_LCDCOPY_BACKUP:
		LCDCopy(VIRTTOREAL);
	}
	_kbmode=0; _kblang=0; _kb_x0=0;_kb_y0=169; _kb_bkup=0;
	return;
}

unsigned char _kb_check_pen(int x0, int y0, int x1, int y1,
							int penx, int peny) 
{
	
	unsigned char ret = 0,val = 0,px,py;
	int key;
	if (penx>x0 && penx<x1 && peny>y0 && peny<y1) {
		x0=x0+1; y0=y0+1; x1=x1-1; y1=y1-1;
		do {
			val = (penx>=x0 && penx<=x1 && peny>=y0 && peny<=y1)?1:0;
			if (val != ret) {
				ret = val;
				InverseLCDArea(x0+_kb_x0,y0+_kb_y0,x1+_kb_x0,y1+_kb_y0);
			}
			key = GetKey(&px,&py);
			peny = ((int)py) - _kb_y0;
			penx = ((int)px) - _kb_x0;
		} while (key==PENDOWN);
		if (ret) {
			InverseLCDArea(x0+_kb_x0,y0+_kb_y0,x1+_kb_x0,y1+_kb_y0);
		}
	}
	return ret;
}

char _kb_check_symbols(unsigned char *c, unsigned char *ctrl, int penx, int peny) 
{
	int row, col, x1;
	if (peny>=KB_SYMK_BOTTOMROW_Y0 && penx>=KB_SYMK_CANCEL_X0) {
		if (_kb_check_pen(KB_SYMK_CANCEL_X0,KB_SYMK_BOTTOMROW_Y0,KB_LASTCOL_X1,KB_BOTTOMROW_Y1,penx,peny)) {
			*ctrl = KBSTATE_SYMBOL;
		}
	} else {
		row = (peny+1)/KB_SYMKEY_HEIGHT;
		col = penx/KB_SYMKEY_WIDTH;
		*c = _kb_symbol_map[row][col];
		x1 = KB_SYMKEY_WIDTH*(col+1);
		if (x1>KB_LASTCOL_X1) { x1 = KB_LASTCOL_X1; }
		if (!_kb_check_pen(KB_SYMKEY_WIDTH*col,KB_SYMKEY_HEIGHT*row+KB_SYMK_YOFFSET,
			x1,KB_SYMKEY_HEIGHT*(row+1)+KB_SYMK_YOFFSET,penx,peny)) {
			*c = 0;
		}
	}
	return 0;
}

int _kb_check_spaceRow(unsigned char *c, unsigned char *ctrl, int penx, int peny)
{
	int col;
	col = penx/(KB_ACCENTKEY_WIDTH);
	if (col<4) {
		if (_kbmode!=KBSTATE_PASSWORD) {
			if (_kb_check_pen(col*KB_ACCENTKEY_WIDTH,KB_SPACEROW_Y0,(col+1)*KB_ACCENTKEY_WIDTH,KB_BOTTOMROW_Y1,penx,peny)) {
				*ctrl = KBSTATE_LFT_ACCENT << col;
			}
		}
	} else {
		if (_kb_check_pen(KB_SPACEBAR_X0,KB_SPACEROW_Y0,KB_SPACEBAR_X1,KB_BOTTOMROW_Y1,penx,peny)) {
			*c = ' ';
		} else {
			if (_kbmode!=KBSTATE_PASSWORD) {
				if (_kb_check_pen(KB_SYMBOLBUTT_X0,KB_SPACEROW_Y0,KB_LASTCOL_X1,KB_BOTTOMROW_Y1,penx,peny)) {
					*ctrl = KBSTATE_SYMBOL;
				}
			}
		}
	}
	return 1;
}

int _kb_check_mainRows(unsigned char *c, unsigned char *ctrl, int penx, int peny)
{
	int checked = 0,row,col;
	unsigned char accent;
	row = peny/KB_KEY_HEIGHT;
	col = (penx-_kb_line_offset[row])/KB_KEY_WIDTH;
	if (penx>=_kb_line_offset[row]) {
		*c = _kb_key_map[_kbmode&KBSTATE_CPS_OR_SHFT][row][col];
		if (_kbmode==KBSTATE_PASSWORD) {
			*c = _kb_key_map[1][row][col];
			if (*c=='`') {
				*c = 0;
			}
		}
		if (*c) {
			if (!_kb_check_pen(col*KB_KEY_WIDTH+_kb_line_offset[row],row*KB_KEY_HEIGHT,
				(col+1)*KB_KEY_WIDTH+_kb_line_offset[row],(row+1)*KB_KEY_HEIGHT,
				penx,peny)) {
				*c = 0;
			}
			checked=1;
			if ((*c)&KB_CHECKLOOKUP) {
				if ((*c)&KB_LANGUAGE_DEP) {
					*c = _kb_language_map[(*c)&KB_LOOKUP_IDMASK][_kblang];
				}
				if ((*c)&KB_CHECKLOOKUP && (*c)&KB_ACCENT_DEP) {
					switch (_kbmode & KBSTATE_ANY_ACCENT) {
					case KBSTATE_LFT_ACCENT:
						accent = 1;
						break;
					case KBSTATE_RT_ACCENT:
						accent = 2;
						break;
					case KBSTATE_DOT_ACCENT:
						accent = 3;
						break;
					case KBSTATE_HAT_ACCENT:
						accent = 4;
						break;
					default:
						accent = 0;
					}
					*c = _kb_accent_map[(*c)&KB_LOOKUP_IDMASK][accent];
				}
			}
		}
	}
	if (!checked) {
		if (_kbmode==KBSTATE_PASSWORD) {
			if (_kb_check_pen(_kb_line_end[0],0,KB_LASTCOL_X1,KB_KEY_HEIGHT,penx,peny)) {
				*c=KBKEY_BACKSPACE;
			}
		} else {
			if (_kb_line_offset[row]) {
				if (_kb_check_pen(0,row*KB_KEY_HEIGHT,_kb_line_offset[row],(row+1)*KB_KEY_HEIGHT,penx,peny)) {
					*ctrl = _kb_sidekey_map[row][0][0];
					*c = _kb_sidekey_map[row][0][1];
				}
			}
			if (_kb_check_pen(_kb_line_end[row],row*KB_KEY_HEIGHT,KB_LASTCOL_X1,(row+1)*KB_KEY_HEIGHT,penx,peny)) {
				*ctrl = _kb_sidekey_map[row][1][0];
				*c = _kb_sidekey_map[row][1][1];
			}
		}
	}
	return checked;
}

unsigned char check_keyboard(int key, int penx, int peny)
{
	int checked = 0;
	unsigned char c = 0, ctrl = 0;
	if (key==PENDOWN && keyboard_is_open()
		&& peny>_kb_y0 && peny<=_kb_y0+KB_BOTTOMROW_Y1
		&& penx>_kb_x0 && penx<=_kb_x0+KB_LASTCOL_X1) {
		peny = peny - _kb_y0;
		penx = penx - _kb_x0;
		if (_kbmode & KBSTATE_SYMBOL && !(_kbmode==KBSTATE_PASSWORD)) {
			_kb_check_symbols(&c,&ctrl,penx,peny);
		} else {
			if (peny>=KB_SPACEROW_Y0) {
				checked = _kb_check_spaceRow(&c,&ctrl,penx,peny);
			} else {
				_kb_check_mainRows(&c,&ctrl,penx,peny);
			}
		}
		if (c || ctrl) {
			_keyboard_transition(ctrl);
		}
	}
	return c;
}
