/* $Id: avio.c,v 1.2 1998/11/03 02:22:25 bill Exp $ */
/* 
 * avio.c
 * Some Avigo IO Routines
 *
 * By Dave Page
 * Ported to FreewareSDK 0.91b2 by Bill Baxter
 */

#include <avsys.h>
#include "avio.h"

char IoInput( char Port)
{
    char ret;
    _asm {
		ld a,_Port+0(ix)
		ld c,a
		in a,(c)
		ld _ret+0(ix),a
    }
    return ret;
}

void IoOutput( char Port, char Data)
{
    _asm {
		ld a,_Port+0(ix)
		ld c,a
		ld a,_Data+0(ix)
		out (c),a
    }
}

#define Bit( a) ( ( 1 << a) ^ 0x7)
int IoReadKey( int BitPos, int Mask, int Shift)
{
	int Key;

	IoOutput( AVIGO_KEY_IO_PORT, Bit( BitPos));
	Key = ( IoInput( AVIGO_KEY_IO_PORT) ^ Mask) & Mask;
	IoOutput( AVIGO_KEY_IO_PORT, 0);
        
	return( Key << Shift);
}

unsigned int IoUnsafeReadKeys( void)
{
	int Keys;

	Keys = IoReadKey( 1, 7, 0) | IoReadKey( 2, 1, 3) | IoReadKey( 0, 3, 4);
	return( Keys);
}

unsigned int IoReadKeys( void)
{
	int Keys;

        DisableInterrupts();
	Keys = IoReadKey( 1, 7, 0) | IoReadKey( 2, 1, 3) | IoReadKey( 0, 3, 4);
        EnableInterrupts();
	return( Keys);
}
