/* protos.h - header file for vexed */



#define cmReset 0x2000 /* event user command */
#define ItemPreferences 0x2001
#define ItemHowToPlay  0x2002
#define ItemAbout 0x2003

#define Boolean unsigned char /* replace type */

#define Left 1
#define Right 2
#define Up 3
#define Down 4
#define Erase 5

#define MaxLevels 59 /* 0 inclusive */

#define HighBeep 1
#define LowBeep 2
#define HighSweepLow 3

/* gfx.c */
void LoadBitmapResources();
void DrawLevel();
void UpdateStats();
void DrawIntro();
void EndSequence();
void AboutDialog();

/* game.c */
void LoadLevel(int levelnumber);
void MoveBlock(int sx, int sy, int direction);
Boolean PlayerMakeMove(int sx, int sy, int direction);

/* system.c */
Boolean CompareLevelArrays();

/* sound.c */
void SoundEffect(int effect);
void LoadPreferences();
void SavePreferences();
