/*
 * Vexed v1.4 - game.c "The actual code for making the game play"
 * Copyright (C) 1999 James McCombe (cybertube@earthling.net)
 *
 * Adaptation for the Avigo
 * Copyright (C) 2001 Jean-michel Bunouf (jeanmichel.bunouf@oreka.com)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */

#include <avsys.h>
#include <avgui.h>
#include <avicons.h>

#include "protos.h"

extern int level [1] [9] [11];
extern int current [9] [11];
extern int previous [9] [11]; 
extern int BlocksRemaining;

extern struct BitmapPtr {
  unsigned int bank;
  unsigned int *image;
} Bitmap [10];

extern struct {
	Boolean
		PieceMoveAnim,          /* whether the movement of a piece by the user is animated */
		GravityAnim,            /* whether the gravity effect is animated */
		EliminationAnim,        /* whether piece elimination is animated */
		Sound;                  /* whether sound is on or off */
	int CurrentLevel, SolvedLevels; /* stores the level the user was last at */
} VexedPreferences;

extern int stored [9] [11];


void LoadLevel(int levelnumber)
{
int x, y;

if (levelnumber <= MaxLevels) 
	{
	for (y = 0; y <= 7; y ++)
		for (x = 0; x <= 9; x ++)
			stored[y][x] = 0; /* clear the game state memory */

	if (levelnumber == 59) /* game complete */
		{
		EndSequence();
		VexedPreferences.CurrentLevel = 0;
		levelnumber = 0;
		}

	/* move the appropriate level array into the current array */
	for (y = 0; y <= 7; y ++)
		for (x = 0; x <= 9; x ++)
			current[y][x] = level[levelnumber][y][x];

	/* draw the level to the screen */
	DrawLevel();
	}
else
	MessageBox("Access Denied!\nYou haven't solved upto\nthis level before!", mfWarning | mfOKButton); /* AlertAccessDenied */	

}

void MoveBlock(int sx, int sy, int direction)
{
int i;

if (direction == Right)
	/* if current block is neither air nor a wall block and if the one to the right is just air then go ahead and move it */
	if ((!((current[sy][sx] == 0) || (current[sy][sx] == 9))) && (current[sy][sx + 1] == 0))
		{
		SoundEffect(HighBeep);
		for (i = 0; i <= 16; i ++)
			{
			if (!i == 0)
				{
				ClearLCDArea((sx * 16) + (i - 1),(sy + 1) * 16,(sx * 16) + (i - 1)+15,(sy + 1) * 16+15,0); /* erase old bitmap */
				if (!VexedPreferences.PieceMoveAnim)
					break; /* don't do animation since it's switched off */
				}
			
			DrawIcon( (sx * 16) + i, (sy + 1) * 16,Bitmap[current[sy][sx]].bank, Bitmap[current[sy][sx]].image,OR); /* animate block move */
			Delay_10ms();
			}	
		current[sy][sx + 1] = current[sy][sx];
		current[sy][sx] = 0;

		DrawIcon( (sx + 1) * 16, (sy + 1) * 16, Bitmap[current[sy][sx + 1]].bank, Bitmap[current[sy][sx + 1]].image, OR); /* draw final block */
		SoundEffect(LowBeep);
		}

if (direction == Left)
	/* if current block is neither air nor a wall block and if the one to the left is just air then go ahead and move it */
	if ((!((current[sy][sx] == 0) || (current[sy][sx] == 9))) && (current[sy][sx - 1] == 0))
		{
		SoundEffect(HighBeep);
		for (i = 0; i <= 16; i ++)
			{
			if (!i == 0)
				{
				ClearLCDArea((sx * 16) - (i - 1),(sy + 1) * 16,(sx * 16) - (i - 1)+15,(sy + 1) * 16+15,0); /* erase old bitmap */
				if (!VexedPreferences.PieceMoveAnim)
					break; /* don't do animation since it's switched off */
				}
			DrawIcon((sx * 16) - i, (sy + 1) * 16,Bitmap[current[sy][sx]].bank,Bitmap[current[sy][sx]].image,OR); /* animate block move */
			Delay_10ms();
			}	
		current[sy][sx - 1] = current[sy][sx];
		current[sy][sx] = 0;
		DrawIcon(((sx - 1) * 16), (sy + 1) * 16,Bitmap[current[sy][sx - 1]].bank,Bitmap[current[sy][sx - 1]].image,OR); /* draw final block */
		SoundEffect(LowBeep);
		}

if (direction == Down)
	/* if current block is neither air nor a wall block and if the one below is just air then go ahead and move it */
	if ((!((current[sy][sx] == 0) || (current[sy][sx] == 9))) && (current[sy + 1][sx] == 0))
		{
		SoundEffect(HighBeep);
		for (i = 0; i <= 16; i ++)
			{
			if (!i == 0)
				{
				ClearLCDArea((sx * 16),((sy + 1) * 16) + (i - 1),(sx * 16)+15,((sy + 1) * 16) + (i - 1)+15,0); /* erase old bitmap */
				if (!VexedPreferences.GravityAnim)
					break; /* don't do animation since it's switched off */
				}
			DrawIcon((sx * 16), ((sy + 1) * 16) + i,Bitmap[current[sy][sx]].bank,Bitmap[current[sy][sx]].image,OR ); /* animate block move */
			Delay_10ms();
			}	
		current[sy + 1][sx] = current[sy][sx];
		current[sy][sx] = 0;
		DrawIcon((sx * 16), (sy + 2) * 16, Bitmap[current[sy + 1][sx]].bank, Bitmap[current[sy + 1][sx]].image,OR ); /* draw final block */
		SoundEffect(LowBeep);
		}

if (direction == Erase)
	/* if current block is neither air nor a wall block */
	if (!((current[sy][sx] == 0) || (current[sy][sx] == 9)))
		{
		current[sy][sx] = 0; /* erase the block from the current level array */
		BlocksRemaining --; /* decrease the number of remaining blocks by one */
		SoundEffect(HighSweepLow);
		if (VexedPreferences.EliminationAnim) /* only animate of prefs says it should */
			for (i = 8; i >= 0; i --)
				{
				ClearLCDArea((sx * 16) + i,((sy + 1) * 16) + i,(sx * 16) + i+2 * (8 - i)-1,((sy + 1) * 16) + i+2 * (8 - i)-1,0); /* erase the on screen block */
				Delay_10ms();
				}
		else
			{
			ClearLCDArea( sx * 16,(sy + 1) * 16,sx * 16+15,(sy + 1) * 16+15,0); /* erase the on screen block */
			}
		UpdateStats(); /* updates the statistics text on screen */
		}
}

void CheckGravity()
{
int x, y;

/* go through it bottom to top so as all the blocks tumble down on top of each other */
for (y = 7; y >= 0; y --)
	for (x = 9; x >= 0; x --)
		MoveBlock(x, y, Down);
}

void CheckMatches()
{
int x, y;
int mark [9] [11]; /* array for holding blocks marked for removal */

/* just go through from top to bottom marking pieces which have matches above, below, left and to the right of them */
for (y = 0; y <= 7; y ++)
	for (x = 0; x <= 9; x ++)
		{
		mark[y][x] = 0; /* ALWAYS initialise each element in the 'mark' array */
		if (!((current[y][x] == 0) || (current[y][x] == 9))) /* only check if its not air or a wall block */
			{ 
			mark[y][x] |= (current[y - 1][x] == current[y][x]); /* if there is an identical piece above then mark this piece */
			mark[y][x] |= (current[y + 1][x] == current[y][x]); /* if there is an identical piece below then mark this piece */
			mark[y][x] |= (current[y][x + 1] == current[y][x]); /* if there is an identical piece to the right then mark this piece */
			mark[y][x] |= (current[y][x - 1] == current[y][x]); /* if there is an identical piece to the left then mark this piece */
			}
		}

/* go through the current level array checking if a piece is marked and if so, remove it */
for (y = 0; y <= 7; y ++)
	for (x = 0; x <= 9; x ++)
		if (mark[y][x]) MoveBlock(x, y, Erase);
}

Boolean PlayerMakeMove(int sx, int sy, int direction) /* returns true if this move completes the level */
{
int x, y;

MoveBlock(sx, sy, direction); /* simply pass parameters through to MoveBlock function */

while (CompareLevelArrays()) /* keep cycling round until neither checking for gravity or matching blocks has any effect */
	{
	for (y = 7; y >= 0; y --)
		for (x = 9; x >= 0; x --)
			previous[y][x] = current[y][x];

	CheckGravity(); /* check for gravity (really only to make previous different to current so next loop will work) */
	while (CompareLevelArrays()) /* keep checking for gravity until all blocks are resting on something */
		{
		for (y = 7; y >= 0; y --)
			for (x = 9; x >= 0; x --)
				previous[y][x] = current[y][x];

		CheckGravity(); /* check for gravity defying blocks and bring them down to earth! */
		}
	CheckMatches(); /* check for any groups of matching blocks */
	}
return !BlocksRemaining;
}

Boolean CompareLevelArrays()
{
int x, y;

for (y = 0; y <= 7; y ++)
	for (x = 0; x <= 9; x ++)
		if (!(previous[y][x] == current[y][x]))
			{
			return 1;
			break;
			}
return 0;
}
