/*********************************

      AVGUI demo Test Program
        for use with FWSDK
 Public Domain - Randy Gill 11/99

********************************************************

This app is a demonstration of the Avgui library, and
will display a DeskBox (window) with various controls
the user can interract with.  It is released to the
public domain with the hope that it will be helpful as
an example.

********************************************************/

#include <avsys.h>
#include <avdata.h>
#include "avgui.h"
#include "ptextbox.h"

/* Create our user-defined commands */
#define cmShowBox    0x2000
#define cmShowPicker 0x2001
#define cmCheck      0x2002

/*
   Define resource ID counter variable.  This is incremented during each
   'Create...' to ensure each control has a unique ID. If this were a large
   application, we'd use a different technique and store the ID for each
   control so we could reuse their memory blocks.
*/
int id=100;

/*
  Define the data-holding variables to associate with our controls
*/
double NFNum = 123.456;
unsigned char NSNum = 5;
char PickerString[21];
unsigned char BoolValue = 0;
unsigned char MenuValue = 1;
char Checked = 0;
char TBString[30];
char TFString[30];
_DATE date;
_TIME time;  /* KNO */

/*
  The text of our message boxes - in codeseg to save RAM.
*/
#pragma codeseg
char Message[]="This is a message box.";
char MessageUp[]="cmPgUp message received";
char MessageDn[]="cmPgDn message received";
char LabelCaption[]="I'm a label.";  /* KNO */
#pragma defaultseg
 
/*
  Avigo apps return a code indicating the program to run next.
  APPLICATION indicates the apps. menu
*/
int ExitCode = APPLICATION;

/*
  Define our main menu.  Every Avigo menu has {"\0", 0, 0} as the last item.
  Note: '/016' is the 'empty checkbox' in the Avigo character set. Since release
  of AVGUI_k2 theMenuFldMenu is now also used for the new PCONTROLMENU.
*/
MENUITEM MainMenu[]=
{
   {"Show Box", cmShowBox, lstDisplay},
   {"Show Picker", cmShowPicker, lstDisplay},
   {"Check Box    \016", cmCheck, lstDisplay | lstUnderLine},
   {"Exit", cmCancel, lstDisplay},
   {"\0", 0, 0} 
};

/*
  Define another menu, to be used with our PMENUFIELD control.  Notice for
  MenuFields the command is set to 0 for every item.
*/
MENUITEM MenuFldMenu[]=
{
   {"First", 0, lstDisplay},
   {"Second", 0, lstDisplay},
   {"Third", 0, lstDisplay},
   {"\0", 0, 0} 
};

/*
  Declare pointers for our DeskBox and each of our controls
*/
PDESKBOX *dsk;
PBUTTON *Show;
PNUMBERFIELD *NumFld;
PNUMBERSET *NumSet;
PBOOLFIELD *BoolFld;
PMENUFIELD *MenuFld;
PTEXTBOX *TB;
PDATEFIELD *DateFld;
PTIMEFIELD *TimeFld;  /* KNO */
PTEXTFIELD *TextFld;  /* KNO */
PLABEL *Label; /* KNO */
PCONTROLMENU *ControlMenu; /* KNO */

/*
  The following are static strings used by the program.  We're using
  '#pragma codeseg' to store them in ROM instead of RAM, since we do not
  change them in the program.  They would function just fine in RAM, but
  since you can have *only one* 16k bank of RAM, it's best to conserve
  where possible.
  KNO:  Picker-titles also have to be in ROM and doesn't work from RAM!
*/
#pragma codeseg
char BtnLabel[]="MBox";
char Btn2Label[]="Picker";
char Btn3Label[]="Memo";
char WindowTitle[]="GUI Test App";
char defaultPrompt[]="Enter Data";
char txtPrompt[]="Enter Text";
char datePrompt[]="Enter Date";
char timePrompt[]="Enter Time";
char numberPrompt[]="Enter a Number";
#pragma defaultseg

/*
  Replacement draw handler for our DeskBox.  The default handler will draw
  all the controls we later insert into the DeskBox.  We'll call that
  function first, then print all our label strings
*/
void dsk_draw(VOID_PTR view)
{ 
   PDESKBOX_draw(view); 
   SetFontType(PRPFONT11N);
/*
   WriteString(50, 15, "PDESKBOX",DRAW_BLACK);
   O.K., we'll now trust, that the PDESKBOX_draw-function works.
   Since introduction of PCONTROLMENU, it'll display in this line.
*/  
   WriteString(4, 30, "PTEXTBOX",DRAW_BLACK);
   WriteString(4, 44, "PTEXTFIELD",DRAW_BLACK);
   WriteString(4, 68, "PNUMBERSET",DRAW_BLACK);
   WriteString(4, 90, "PMENUFIELD", DRAW_BLACK);
   WriteString(4, 100, "PLABEL", DRAW_BLACK); /* KNO */
   WriteString(4, 121, "PNUMBERFIELD", DRAW_BLACK);
   WriteString(4, 146, "PBUTTON", DRAW_BLACK);
   WriteString(4, 170, "PBOOLFIELD", DRAW_BLACK);
   WriteString(4, 185, "PDATEFIELD", DRAW_BLACK);
   WriteString(4, 200, "PTIMEFIELD", DRAW_BLACK);  /* KNO */
}

/*
   Replacement event handler for DESKBOX.  This is where we do what we
   need to do in response to the events we receive
*/
void dsk_handleEvent(VOID_PTR view, unsigned int *evType, unsigned char x,
                     unsigned char y)
{  
   /* Do default handling (process pen events, etc...) */
   
   PDESKBOX_handleEvent(view,evType,x,y); 

   /* For this app, we're only interested in the 'command' events */

   if (*evType == evCommand)
   {
      switch(TOWORD(x,y)) /* TOWORD combines the 8-bit 'x' and 'y' into one
                             16-bit value, the 'command'. */
      {
         case cmShowBox :
                           MessageBox(Message, mfInformation | mfOKButton);
                           ClearEvent(evType);
                           break;
         case cmShowPicker :
                           ExecPicker(PickerString,20);
                           dsk_draw(view); 
                           ClearEvent(evType);
                           break;
         case cmPgUp :     MessageBox(MessageUp,mfWarning | mfYesButton);
                           ClearEvent(evType);
                           break;
         case cmPgDn :
                           MessageBox(MessageDn, mfWarning | mfYesButton);
                           ClearEvent(evType);
                           break;
         case cmMemo :
                           /* Exit the app, then run the MEMO applet */
                           ExitCode = MEMO;
                           PutEvent(evCommand, HIGBYTE(cmQuit), LOWBYTE(cmQuit));
                           ClearEvent(evType);
                           break;
         case cmCheck :    /* below is a little 'trick' to use checkbox menu items */
                           if (Checked)
                           {
                              strcpy(MainMenu[2].item ,"Check Box    \016");
                           }
                           else
                           {
                              strcpy(MainMenu[2].item ,"Check Box    \036");
                           }
                           Checked = 1 - Checked;  /* toggle value */
                           ClearEvent(evType);
                           break;
        default:
           break;
      }
   }
}

/*
  Here's where our main program starts
*/
int main()
{
    strcpy(PickerString,"Hello Picker!");
    strcpy(TFString,"Edit me.");

    GetDate(&date);
    GetTime(&time);

   /* First we create our DeskBox and controls */
   dsk = (PDESKBOX *)CreateDeskBox(id++, 0, 0, 159, 239, 
         MK_FAR_PTR(WindowTitle),MK_FAR_PTR(MainMenu), NULL_FP,
         bafClose | bafDotTitle | bafComLine); 
   Show = (PBUTTON *)CreateButton(id++, 70, 143, 120, 159, MK_FAR_PTR(BtnLabel),
          (unsigned short) cmShowBox, bttToDo);
   NumFld = (PNUMBERFIELD *)CreateNumberField(id++, 72, 120,
            (unsigned char *) &NFNum, DTREAL, MK_FAR_PTR(numberPrompt));
   NumSet = (PNUMBERSET *)CreateNumberSet(id++, 70, 67, 0, 10, 1, &NSNum);
   BoolFld = (PBOOLFIELD *)CreateBoolField(id++, 70, 168, &BoolValue, 1);
   MenuFld = (PMENUFIELD *)CreateMenuField(id++, 70, 88, &MenuValue,
             MK_FAR_PTR(MenuFldMenu), 0);
   TB = (PTEXTBOX *)CreateTextBox(id++, 70, 30, 120, TBString,
        tbtBoxBorder | tbtDotted);

   /* Datefield by RCN */
   DateFld = (PDATEFIELD *)CreateDateField(id++, 72, 185, (char*)&date, MK_FAR_PTR(datePrompt));

   /* Time, text & label fields by KNO */
   TimeFld = (PTIMEFIELD *)CreateTimeField(id++, 72, 200, (char*)&time, MK_FAR_PTR(timePrompt));
   TextFld = (PTEXTFIELD *)CreateTextField(id++, 72, 43, 150, 57, TFString,
             PRPFONT11N, 12, 15, MK_FAR_PTR(txtPrompt));
   Label = (PLABEL *)CreateLabel(id++, 72, 100, 120, 111, MK_FAR_PTR(LabelCaption),
           lbofAlignLeft|lbofDefineFont, PRPFONT11N);
   ControlMenu=(PCONTROLMENU *)CreateControlMenu(id++, 0, 14, 159, 26,
              MK_FAR_PTR(MainMenu), MK_FAR_PTR((char *)"ControlMenu"), 2, cmtPrimaryFull);

   /* Now we 'insert' our controls into the DeskBox */
   PGROUP_insert((VOID_PTR) dsk, (PVIEW *) Show);
   PGROUP_insert((VOID_PTR) dsk, (PVIEW *) NumFld);
   PGROUP_insert((VOID_PTR) dsk, (PVIEW *) NumSet);
   PGROUP_insert((VOID_PTR) dsk, (PVIEW *) BoolFld);
   PGROUP_insert((VOID_PTR) dsk, (PVIEW *) MenuFld);
   PGROUP_insert((VOID_PTR) dsk, (PVIEW *) TB);
   PGROUP_insert((VOID_PTR) dsk, (PVIEW *) DateFld);
   PGROUP_insert((VOID_PTR) dsk, (PVIEW *) TimeFld);     /* KNO */
   PGROUP_insert((VOID_PTR) dsk, (PVIEW *) TextFld);     /* KNO */
   PGROUP_insert((VOID_PTR) dsk, (PVIEW *) Label);       /* KNO */
   PGROUP_insert((VOID_PTR) dsk, (PVIEW *) ControlMenu); /* KNO */

  /*
    InsertButton and InsertPageArrow are two handy functions.  They both 
    create the control, and insert it into the DeskBox, at the bottom (under the
    dotted line if your DeskBox has one).
  */
   InsertButton(dsk, id++, MK_FAR_PTR(Btn2Label), cmShowPicker, bttBasic, 0);
   InsertButton(dsk, id++, MK_FAR_PTR(Btn3Label), cmMemo, bttGoTo, 1);
   InsertPageArrow(dsk, id++, (PVIEW *) dsk);

  /*
    Now we will assign the 'methods' we implemented earlier to our DeskBox.
    There are two functions that do this.  Use 'BankedAssign1()' if your function
    has only one argument, and 'BankedAssign2()' if it has two or more.
    A 'method' will never have zero arguments.  Note: two functions are needed
    because of the differences in the way parameters are passed in the FWSDK and
    in the Avigo internally. The 'Official $DK' uses just one: BankedAssign()
  */
   BankedAssign1(dsk->draw,dsk_draw);
   BankedAssign2(dsk->handleEvent,dsk_handleEvent);

  /*
    PTEXTBOX is not a 'stock' control, but rather a sort of custom control derived
    from PBUTTON.  Because of the way the BankedAssign macros work, we need to assign
    its handlers in main() if we're going to use it.
  */
   BankedAssign1(TB->draw, PTEXTBOX_draw);
   BankedAssign2(TB->drawStatus, PTEXTBOX_drawStatus);
   BankedAssign2(TB->handleEvent, PTEXTBOX_handleEvent);

  /*
    Our PNUMBERFIELD control allows you to specify a title for the picker, but for some reason
    they have to be in ROM. So put the declaration between #pragma codeseg and #pragma defaultseg.
    The PTEXTBOX currently has no way to specify a title.  Because of this, we're going to use a
    function that will set the picker default.  If we wanted to be more elaborate, we could override
    the ...handleEvent() handler for this control, and set the title differently, before calling
    the original handler.
  */
   SetPickerTitle(MK_FAR_PTR(defaultPrompt));

  /*
    Here's the 'magic' function that does most of the work of the program.
    ExecView() will draw, and redraw when needed, our deskbox and all our controls.
    It will continuously poll for pen and button input, then send messages to the
    controls and the DeskBox itself, and invoke their handlers.  It will exit when
    it processes a cmCancel or cmQuit command message.
  */
   ExecView((PGROUP_PTR) dsk);

  /*
    Finally, we'll 'destroy' the DeskBox to free up its resource memory.  Note
    that we don't have to destroy the controls we inserted, as they are destroyed
    when their 'parent' (the DeskBox) is.
  */
   Destroy((VOID_PTR) dsk);

  /* Hey, we're done! That wasn't so bad, was it? */
   return ExitCode;

}
