#include <avsys.h>
#include <avicons.h>

/* For test purposes, to see if drawicon draws correct, I get the icon-address
   of a system-icon, and draw it one time by DrawSystemIcon() and one time by
   DrawIcon(), so we can easily compare the result. */

void GetSystemIconAddress(int icon_number, unsigned int *bank, unsigned int *offset)
{
    _asm
    {
        ld   l, _offset+0(ix)
        ld   h, _offset+1(ix)
        push hl
        ld   e, _bank+0(ix)
        ld   d, _bank+1(ix)
        ld   l, _icon_number+0(ix)
        ld   h, _icon_number+1(ix)
        call 0x016B
        pop  bc
    }
}

/* declare the icon for drawicon */
extern unsigned int skyline;

void main()
{
    unsigned char penx, peny;
    unsigned int ioffset=0, ibank=0;
    char s[30];
    char t[10];

    ClearLCD(0);
    WriteString(0,0,"DrawSystemIcon(0, 12, 4, 1);",DRAW_BLACK);
    DrawSystemIcon(0, 12, 4, 1);

    WriteString(0,50,"GetSystemIconAddress(4,",DRAW_BLACK);
    WriteString(0,62,"  &ibank, &ioffset);",DRAW_BLACK);
    WriteString(0,74,"DrawIcon(0, 98, ibank,",DRAW_BLACK);
    WriteString(0,86,"  (unsigned int *)ioffset, 1);",DRAW_BLACK);
    GetSystemIconAddress(4, &ibank, &ioffset);
    DrawIcon(0, 98, ibank, (unsigned int *)ioffset, 1);
    while(!(GetKey(&penx,&peny)))
      ;
    PenBeep();
    while((GetKey(&penx,&peny)))
      ;

    ClearLCD(0);

    /* now we draw our custom-icon */
    AssignBankNo(skyline, ibank);
    DrawIcon(0, 0, ibank, &skyline, 0);

    while(!(GetKey(&penx,&peny)))
      ;
    PenBeep();
    return;
}
