	.module	sdk

	.area	_code
	.include "syscall.asm"

	.globl	retaddr
	.globl	retbank

	.globl	_SetDisplayDirection
	.globl	_GetDisplayDirection
	.globl	_SetDotSize
	.globl	_GetDotSize
	.globl	_DrawDot
	.globl	_SetLineSize
	.globl	_GetLineSize
	.globl	_DrawLine
	.globl	_DrawRect
	.globl	_FillRect
	.globl	_DrawCircle
	.globl	_FillCircle
	.globl	_ClearLCD
	.globl	_ClearLCDArea
	.globl	_InverseLCDArea
	.globl	_GrayLCDArea
	.globl	_BackupWindow
	.globl	_RestoreWindow
	.globl	_SetToVirtualLCD
	.globl	_SetToRealLCD
	.globl	_LCDCopy
	.globl	_SwapLCD
	.globl	_GetActiveLCDType
	.globl	_DrawIcon
	.globl	_GetTime
	.globl	_GetDate
	.globl	_GetBatteryValue
	.globl	_SetDrawArea
	.globl	_PenBeep
	.globl	_WarningBeep
	.globl	_ClearKeyBuffer
	.globl	_SetAutoPowerOff
	.globl	_strstr
	.globl	_strcpy
	.globl	_strcat
	.globl	_strcmp
	.globl	_strcmpi
	.globl	_stricmp
	.globl	_strncmp 
	.globl	_strncmpi
	.globl	_strnicmp
	.globl	_strncpy
	.globl	_strncat
	.globl	_SetFontType
	.globl	_GetFontType
	.globl	_WriteChar
	.globl	_WriteString
	.globl	_WriteAlignString
	.globl	_GetLanguageType
	.globl	_GetStringLength
	.globl	_open_file
	.globl	_read_file
	.globl	_lseek_file
	.globl	_close_file
	.globl	_randomize
	.globl	_random
	.globl	_GetRamBank
	.globl	_SetRamBank
	.globl	_GetKey
	.globl	_memcpy
	.globl	_Delay_10ms
	.globl	_Buzzer
	.globl	_strlen
	.globl	_memset
	.globl	_memcpy
	.globl	_memcmp
	.globl	_MessageBox
	.globl	_MemoryErrorMessageBox
	.globl	_GetAvigoVersion

_GetRamBank = GetRamBank
_SetRamBank:
	pop		hl
	ld		(retaddr),hl
	pop		hl
	ld		(retbank),hl
	pop		hl
	ld		(retfunc),hl
	pop		hl
	call	SetRamBank
	push	bc
	ld		hl,(retfunc)
	push	hl
	ld		hl,(retbank)
	push	hl
	ld		hl,(retaddr)
	push	hl
	ret
_SetDisplayDirection:
	call	pop1
	.dw	SetDisplayDirection
_GetDisplayDirection:
	call	GetDisplayDirection
	ld	h,#0
	ld	l,a
	ret
_SetDotSize:
	call	pop1
	.dw	SetDotSize
_GetDotSize:
	call	GetDotSize
	ld	h,#0
	ld	l,a
	ret
_DrawDot:
	call	pop2
	.dw	DrawDot
_SetLineSize:
	call	pop1
	.dw	SetLineSize
_GetLineSize:
	call	GetLineSize
	ld	h,#0
	ld	l,a
	ret
_DrawLine:
	call	pop2
	.dw	DrawLine
_DrawRect:
	call	pop2
	.dw	DrawRect
_FillRect:
	call	pop2
	.dw	FillRect
_DrawCircle:
	call	pop2
	.dw	DrawCircle
_FillCircle:
	call	pop2
	.dw	FillCircle
_ClearLCD:
	call	pop1
	.dw	ClearLCD
_ClearLCDArea:
	call	pop2
	.dw	ClearLCDArea
_InverseLCDArea:
	call	pop2
	.dw	InverseLCDArea
_GrayLCDArea:
	call	pop2
	.dw	GrayLCDArea
_BackupWindow:
	call	pop2
	.dw	BackupWindow
_RestoreWindow:
	call	pop2
	.dw	RestoreWindow
_SetToVirtualLCD:
	call	pop1
	.dw	SetToVirtualLCD
_SetToRealLCD:
	call	pop1
	.dw	SetToRealLCD
_LCDCopy:
	call	pop1
	.dw	LCDCopy
_SwapLCD:
	call	pop2
	.dw	SwapLCD
_GetActiveLCDType:
	call	GetActiveLCDType
	ld	h,#0
	ld	l,a
	ret
_DrawIcon:
	call	pop2
	.dw	DrawIcon
_GetTime:
	call	pop1
	.dw	GetTime
_GetDate:
	call	pop1
	.dw	GetDate
_GetBatteryValue:
	call	pop1
	.dw	GetBatteryValue
_SetDrawArea:
	call	pop2
	.dw	SetDrawArea
_PenBeep = PenBeep
_WarningBeep = WarningBeep
_ClearKeyBuffer = ClearKeyBuffer
_SetAutoPowerOff:
	call	pop2
	.dw	SetAutoPowerOff
_strstr:
	call	pop2
	.dw	strstr
_strcpy:
	call	pop2
	.dw	strcpy
_strcat:
	call	pop2
	.dw	strcat
_strcmp:
	call	pop2
	.dw	strcmp
_strcmpi:
	call	pop2
	.dw	strcmpi
_stricmp:
	call	pop2
	.dw	stricmp
_strncmp :
	call	pop2
	.dw	strncmp 
_strncmpi:
	call	pop2
	.dw	strncmpi
_strnicmp:
	call	pop2
	.dw	strnicmp
_strncat:
	call	pop2
	.dw	strncat
_strncpy:
	call	pop2
	.dw	strncpy
_strlen:
	call	pop1
	.dw	strlen
_SetFontType:
	call	pop1
	.dw	SetFontType
_GetFontType:
	call	GetFontType
	ld	h,#0
	ld	l,a
	ret
_WriteChar:
	call	pop2c
	.dw	WriteChar
_WriteString:
	call	pop2c
	.dw	WriteString
_WriteAlignString:
	call	pop2c
	.dw	WriteAlignString
_GetLanguageType:
	call	GetLanguageType
	ld	l,a
	ld	h,#0
	ret
_GetStringLength:
	call	pop2
	.dw	GetStringLength
_open_file:
	call	pop2c
	.dw	open_file 
_read_file:
	call	pop2
	.dw	read_file
_lseek_file:
	call	pop2
	.dw	lseek_file
_close_file:
	call	pop1
	.dw	close_file
_randomize = randomize
_random:
	call	pop1
	.dw	random
_GetKey:
	call	pop2c
	.dw		GetKey
_memcpy:
	call	pop2
	.dw	memcpy
_memset:
	call	pop2
	.dw	memset
_memcmp:
	call	pop2
	.dw	memcmp
_Delay_10ms = Delay_10ms
_Buzzer:
	call	pop2
	.dw	Buzzer
_MessageBox:
	pop		hl
	ld		(retaddr),hl
	pop		hl
	ld		(retbank),hl
	pop		hl
	ld		(retfunc),hl
	call	GetRomBank
	pop		bc
	pop		de
	push	hl
	push	bc
	ld		bc,#MessageBox
	call	banked_function_call
	ex		de,hl
	ld		hl,(retfunc)
	push	hl
	ld		hl,(retbank)
	push	hl
	ld		hl,(retaddr)
	push	hl
	ex		de,hl
	ret
_MemoryErrorMessageBox:
	ld		bc,#MemoryErrorMessageBox
	call	banked_function_call
	ret
_GetAvigoVersion:
	ld		iy,#0
	add		iy,sp
	ld		h,0x7(iy)
	ld		l,0x6(iy)
	ld		bc,#GetAvigoVersion
	call	banked_function_call
	ret

pop1:
	pop		hl
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	pop		hl
	ld		(retaddr),hl
	pop		hl
	ld		(retbank),hl
	pop		hl
	ld		(retfunc),hl
	ld		hl,#push1
	ex		(sp),hl
	push	bc
	ret
push1:
	push	bc
	ex		de,hl
	ld		hl,(retfunc)
	push	hl
	ld		hl,(retbank)
	push	hl
	ld		hl,(retaddr)
	push	hl
	ex		de,hl
	ret

pop2:
	pop		hl
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	pop		hl
	ld		(retaddr),hl
	pop		hl
	ld		(retbank),hl
	pop		hl
	ld		(retfunc),hl
	pop		de
	ld		hl,#push2
	ex		(sp),hl
	ex		de,hl
	push	bc
	ret
push2:
	push	bc
	push	bc
	ex		de,hl
	ld		hl,(retfunc)
	push	hl
	ld		hl,(retbank)
	push	hl
	ld		hl,(retaddr)
	push	hl
	ex		de,hl
	ret

pop2c:
	pop		hl
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	pop		hl
	ld		(retaddr),hl
	pop		hl
	ld		(retbank),hl
	pop		hl
	ld		(retfunc),hl
	pop		de
	ld		hl,#push2c
	ex		(sp),hl
	ex		de,hl
	push	bc
	ret
push2c:
	push	bc
	push	bc
	ld		hl,(retfunc)
	push	hl
	ld		hl,(retbank)
	push	hl
	ld		hl,(retaddr)
	push	hl
	ld		h,#0
	ld		l,a
	ret

