/************************************************************
** ROCKS by Alejandro Garza, agarza@campus.mty.itesm.mx ***
**
** You ARE allowed to copy, mutilate, etc. this source code
** AS LONG as you cite the original author(s), as included in
** this and the README file.
**
** compile with the Avigo Freeware SDK, just type "avmake"
**
************************************************************/
/* 10:00 p.m. 27/11/2000 */
/* 12:22 a.m. 04/12/2000 */
/* v.94 07:30 p.m. 12/03/01 */
/* v.95 10:30 a.m. 14/03/01 */
/* v.96 01:54 p.m. 16/03/01 */
/* v.97 02:58 p.m. 24/04/01 */
/* v.1.00 07:08 p.m. 21/06/2001 */
#include <avsys.h>
#include <avdata.h>
#include <keyboard.h>
#include "gfx.h"
#include "avio.h"


#define _DEBUG 1

/** SCREEN **/
#define SCREENWIDTH	158
#define SCREENHEIGHT	178
#define HEX_SCREEN	0xA0B0
#define HEX_ALL	0xC0F0
#define VWIDTH	1580
#define VHEIGHT	1770
#define VTOP 	-80            /* #define VTOP -80 #define VLEFT -80 */
#define VLEFT 	-40
#define VBOT 	1740
#define VRIGHT 	1560
#define SCORE_Y0 181
#define SCORE_Y1 193
#define SCORE_Y2 205
#define SCORE_Y3 217
#define SCORE_X	42
#define FGPEN	DRAW_BLACK
#define BGPEN	DRAW_WHITE
#define SPRITEMODE	GFX_BLIT_OR

/** MENU **/
#define MENUX 50
#define MENUY 50
#define MENUW 65
#define MENUH 70
#define MENUTITLEH 12
#define MENUTEXTY MENUY+MENUTITLEH+4

/** COMPUTER **/
#define COMPUTERSPRITE SPRITE(0,81)
#define COMPUTERSPRITE2 SPRITE(48,31)
#define MAXCOMPUTERTICKS 75
#define COMPUTERY 181
int computer_ticks=0;
char computer_msg[80];

/** STARS **/
#define MAXSTARS 8
int starsx[MAXSTARS],starsy[MAXSTARS];
int starsx2[MAXSTARS],starsy2[MAXSTARS];

/** SHOTS **/
#define MAXSHOTSTEPS 12
#define MAXSHOTS 5
int shotnum=0;
int lastshotindex=0;
int shot[MAXSHOTS],shotx[MAXSHOTS],shoty[MAXSHOTS],shotxi[MAXSHOTS],shotyi[MAXSHOTS],shotsteps[MAXSHOTS];
int shotvel[]= { 0,-50, 25,-50, 35,-35, 50,-25, 
             50,0, 50,25, 35,35, 25,50, 
             0,50, -25,50, -35,35, -50,25,
             -50,0, -50,-25, -35,-35, -25,-50};


/** DEBRIS **/
#define TOTALDEBRIS 12
#define MAXDEBRISSTEP 20
int deb_x[TOTALDEBRIS],deb_y[TOTALDEBRIS];
int deb_xi[TOTALDEBRIS],deb_yi[TOTALDEBRIS];
int debris=0;
int debrisquantity=0;
char debrismsg[10];
int debrismsgx,debrismsgy;

/** ASTEROIDS **/
#define TOTALROCKS 30
#define MAXSTARTROCKS 7
int x[TOTALROCKS],y[TOTALROCKS];
int xi[TOTALROCKS],yi[TOTALROCKS];
int active[TOTALROCKS];
int type[TOTALROCKS];
int radius[TOTALROCKS];
int diameter[TOTALROCKS];
int spw[TOTALROCKS];
int sph[TOTALROCKS];
int lastobject=0;
int activeobjects;
int startobjects;
char* rocksprites[] =
{
  SPRITE(0,0),
  SPRITE(24,0),
  SPRITE(40,0)
};
int rockspw[]={ 3,2,1 };
int rocksph[]={ 21,14,7 };
/*int rockradius[]={ 100,60,50 };  */ /* antes 30 el ultimo */
int rockradius[]={ 130,70,60 };  
int rockscore[]={ 10,20,50 };
int rockspeed[]={ 1,2,4 };
int rockxl[]={ VWIDTH-50, VWIDTH-30, VWIDTH-15 };
int rockyl[]={ VHEIGHT-50, VHEIGHT-30, VHEIGHT-15 };
int rockhalf=0;

int dx,dy;
int r,d,thistype;
#define MAXVEL 10


/** SHIP **/
#define SHIPWH 40 /* Ship's width (and height) in virtual units */
#define SHIPWH2 80 
int shipkaboom=0;
int shipactive=0;
int shiptransparent=0;
int shipblink=1;
int shipx,shipy,shipxi,shipyi;
int vel[]= { 0,-3, 1,-3, 2,-2, 3,-1, 
             3,0, 3,1, 2,2, 1,3, 
             0,3, -1,3, -2,2, -3,1,
             -3,0, -3,-1, -2,-2, -1,-3};
char* shipsprites[] =
{
  SPRITE(0,64), SPRITE(8,64), SPRITE(16,64), SPRITE(24,64), SPRITE(32,64), SPRITE(40,64), SPRITE(48,64), SPRITE(56,64),
  SPRITE(0,72), SPRITE(8,72), SPRITE(16,72), SPRITE(24,72), SPRITE(32,72), SPRITE(40,72), SPRITE(48,72), SPRITE(56,72)
};
#define MAXSHIELDS 100
#define SHIELDSPRITE SPRITE(40,15)
int shieldlevel=0;
int shields=0;
int shieldk=3;  /** the larger this number, the less effect shields "bounce" other objects **/
int lastcollisiontick=0;

int direction;
int dirindex;

/** LEVELS **/
int score=0;
int next_extra=0;
#define EXTRASHIPSCORE 5000
int level=0;
int levelticks=0;
int lives;
struct levelinfo
{
  char *name;
  int rock_quantity;
  int minelayer_activity;
  int blackhole_activity;
  int human_activity;
};
struct levelinfo LevelInfo[]= { 
 { "Good,luck!",5,1,1,1},
 { "Look out,for UFOs", 2, 0, 0, 0},
 { "Mineship,within,sector", 3, 1, 0, 0},
 { "Warning!,unstable,region,of space", 3, 0 ,1, 0},
 { "Rescue,drifting,crewmen", 4, 0, 0, 1},
 { "So far...,so good!,  =)", 4, 1, 1, 0}
};
struct levelinfo *currentlevelinfo;  /* Pointer to current level's information */


int max_prob;

/** BLACKHOLE **/
#define MAXBLACKHOLECYCLE 400
int gravity, gravityx, gravityy, gravityf;
int blackholecycle;
#define BLACKHOLESPRITE SPRITE(0,24)

/** UFO **/
#define UFOWH 80
int ufo, ufox, ufoy, ufodir, ufoframe;
int ufovel[]= { 0,-21, 7,-21, 14,-14, 21,-7, 
             21,0, 21,7, 14,14, 7,21, 
             0,21, -7,21, -14,14, -21,7,
             -21,0, -21,-7, -14,-14, -7,-21};
char* ufosprites[] =
{
  SPRITE(40,8),
  SPRITE(40,8),
  SPRITE(48,8),
  SPRITE(48,8),
  SPRITE(56,8),
  SPRITE(56,8)
};

/** MINELAYER **/
#define MINELAYERSPRITE SPRITE(48,81)
int minelayer=0;
int minelayerx,minelayery,minelayerxi,minelayeryi;
int minelayerdir;

/** MINES **/
#define MAXMINES 6
#define MAXMINET 12
#define MINER 200
#define MINESPRITE SPRITE(56,0)
int minex[MAXMINES],miney[MAXMINES];
int minet[MAXMINES];
int miner[]={ 0,0,30,120,150,160,160,120,150,140,100,70,40 };
int mine_radius;

/** HUMANS **/
#define MAXHUMANS 6
int humanx[MAXHUMANS], humany[MAXHUMANS];
int humandir[MAXHUMANS];
int human[MAXHUMANS];
#define HUMANSPRITE	SPRITE(40,81)
#define HUMANR 40
char *humanmsg[]={ "Agh!", "Shit!", "Ouch!", "Crap!" };

/** HIGHSCORETABLE **/
#define HIGHSCOREX 20
#define HIGHSCOREY 20
#define MAXHIGHSCORES 5
#define MAXINITIALLENGTH 20

/** General... **/
char buffer[80];
int p,t,i,j;
int key,pendown,lastkey;
int count;
unsigned char penx,peny;
int want_to_quit=0;
char sndflag;
#define LOGOSPRITE SPRITE(0,48)

struct hiscore {
  int score;
  unsigned char initials[MAXINITIALLENGTH];
  int level;
};

/* Preferences */
struct {
  unsigned char sound;
  unsigned char stars;
  struct hiscore hiscores[MAXHIGHSCORES];
} Prefs;
char *default_initials[]= { "-- E-mail me","-- please! =)","-- Love to Erika","------------------","-- Jano" };



/*** FUNCTIONS ******************************/
void LoadPreferences()
{
	/* load application preferences */
	if (GetPreferenceLen(CurrentAppID))
		ReadPreference(CurrentAppID, 0, &Prefs, sizeof(Prefs));
	else
	{		
		Prefs.sound=(1==0);
		Prefs.stars=(1==1);
		for (i=0;i<5;i++) {
			Prefs.hiscores[i].score=(MAXHIGHSCORES-i)*2000;
			strcpy((char *)&Prefs.hiscores[i].initials,default_initials[i]);
		}
	};
}


void SavePreferences()
{
	/* write out the application preferences */
	SavePreference(CurrentAppID, &Prefs, sizeof(Prefs));
}

void buzzer(int a)
{
     _asm
     {

         push af         /* save registers */
         push bc
         push hl
         push de
         di              /* disable interruption */
     }
     if (a==1) /* explosion 1 */
     _asm {
         ld hl,#sample   /* sample starting adr */
         ld bc,#0x08     /* sample length */
     }
     if (a==2) /* light tap */
     _asm {
	ld hl,#sample2   /* sample starting adr */
        ld bc,#0x01    /* sample length */
     }
     if (a==3) /* heavy tap */
     _asm {
	ld hl,#sample3   /* sample starting adr */
        ld bc,#0x03    /* sample length */
     }
     if (a==4) /* shortest beep */
     _asm {
	ld hl,#sample4   /* sample starting adr */
        ld bc,#0x04    /* sample length */
     }


     _asm {
play:    ld e,#0x8       /* 8 bits to analyse */
         ld d,(hl)       /* take a byte */
playb:   sra d           /* shift right */
         jr nc,reset     /* bit = 0 ? */

set:     ld a,(#0xc00d)  /* buzzer = 1 */
         or #0x08
         out (#0x28),a
         jr suite

reset:   ld a,(#0xc00d)  /* buzzer=0 */
         and #0xf7
         out (#0x28),a

suite:   ld a,#0x1a       /* delay */
loop:    nop
         nop
         nop
         nop
         dec a
         jr nz,loop

         dec e           /* last bit ? */
         jr nz, playb
         inc hl          /* next byte */
         dec bc          /* last byte ? */
         ld a, b
         or c
         jr nz, play

         ei              /* enable interruptions */
         pop de          /* restore registers */
         pop hl
         pop bc
         pop af
         jp end
sample:
.db 0xff,0xf,0x1e,0x1e,0xc7,0xc3,0xc3,0xe3,0x1,0x1f,0x3e,0xe0,0xc1,0xe3,0xe3,0x5
sample2:
.db 0x1
sample3:
.db 0x3e,0x1e,0x9e
sample4:
.db 0xa0,0xa0,0xa0,0xa0

end:

     }

  /*
  SetSysSnd(1);
  PenBeep();
  SetSysSnd(0);*/
}

void draw_debris()
{ 
  if (!debris) return;
  if (debris>=MAXDEBRISSTEP) { debris=0; *debrismsg=0; return; }
  if (*debrismsg!=0) {
    SetFontType(PRPFONT7N);
    WriteString(debrismsgx,debrismsgy,debrismsg,FGPEN);
  }
  SetDotSize(2);
  for (t=0; t<debrisquantity; t++) {
    deb_x[t]+=deb_xi[t];
    deb_y[t]+=deb_yi[t];
    if (debris<MAXDEBRISSTEP) { DrawDot(deb_x[t]/10,deb_y[t]/10,FGPEN); }
  }
  debris++;
}

void init_debris(int debx,int deby,int debxi,int debyi,char *msg)
{  
  int t;

  debrisquantity=3;
  for (t=0;t<debrisquantity;t++) {
    deb_x[t]=debx;
    deb_y[t]=deby;
    deb_xi[t]=(debxi/5)+10-random(20);
    deb_yi[t]=(debyi/5)+10-random(20);
  }

  if (msg!=(char *)0) {
    debrismsgx=debx/10;
    debrismsgy=deby/10-5;
    strcpy(debrismsg,msg);
  } else {
    *debrismsg=0;
  }
  debris=1;
}

void game_menu()
{
  unsigned char savedFontType;

  int selection=0;
  unsigned char options[60];

  savedFontType=GetFontType();

  strcpy(&options[0],"Return");
  strcpy(&options[10],Prefs.sound?"Sound-off":"Sound-on"); 
  strcpy(&options[20],Prefs.stars?"Stars-off":"Stars-on"); 
  strcpy(&options[30],"Main");
  strcpy(&options[40],"Quit Game");

  SetToVirtualLCD(0);
  GrayLCDArea(1,1,SCREENWIDTH,SCREENHEIGHT);  
  FillRect(MENUX+5,MENUY+5,MENUX+5+MENUW,MENUY+5+MENUH,DRAW_GRAY);
  FillRect(MENUX,MENUY,MENUX+MENUW,MENUY+MENUH,BGPEN);
  DrawRect(MENUX,MENUY,MENUX+MENUW,MENUY+MENUH,FGPEN);
  SetFontType(PRPFONT7N);
  for (i=0;i<=4;i++) {
    WriteString(MENUX+14,MENUTEXTY+(i*10),&options[i*10],0);
  }
  FillRect(MENUX,MENUY,MENUX+MENUW,MENUY+MENUTITLEH,FGPEN);  /* Window name */
  SetFontType(PRPFONT11N);
  WriteString(MENUX+2,MENUY+1,"Game menu",1);

  SetToRealLCD(1);
  while(IoReadKeys());

  while(-1)
  {
	SetToVirtualLCD(0);
	FillRect(MENUX+2,MENUTEXTY,MENUX+10,MENUY+MENUH-2,BGPEN);
	gfx_blit(MENUX+2,MENUTEXTY+1+(selection*10),1,8,shipsprites[4],SPRITEMODE);
	SetToRealLCD(1);
	
	while ( (!IoReadKeys()) && ((key=GetKey(&penx,&peny))!=APPLICATION)  );

	if (key==APPLICATION) { want_to_quit=2; break; }

	key=IoReadKeys();

        if (key==IO_KEY_PGUP) {
		selection--;
		if (selection<0) selection=4 ;
		if (Prefs.sound) buzzer(2);
	}
	if (key==IO_KEY_PGDN) {
		selection++;
		if (selection>4) selection=0;
		if (Prefs.sound) buzzer(2);
	}
	if (key==IO_KEY_TODO || key==IO_KEY_MEMO || key==IO_KEY_SCHEDULE || key==IO_KEY_ADDRESS) {
		if (Prefs.sound) buzzer(4);
		if(selection==0) break;
		if(selection==1) { Prefs.sound=1-Prefs.sound; break; }
		if(selection==2) { Prefs.stars=1-Prefs.stars; break; }
		if(selection==3) { want_to_quit=1; break; }
		if(selection==4) { want_to_quit=2; break; }
	}
	while(IoReadKeys());
  }
  while(IoReadKeys());
  SetFontType(savedFontType);
}

void draw_sky()
{ 
  ClearLCDArea(1,1,SCREENWIDTH,SCREENHEIGHT,0);
  if (Prefs.stars) {SetDotSize(0);
    for (j=0;j<MAXSTARS;j++) {
      DrawDot(starsx[j],starsy[j],FGPEN);
    }
  }
}


void update_lives()
{
  SetToVirtualLCD(0);	
  SetDrawArea(0x0000, HEX_ALL);
  FillRect(2,SCORE_Y3,50,SCORE_Y3+8,BGPEN);
  for (i=0;i<lives-1;i++) {
    gfx_blit(2+(8*i),SCORE_Y3,1,8,SPRITE(16,72),SPRITEMODE);
  }
  SetDrawArea(0x0000, HEX_SCREEN);
}

void update_score()
{
  if (score>=next_extra) {
    lives++;
    next_extra+=EXTRASHIPSCORE;
    init_computer("*****,Extra,ship!,*****");
    update_lives();
  }
  SetToVirtualLCD(0);	
  SetDrawArea(0x0000, HEX_ALL);
  SetFontType(PRPFONT7N);
  WriteString(SCORE_X,SCORE_Y1+2,itoa(level,buffer,10),0);
  WriteString(SCORE_X,SCORE_Y2+2,itoa(score,buffer,10),0);
  SetDrawArea(0x0000, HEX_SCREEN);
}

void update_shields()
{ 
  SetToVirtualLCD(0);	
  SetDrawArea(0x0000, HEX_ALL);
  FillRect(SCORE_X,SCORE_Y0,SCORE_X+20,SCORE_Y0+9,DRAW_GRAY);	
  FillRect(SCORE_X,SCORE_Y0,SCORE_X+shieldlevel/5,SCORE_Y0+9,DRAW_BLACK);
  SetDrawArea(0x0000, HEX_SCREEN);
}

void init_rockspeed(int t)
{
	int randomdir;

	/* randomize(); */
	randomdir=random(16)*2;
	xi[t]=vel[randomdir]*rockspeed[type[t]];
	yi[t]=vel[randomdir+1]*rockspeed[type[t]];
	
        radius[t]=rockradius[type[t]];
	diameter[t]=radius[t]*2;
        spw[t]=rockspw[type[t]];
        sph[t]=rocksph[type[t]];
}

void init_rocks()
{
       lastobject=0;

  	for (t=0;t<startobjects;t++) {
          x[t]=random(VWIDTH);
          y[t]=random(VHEIGHT); 
          active[t]=1;
          type[t]=0;
          init_rockspeed(t);
          lastobject++;
        }
  activeobjects=lastobject;
  rockhalf=lastobject/2;
}

void dupe_rock(int t)
{ int new;
  new=lastobject++;
  x[new]=x[t];
  y[new]=y[t];
  type[new]=type[t];
  active[new]=1;
  init_rockspeed(new);
  activeobjects++;
  rockhalf=lastobject/2;
}

void init_shots()
{ 
   for (shotnum=0;shotnum<MAXSHOTS;shotnum++) {
     shot[shotnum]=0;
   }
}


void init_ship()
{
  shipx=(VWIDTH/2)-SHIPWH; 
  shipy=(VHEIGHT/2)-SHIPWH;

  shieldlevel=MAXSHIELDS;

  direction=0;
  dirindex=2*direction;
  shipxi=0;
  shipyi=0;
  shipkaboom=0;
  shipactive=1;

  init_shots();
}


void kill_shot(int elshot,char *msg)
{
  shot[shotnum]=0;
  init_debris(shotx[elshot],shoty[elshot],shotxi[elshot],shotyi[elshot],msg);
}

int abs(val) {
  if (val>=0) return(val); else return(-val);
}

void ship_collision(int t)
{
  if (shields) {
    if (lastcollisiontick<levelticks-5) {
      /*if ( abs(x[t]-shipx) < abs(y[t]-shipy) ) 
       { shipxi=-shipxi; } else { shipyi=-shipyi; }*/

      if (t>-1) {
        xi[t]+=shipxi/shieldk;
        yi[t]+=shipyi/shieldk;

        /* Change direction of ship, depending on larger speed (x/y) */
        if (abs(shipxi)>abs(shipyi)) { 
          shipxi=-shipxi/2;
          shipyi=shipyi/2;
        } else {
          shipxi=shipxi/2;
          shipyi=-shipyi/2; 
        }
        /* Put some of the objects momentum onto the ship */
        if (abs(xi[t])>abs(shipxi)) shipxi+=xi[t]*2;
        if (abs(yi[t])>abs(shipyi)) shipyi+=yi[t]*2;
      }
      if (Prefs.sound) buzzer(4);
      lastcollisiontick=levelticks;
    }
  } else {
    shipkaboom=1;
  }
}

void init_humans()
{
  for (t=0;t<MAXHUMANS;t++) {
    human[t]=1;
    humanx[t]=random(VWIDTH);
    humany[t]=random(VHEIGHT);
    humandir[t]=random(16)*2;
  }
}

void move_humans()
{
  if (! currentlevelinfo->human_activity) return;

  for (t=0;t<MAXHUMANS;t++) {
    if (!human[t]) continue;

    if (abs(humany[t]-shipy)<HUMANR) {
      if (abs(humanx[t]-shipx)<HUMANR) {
        human[t]=0;
        score+=100;
        update_score();
	init_computer("Crewman,brought,on board");
        continue;
      }
    }
    humanx[t]+=vel[humandir[t]];
    humany[t]+=vel[humandir[t]+1];
            if (humanx[t]>VRIGHT) humanx[t]=VLEFT;
            if (humanx[t]<VLEFT) humanx[t]=VRIGHT;
            if (humany[t]>VBOT) humany[t]=VTOP;
            if (humany[t]<VTOP) humany[t]=VBOT;

    for (shotnum=0;shotnum<MAXSHOTS;shotnum++) {
      if (shot[shotnum]) {
        if (abs(humany[t]-shoty[shotnum])<50) {
          if (abs(humanx[t]-shotx[shotnum])<40) {
            human[t]=0;
	    kill_shot(shotnum,humanmsg[random(4)]);
          }
        }
      }
    }
    gfx_blit( (humanx[t]/10)-4,(humany[t]/10)-5,1,11,HUMANSPRITE,SPRITEMODE);
  }
}

void move_rocks()
{
   static int limit=0;
   static int first,last;
   static int rockx,rocky;

   levelticks++; /** internal level timer **/

	shipkaboom=0;

        for (t=0;t<lastobject;t++) { 
            if (active[t]!=1) continue;
	    rockx=x[t]; rocky=y[t];

            rockx+=xi[t];
            rocky+=yi[t]; 
            d=diameter[t];

	if ((levelticks%2==0 && t>=rockhalf) || (levelticks%2==1 && t<rockhalf)) {
           r=radius[t];

	  /** GRAVITY **/
	  if (gravity) {
	    if (levelticks%15==0) {
		if (rockx>gravityx) { xi[t]-=gravityf; } else { xi[t]+=gravityf; }
		if (rocky>gravityy) { yi[t]-=gravityf; } else { yi[t]+=gravityf; }	
            }
	  }


	  /* Did a rock hit the ship? */
	  /*** TO GAIN speed in execution, first compare the y coordinate...
			why?? because the screen is slightly larger in the y-dimension,
			so theres less probability that a collision will occur there.
			THEN and only if the Y-coord indicates "collision", then
			go ahead and check the x-dimension for collisions =)) */

	
	  /** DEBUG **/
          /**
          DrawRect((shipx-d)/10,(shipy-d)/10,(shipx+SHIPWH2)/10,(shipy+SHIPWH2)/10,FGPEN);
          SetDotSize(3);
          DrawDot(rockx/10,rocky/10,FGPEN);
          **/

	  if (shipy>rocky) 
            if (shipy<rocky+d) 
  	      if (shipx>rockx) 
                if (shipx<rockx+d) ship_collision(t);
	  
          /* Lo alcanz un disparo? */
          for (shotnum=0;shotnum<MAXSHOTS;shotnum++) {
           if (shot[shotnum]) {
             dy=shoty[shotnum]-rocky;
             if (dy>0) 
               if (dy<d) { 
                dx=shotx[shotnum]-rockx;
  	        if (dx>0) 
                  if (dx<d) {
	            /* Shot hits rock */
	            if (Prefs.sound) buzzer(3);

                    /** Add score only if ship's shot **/
                    if (shot[shotnum]==1) 
 	  	    {  
 			score+=rockscore[type[t]]; 
			update_score();
		    }
                    kill_shot(shotnum,0);

		    /* Split rock */
                    if (type[t]<2)  
                    {
                 	type[t]++;
                  	/* Center new rock(s) */
                  	rockx+=r/2; rocky+=r/2;

	                /* "bump" the rock according to the shot velocity */
                  	xi[t]+=shotxi[shotnum]/2; yi[t]+=shotyi[shotnum]/2;

                  	init_rockspeed(t);
                  	dupe_rock(t); /* Crear una nueva como esta */
                    } else {
                  	active[t]=0;
                  	activeobjects--;
                  	continue; /* Para que no lo dibuje de nuevo... */
                    }
		x[t]=rockx;y[t]=rocky;

                    break;
              }
	     }
            } /** if (shot[shotnum]) **/
	  } /** for (shotnum... **/

            limit=0;
            if (rockx>VRIGHT) rockx=VLEFT, limit=1;
            if (rockx<VLEFT) rockx=VRIGHT, limit=1;
            if (rocky>VBOT) rocky=VTOP, limit=1;
            if (rocky<VTOP) rocky=VBOT, limit=1;
            if (limit) {
              if (xi[t]>MAXVEL)  xi[t]=MAXVEL;
              if (xi[t]<-MAXVEL) xi[t]=-MAXVEL;
              if (yi[t]>MAXVEL)  yi[t]=MAXVEL;
              if (yi[t]<-MAXVEL) yi[t]=-MAXVEL;
            }

	} /* IF (t>=rockhalf).... */

         if (rocky+d<VHEIGHT) {
            gfx_blit(rockx/10,rocky/10,spw[t],sph[t],rocksprites[type[t]],SPRITEMODE);
          } else {
            gfx_blit(rockx/10,rocky/10,spw[t],(VHEIGHT-rocky)/10,rocksprites[type[t]],SPRITEMODE);
	    /*DrawRect(rockx/10,rocky/10,(rockx+d)/10,(VHEIGHT)/10,FGPEN);*/
          }

	x[t]=rockx; y[t]=rocky;

        }
	
}


void move_shots()
{
 SetDotSize(2);
 for (shotnum=0;shotnum<MAXSHOTS;shotnum++) {
   if (shot[shotnum]==0) continue;
   if (shotsteps[shotnum]++ >MAXSHOTSTEPS) { shot[shotnum]=0;continue; }

	/** GRAVITY **/
	if (gravity) {
		if (shotx[shotnum]>gravityx) { shotxi[shotnum]-=gravityf; } else { shotxi[shotnum]+=gravityf; }
		if (shoty[shotnum]>gravityy) { shotyi[shotnum]-=gravityf; } else { shotyi[shotnum]+=gravityf; }
	} 

  shotx[shotnum]+=shotxi[shotnum];
  shoty[shotnum]+=shotyi[shotnum];
  if (shotx[shotnum]>VWIDTH || shotx[shotnum]<0 || shoty[shotnum]>VHEIGHT || shoty[shotnum]<0) {
	shot[shotnum]=0; continue; 
  }

  /* Check enemy shots... */
  if (shot[shotnum]==2) {
    dy=abs(shoty[shotnum]-shipy);
    if (dy<80) {
        dx=abs(shotx[shotnum]-shipx);
        if (dx<80) {
            shot[shotnum]=0;

            if (!shields) {
              shipkaboom=1;
            } else {
              shieldlevel-=50;
              if (shieldlevel<0) {
                shieldlevel=0;
                shipkaboom=1;
              }
              update_shields();
            }

            return;
         
        }
    }
  } else {
    if (ufo) {  
      dy=shoty[shotnum]-ufoy;
      if (dy>0) {
        if (dy<UFOWH) {
          dx=shotx[shotnum]-ufox;
          if (dx>0) {
            if (dx<UFOWH) {
              kill_shot(shotnum,"250");
              score+=250;
	      update_score();
              if (Prefs.sound) buzzer(1);
              ufo=0;
            }
          } 
        }
      }
    } /* if (ufo) */
  }

  DrawDot(shotx[shotnum]/10,shoty[shotnum]/10,FGPEN);
 }
}

void erase_computer()
{
  SetDrawArea(0x0000, HEX_ALL);
  FillRect(80,180,160,240,BGPEN);
  SetDrawArea(0x0000, HEX_SCREEN);
  computer_ticks=0;
}

void init_computer(char *msg)
{
  computer_ticks=1;
  strcpy(computer_msg,msg);
}

void draw_computer()
{ static int cx,cy,ci,cs;

  if (computer_ticks==0) return;

  /** Initialize computer display **/
  if (computer_ticks==1) {
    SetDrawArea(0x0000, HEX_ALL);
    gfx_blit(118,COMPUTERY,5,47,COMPUTERSPRITE,SPRITEMODE);
    FillRect(80,COMPUTERY,122,COMPUTERY+34,BGPEN);
    DrawRect(80,COMPUTERY,122,COMPUTERY+34,FGPEN);
    SetDotSize(0);
    DrawDot(80,COMPUTERY,BGPEN); DrawDot(122,COMPUTERY,BGPEN);     DrawDot(80,COMPUTERY+34,BGPEN); DrawDot(122,COMPUTERY+34,BGPEN);
    DrawLine(100,COMPUTERY+34,106,COMPUTERY+34,BGPEN);
    gfx_blit(95,COMPUTERY+34,2,6,COMPUTERSPRITE2,SPRITEMODE);

    SetDrawArea(0x0000, HEX_SCREEN);
    ci=0;
    cx=82;
    cy=COMPUTERY+1;
  }

  if (computer_ticks>MAXCOMPUTERTICKS) {
    erase_computer();
    return;
  }

  if (ci<strlen(computer_msg)) {     
    if (computer_msg[ci]==',') { 
      if (cx>82) {
        cx=82; cy+=7; ci++; return;
      } else { 
	ci++; 
      }
    } 
    SetDrawArea(0x0000, HEX_ALL);

    SetFontType(PRPFONT7N);
    buffer[0]=computer_msg[ci]; buffer[1]=0;
    cs=GetStringLength(buffer,PRPFONT7N);
 
    /** "Bubble" Width == 38 pixels **/
    if (cx+cs>=120) { cx=82; cy+=7; } 

    WriteChar(cx,cy,computer_msg[ci],0);
    SetDrawArea(0x0000, HEX_SCREEN);

    cx+=cs;
    if (cx>=120) { cx=82; cy+=7; }
    ci++; 
  }
  
  computer_ticks++;
}


void init_screen()
{ 
  SetDrawArea(0x0000, HEX_ALL);
  SetToVirtualLCD(0);
  ClearLCD(0);

  /* Init. stars */
  for (i=0;i<MAXSTARS;i++) {
    starsx[i]=random(SCREENWIDTH);
    starsy[i]=random(SCREENHEIGHT);
  }
  /* Remove debris */
  debris=0; *debrismsg=0; 

  /** Border **/
  DrawRect(0,0,SCREENWIDTH+1,SCREENHEIGHT+1,FGPEN);
 
  /** Sky... **/
  draw_sky();

  /* Scoreboard */
  FillRect(0,180,70,220,BGPEN);
  SetFontType(PRPFONT11B);
  WriteString(2,SCORE_Y0,"Shield",0);
  WriteString(2,SCORE_Y1,"Level",0);
  WriteString(2,SCORE_Y2,"Score",0);
  update_lives();
  update_score();
  update_shields();

  SetDrawArea(0x0000, HEX_SCREEN);
}


void warp_level()
{
  static int v=0,inc=1,d2,v2;
  int sx,sy;

  for (j=0;j<MAXSTARS;j++) {
    starsx2[j]=starsx[j];
    starsy2[j]=starsy[j];
  }
  /* randomize(); */
  d=random(16)*2; /* Direction to move stars in */
  d2=(d/2)+8&15;  /* Direction ship should be pointing at */
  v=2;            /* Actual star vel */
  inc=1;          /* vel increment */
  sx=shipx/10;    /* ship position */
  sy=shipy/10;    

  SetDotSize(0);
  SetToVirtualLCD(0);	
  erase_computer();

  while (v!=0 && v<30 && !want_to_quit) {
    if(IoReadKeys()==IO_KEY_TODO) {
	game_menu();
    }
    SetToVirtualLCD(0);	
    ClearLCDArea(1,1,SCREENWIDTH,SCREENHEIGHT,0);

    if (direction==d2) {
      v+=inc;
      if (v==13) inc=-1;
     } else {
      if (direction>d2) direction--;
      if (direction<d2) direction++;
    }
    if (sx>SCREENWIDTH/2) sx-=2;
    if (sx<SCREENWIDTH/2) sx+=2;
    if (sy>SCREENHEIGHT/2) sy-=2;
    if (sy<SCREENHEIGHT/2) sy+=2;
    gfx_blit(sx,sy,1,8,shipsprites[direction],SPRITEMODE);  

    draw_debris();
 
    /* Move and draw all stars, with "trail" */
    for (j=0;j<MAXSTARS;j++) {
      /* Move half the stars half as fast... */
      if (j<=MAXSTARS/2) { v2=v; } else { v2=v/2; }
      starsx[j]=starsx[j]+(vel[d]*v2);
      starsy[j]=starsy[j]+(vel[d+1]*v2);

      if (starsx[j]>SCREENWIDTH) starsx[j]=0, starsx2[j]=0;
      if (starsx[j]<0) starsx[j]=SCREENWIDTH, starsx2[j]=SCREENWIDTH;
      if (starsy[j]>SCREENHEIGHT) starsy[j]=0, starsy2[j]=0;
      if (starsy[j]<0) starsy[j]=SCREENHEIGHT, starsy2[j]=SCREENHEIGHT;

      DrawLine(starsx2[j],starsy2[j],starsx[j],starsy[j],FGPEN); 

      starsx2[j]=starsx[j];
      starsy2[j]=starsy[j];
    }
    SetToRealLCD(1);
  }
}

void next_level(int messageswitch)
{
  if (messageswitch) warp_level();

  levelticks=0;
  lastcollisiontick=0;

  randomize();
  level++;

  currentlevelinfo=&LevelInfo[level%6];

  max_prob-=20;
  if (max_prob<20) max_prob=20;
  startobjects=currentlevelinfo->rock_quantity;  
 /*  startobjects++; */
 
  if (startobjects==1) startobjects=2;
  if (startobjects>MAXSTARTROCKS) startobjects=MAXSTARTROCKS;

  init_ship();
  debris=0;

  if (currentlevelinfo->human_activity) {
    init_humans();
  }

  init_rocks();
  init_mines();

  gravity=0;
  ufo=0;
  minelayer=0;

  if (!messageswitch) { 
    return;
  } 

  update_score();

  init_computer(currentlevelinfo->name);

  DrawRect(0,0,SCREENWIDTH+1,SCREENHEIGHT+1,FGPEN); /* Refresh screen border */
  /** antes de que aparezca la nave... */
  for (i=1;(i<=50 || shipkaboom) && !want_to_quit;i++) {
    if(IoReadKeys()==IO_KEY_TODO) {
	game_menu();
    }
    SetToVirtualLCD(0);

    draw_sky();
    move_rocks();
    move_humans();
    draw_computer();

    SetFontType(PRPFONT11B);
    WriteString((SCREENWIDTH/2)-21,SCREENHEIGHT/2-3,"level",0);
    WriteString((SCREENWIDTH/2)+19,SCREENHEIGHT/2-3,itoa(level,buffer,10),0);
    /*center_string(currentlevelinfo->name,PRPFONT11N,SCREENHEIGHT/2+10);*/
    SetToRealLCD(1);
  }
  shiptransparent=1;
}

void init_blackhole()
{
  blackholecycle=0;
  gravity=1;
  gravityx=(VWIDTH/4)+random(VWIDTH/2);
  gravityy=(VHEIGHT/4)+random(VHEIGHT/2);
  gravityf=2+random(3);

  strcpy(buffer,"FORCE ");
  buffer[6]=gravityf+48;
  buffer[7]=0;
  strcat(buffer,",BLACK,HOLE,OPENING!");

  init_computer(buffer);
}

void draw_blackhole()
{
  if (!gravity) return;
  blackholecycle++;
  if (blackholecycle>MAXBLACKHOLECYCLE) { 
    gravity=0; return;
  }
  gfx_blit(gravityx/10-20,gravityy/10-12,5,22,BLACKHOLESPRITE,SPRITEMODE);
}

void move_ship()
{ 
  static int sx,sy;


		/** GRAVITY **/
		if (gravity) {
                  if (levelticks%10==0) {
			if (shipx>gravityx) { shipxi-=gravityf; } else { shipxi+=gravityf; }
			if (shipy>gravityy) { shipyi-=gravityf; } else { shipyi+=gravityf; }	
                  }
		}

  shipx+=shipxi;
  shipy+=shipyi;
  if (shipx>VRIGHT) shipx=VLEFT;
  if (shipx<VLEFT) shipx=VRIGHT;
  if (shipy>VBOT)  shipy=VTOP;
  if (shipy<VTOP)  shipy=VBOT;
  sx=(shipx-SHIPWH)/10;
  sy=(shipy-SHIPWH)/10;

  if (shiptransparent) {
    shipblink++; 
    if (shipblink%4>=2) {
      gfx_blit(sx,sy,1,8,shipsprites[direction],SPRITEMODE);
    }
  } else {  
    gfx_blit(sx,sy,1,8,shipsprites[direction],SPRITEMODE);  
  }

  if (shields) {
    gfx_blit(sx-2,sy-2,2,12,SHIELDSPRITE,SPRITEMODE);   
  }
}

void init_ufo()
{
  ufo=1;
  ufox=VLEFT;
  ufoy=(VHEIGHT/4)+random(VHEIGHT/2);
  ufodir=4; /* Face right */
  ufoframe=0;

  if (level==1) { init_computer("ALERT!,ENEMY,ATTACK!"); }
}

void init_minelayer()
{ 
  if (minelayer) return;

  /* Init. position and direction */
  minelayerx=VRIGHT/10;
  minelayerxi=-1; /* FACE LEFT */
  minelayery=((VHEIGHT/4)+random(VHEIGHT/2))/10;
  init_computer("WARNING!MINESHIP,IN RANGE");
  minelayer=1;
}

int shoot(int x,int y,int xi,int yi,int dir,int type)
{
  lastshotindex++;
  if (lastshotindex==MAXSHOTS) lastshotindex=0;
  shotnum=lastshotindex;

  if (shot[shotnum]) return;
  if (Prefs.sound) buzzer(2);

  shot[shotnum]=type;
  shotxi[shotnum]=xi+shotvel[dir*2];
  shotyi[shotnum]=yi+shotvel[(dir*2)+1];
  shotx[shotnum]=x;
  shoty[shotnum]=y;
  shotsteps[shotnum]=0;
}

void init_mines() 
{
  for (t=0;t<MAXMINES;t++) minet[t]=0;
}

/* Place a mine where minelayer stands */
void lay_mine()
{
   for (t=0;t<MAXMINES;t++) {
    if (minet[t]==0) {
      minex[t]=(minelayerx*10)+30;
      miney[t]=(minelayery*10)+30;
      minet[t]=1;
      break;
    }
  }
}

void draw_mines()
{ 
  for (p=0;p<MAXMINES;p++) {
    if (minet[p]>0) {
      if (minet[p]==1) {
        /** Is ship near mine? **/
        dy=abs(miney[p]-shipy);
        if (dy<MINER) { 
          dx=abs(minex[p]-shipx);
          if (dx<MINER) {
            minet[p]++;
          }
        }
        gfx_blit(minex[p]/10,miney[p]/10,1,7,MINESPRITE,SPRITEMODE);
        continue;
      }

      /* Mine has exploded, count until explosion done */
      if (minet[p]>1) {
        mine_radius=miner[minet[p]];  /* Explosion radius */

        /** Is explosion near ship? **/
        dy=abs(miney[p]-shipy);
        if (dy<mine_radius) { 
          dx=abs(minex[p]-shipx);
          if (dx<mine_radius) {
            if (!shields) {
              shipkaboom=1;
            } else {
              shieldlevel-=5;
              update_shields();
            }
          }
        }
        /** Kill minelayer?? */
        if (minelayer) {
          if (abs(miney[p]-(minelayery*10))<mine_radius) {
            if (abs(minex[p]-(minelayerx*10))<mine_radius) {
  	      init_debris(minelayerx*10,minelayery*10,0,0,"500");
              minelayer=0;
  	      score+=500;
              update_score();
            }
          }
        }
        FillCircle(minex[p]/10,miney[p]/10,mine_radius/10,DRAW_GRAY || DRAW_XOR);

        if (minet[p]>MAXMINET) {
          minet[p]=0;
        } else {
          minet[p]++; 
        }
      }

    }
  }
}

void move_minelayer()
{ 
  if (!minelayer) return;

  if (minelayerx%20==0) {
    p=random(4);
    if (p==3) lay_mine();     /* Lay a mine */
  }
  
  minelayerx+=minelayerxi;
  if (minelayerx<-10) { 
    minelayer=0;
    return;
  }
  gfx_blit(minelayerx,minelayery,2,7,MINELAYERSPRITE,SPRITEMODE); 
}

void move_ufo()
{
  if (ufo==0) return;

  ufo++;
  ufoframe++;
  if (ufoframe>5) ufoframe=0;

  p=random(4);
  if (p==0) {
    if (shipy-ufoy>0) { ufodir=3+random(3); } else { ufodir=random(3); }
  } 

  if (ufo>10) {
    if (shipactive) shoot(ufox,ufoy,0,0,5+random(4),2);
    ufo=1;
  }

  ufox=ufox+ufovel[ufodir*2];
  ufoy=ufoy+ufovel[(ufodir*2)+1];

  /* if (ufox>VRIGHT || ufox <VLEFT || ufoy>VBOT || ufoy<VTOP) { */
  if (ufox>VRIGHT || ufoy<VTOP) { 
    ufo=0;
    return;
  }
  gfx_blit(ufox/10,ufoy/10,1,7,ufosprites[ufoframe],SPRITEMODE); 
}

/* Create enemies from nuthin' */
void spontaneous_generate()
{ 
  /* randomize(); */
  p=random(max_prob);
  if (p>2) return;

  /* Blackholes...*/
  if (!gravity) { 
    if (currentlevelinfo->blackhole_activity && p==0) {
      init_blackhole();
    }
  }
  if (!ufo) { 
    if (p==1) {
      init_ufo();
    }
  }
  if (!minelayer) {
    if (currentlevelinfo->minelayer_activity && p==2) {
      init_minelayer();
    }
  }
}


void animate()
{
  spontaneous_generate();

  SetToVirtualLCD(0);	

  /* update_shields(); */
  draw_sky();

  draw_debris();
 
  move_rocks();
  move_shots();
  move_ufo();
  move_minelayer();
  move_humans();

  draw_mines();

  move_ship();

  draw_blackhole();


  draw_computer();

  SetToRealLCD(1);
}

void thrust()
{
  /*if (Prefs.sound) buzzer(4);*/
  shipxi+=vel[dirindex];
  shipyi+=vel[dirindex+1];       
}

/* Animate ship being killed, continue moving rocks on their way... */
void kill_ship()
{
  init_shots(); /** Remove any loose shots */

  if (Prefs.sound) buzzer(1);
  debrisquantity=TOTALDEBRIS;
  for (t=0;t<TOTALDEBRIS;t++) {
    deb_x[t]=shipx;
    deb_y[t]=shipy;
    deb_xi[t]=(shipxi/2)+10-random(20);
    deb_yi[t]=(shipyi/2)+10-random(20);
  }
  debris=1;
  shipactive=0; 
  shot[shotnum]=0;

  lives--;
  update_lives();

  shipx=-100;

  /* Animate rocks for a while... */
  /*  AND check that ship is not in collision with any of them loose rocks, pardner */
  for(i=0;(i<=50 || shipkaboom || ufo) && !want_to_quit;i++) {
    if(IoReadKeys()==IO_KEY_TODO) {
	game_menu();
    }
    SetToVirtualLCD(0);	
    draw_sky();
    SetDrawArea(0x0000, HEX_SCREEN);

    draw_debris();

    move_rocks();
    move_ufo();
    move_minelayer();
    move_humans();

    draw_mines();
    draw_blackhole();
    draw_computer();

    if (lives==0) {
      SetFontType(PRPFONT11B);
      WriteString((SCREENWIDTH/2)-20,SCREENHEIGHT/2,"game over",0);
    }
    SetToRealLCD(1);
    SetDrawArea(0x0000, HEX_ALL);
  }
  init_ship();
  shiptransparent=1;
}

void center_string(char *msg, unsigned char font, unsigned char y)
{ int msgpixlen;
  unsigned char savedFontType;

  savedFontType=GetFontType();
  msgpixlen=GetStringLength(msg,font);
  SetFontType(font);
  WriteString((SCREENWIDTH/2)-(msgpixlen/2),y,msg,0);
  SetFontType(savedFontType);
}

int splash_screen()
{
  int framenum=0;

  init_screen();
  level=0;
  next_level(0);
  next_level(0);
  next_level(0);
  next_level(0);

  init_ufo();
  init_minelayer();
  shipactive=1;

  ClearKeyBuffer();

  while (-1) {
    SetToVirtualLCD(0);	

    if (framenum%200<100) {
      draw_sky();
      spontaneous_generate();
      draw_debris();
      move_rocks();
      move_ufo();
      move_shots();
      move_minelayer();
      draw_mines();
      draw_blackhole();
    }

    if (framenum%200==0) {
      SetDrawArea(0x0000, HEX_ALL);
      FillRect(0,SCREENHEIGHT+2,SCREENWIDTH,240,BGPEN);
      gfx_blit((SCREENWIDTH/2)-32,SCREENHEIGHT,8,16,LOGOSPRITE,SPRITEMODE); 
      center_string("by Alejandro Garza",PRPFONT11B,SCREENHEIGHT+20);
      center_string("agarza@campus.mty.itesm.mx",PRPFONT7N,SCREENHEIGHT+32);
      center_string("v1.00 (Jun 24 2001)",PRPFONT7N,SCREENHEIGHT+40);
      SetDrawArea(0x0000, HEX_SCREEN);
    }
    if (framenum%200==100) {
      SetDrawArea(0x0000, HEX_ALL);

      GrayLCDArea(1,1,SCREENWIDTH,SCREENHEIGHT);
      
      /** DRAW highscore table **/
      center_string("High scores",PRPFONT14B,HIGHSCOREY);       
      for (i=0;i<MAXHIGHSCORES;i++) {
        SetFontType(PRPFONT11B);
	WriteString(HIGHSCOREX,HIGHSCOREY+20+(15*i),itoa(Prefs.hiscores[i].score,buffer,10),0);
        SetFontType(PRPFONT7N);
	WriteString(HIGHSCOREX+45,HIGHSCOREY+22+(15*i),(char *)&Prefs.hiscores[i].initials,0);
      }

      FillRect(0,SCREENHEIGHT+2,SCREENWIDTH,240,BGPEN);
      SetFontType(PRPFONT11B);
      WriteString(0,SCREENHEIGHT+2,"Instructions:",0);
      SetFontType(PRPFONT7N);
      WriteString(0,SCREENHEIGHT+14,"Any key to start, TO DO quits.",0);
      WriteString(0,SCREENHEIGHT+22,"SCHED, MEMO keys to turn.",0);
      WriteString(0,SCREENHEIGHT+30,"UP/DN keys fire & thrust.",0);
      WriteString(0,SCREENHEIGHT+38,"ADDR key for shields.",0);
      SetDrawArea(0x0000, HEX_SCREEN);
    } 
    framenum++;

    SetToRealLCD(1);
    SetDrawArea(0x0000, HEX_ALL);
    
    key=GetKey(&penx,&peny);
    if (key!=0) { break; }
  }
  return(key);
}

void check_for_hiscore()
{ 
  struct hiscore dummy;
  /* Keyboard variables */
  unsigned char c=0;
  static char initials[MAXINITIALLENGTH]= "";
  int charindex=0;  

  SetSysSnd(sndflag);
  for (i=0;i<MAXHIGHSCORES;i++) {
    if (score>=Prefs.hiscores[i].score) {
      /** Shift rest of scores... */
      for (t=MAXHIGHSCORES-1;t>i;t--) {
        memcpy(&Prefs.hiscores[t],&Prefs.hiscores[t-1],sizeof(dummy));
      }
      Prefs.hiscores[i].score=score;
      Prefs.hiscores[i].level=level;
      SetToRealLCD(0);
      ClearLCD(0);
      gfx_blit((SCREENWIDTH/2)-32,1,8,16,LOGOSPRITE,SPRITEMODE); 
      center_string("New high score!",PRPFONT14B,HIGHSCOREY);
      center_string("Enter your initials",PRPFONT11N,HIGHSCOREY+20);
      center_string("and hit the ENTER key",PRPFONT11N,HIGHSCOREY+31);

      open_keyboard(KB_NO_BACKUP);

      while (c!=KBKEY_CR ) {
		key=GetKey(&penx,&peny);
		if ((c = check_keyboard(key, penx, peny))!=0) {
                  if (c==KBKEY_BACKSPACE && charindex>0) {
			initials[--charindex]=0;
			ClearLCDArea(0,100,159,130,0);
		 	center_string(initials, PRPFONT11B, 115);
                  }
		  if (c!=KBKEY_BACKSPACE && charindex<MAXINITIALLENGTH) {
			initials[charindex++]=c;
                        initials[charindex]=0;
			ClearLCDArea(0,100,159,130,0);
			center_string(initials, PRPFONT11B, 115);
                  } 
                  if (charindex==MAXINITIALLENGTH) { if (Prefs.sound) { buzzer(3); } }
		}

      }

      if (key==APPLICATION) { want_to_quit=2; }

      strcpy((char *)&Prefs.hiscores[i].initials,initials);
      close_keyboard();
      SetSysSnd(0);
      break; /* Dont check against any other high scores */
    }
  }
}

void init_game()
{
  lives=4;
  score=0;
  level=0;
  startobjects=0;
  computer_ticks=0;

  max_prob=100;
  next_extra=EXTRASHIPSCORE;

  init_screen();
}

int main_loop()
{

	while(!want_to_quit)
	{
                animate();             

		if (shields==0) {
			if (shieldlevel<=MAXSHIELDS) {
				shieldlevel++;
				update_shields();
			}
		} else {
	                shields=0; /** this will be activated if the shields key is pressed **/
		}
		
		/** are all the rocks done for? **/
                if (activeobjects==0) {
                  next_level(1);
                }
		if (shipkaboom && !shiptransparent) {
		  kill_ship();
		}
		if (lives==0) {
                  ClearKeyBuffer();
		  check_for_hiscore();
		  return(1);
		}

		key=IoReadKeys();

		if(key & IO_KEY_PGUP)
		{
			/* Check that button has not remained pressed */
			if (!(lastkey & IO_KEY_PGUP)) {
				shoot(shipx,shipy,shipxi,shipyi,direction,1);
			}
			shiptransparent=0;
		}
		if(key & IO_KEY_PGDN)
		{
			thrust(); 
			shiptransparent=0;
		}
		if(key & IO_KEY_MEMO)
		{
			direction++;
                        if (direction>15) direction=0;
                        dirindex=2*direction;
			shiptransparent=0;
		}
		if(key & IO_KEY_SCHEDULE)
		{
			direction--;
                        if (direction<0) direction=15;
                        dirindex=2*direction;
			shiptransparent=0;
		}
                if (key & IO_KEY_ADDRESS) {
	                if (shieldlevel>=5) {
				shields=1;
				shieldlevel-=5;
				update_shields();
			} else {
                          if (computer_ticks==0) 				init_computer("shields,depleted");
                        }
			shiptransparent=0;
                }
                if(key & IO_KEY_TODO)
		{
			game_menu();
		}
		lastkey=key;
	}
}

/*** MAIN PROGRAM ******************************/
int main()
{
	int key;

	/* Save sys. settings before starting up */
	sndflag=GetSysSnd();
	SetSysSnd(0);

	LoadPreferences();

	want_to_quit=0;

	while(want_to_quit!=2)
	{
		key=splash_screen();
                if (key==TASK || key==APPLICATION) break;

	        init_game();
                next_level(1);

		key=main_loop();
		if(key==APPLICATION)
		{
			break;
		}
		if (want_to_quit==1) want_to_quit=0;
	}

	/* CLEANUP and exit */
	SetSysSnd(sndflag);

	SetToRealLCD(0);
	SetDotSize(0);
        SetDrawArea(0x0000, HEX_ALL);

	SavePreferences();

	return(APPLICATION);
}