/* $Id: avio.h,v 1.2 1998/11/03 02:25:19 bill Exp $ */
/* 
 * avio.c
 * Some Avigo IO Routines
 *
 * By Dave Page
 * Ported to FreewareSDK 0.91b2 and commented by Bill Baxter
 */

#ifndef AVIO_INCLUDED
#define AVIO_INCLUDED

/* This is the port that the Avigo keyboard is connected to */
#define AVIGO_KEY_IO_PORT 0x01

/*
 * These are the bit flags returned by the keyboard routines
 */
#define IO_KEY_TODO		0x01
#define IO_KEY_TASK		0x01
#define IO_KEY_ADDRESS		0x02
#define IO_KEY_SCHEDULE		0x04
#define IO_KEY_MEMO		0x08
#define IO_KEY_PGUP		0x10
#define IO_KEY_PGDN		0x20
#define IO_KEY_BACKLIGHT	0x40


/* IoReadKeys returns an int of bit flags indicating which buttons
 * are currently pressed.  This routine disables interrupts before 
 * reading the keyboard state and re-enables after.
 */
unsigned int IoReadKeys(void);


/* IoUnsafeReadKeys is just like IoReadKeys except it does not 
 * disable interrupts before reading the keyboard state.
 */
unsigned int IoUnsafeReadKeys(void);


/* IoInput is a low-level routine which reads one character 
 * from the specified IO port and returns it.
 */
char IoInput(char port);


/* IoOutput is a low-level routine which writes one character 
 * to the specified IO port.
 */
void IoOutput(char port, char Data);

#endif

