#ifndef IO_DEVICES_H
#define IO_DEVICES_H

/******************************************************************************\
*  io_devices.h
*
*  Header file that defines the device paths of the I/O API software
*
\******************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

// define export options
#ifdef __BORLANDC__
#define DLLEXPORT __export _stdcall
#define VAREXPORT __import
// Borland pragma for assuring byte alignment
#pragma option -a1
#else
#define DLLEXPORT __declspec(dllexport) _stdcall
#define VAREXPORT
// MFC pragma's for assuring byte alignment
#pragma pack( push, alignment_before_tops_includes ) //store current alignment
#pragma pack(1)
#endif

// If a new device is added an entry must be added to this table.
// The new id should be placed immediately prior to the InvalidHighDevice
// Entry.
enum IO_DeviceIdDef
{
   InvalidLowDevice,
   IO_ComPort,
   IO_IRDA,
   InvalidHighDevice
};
typedef enum IO_DeviceIdDef IO_DeviceIdType;

// restore previous alignment
#ifdef __BORLANDC__
#pragma option -a-.                                  // Borland restore
#else
#pragma pack( pop, alignment_before_tops_includes ) // MFC restore
#endif

#ifdef __cplusplus
}
#endif
#endif

//---------------------------------------------------------------------------
//  End of File: io_devices.h
//---------------------------------------------------------------------------
