/********************************************************
 * 
 * Title: Kralj
 *
 * Module: Game
 *
 * Type: Implementation
 *
 * Author: Jurica Jurjevic
 *
 * Timestamp: 2000/02/22 20:29:54
 *
 ********************************************************/

#include "game.h"
#include "kralj.h"
#include "chess.h"

/********************************************************
 * Reset the current game settings
 ********************************************************/
void reset_game( GameType gt ) 
{
	game.gametype = gt;
	/* game globals */
	game.game_started=FALSE;	
	/* Init game.chessboard */
	game.chessboard.selected_field.figure.type=NONE;
	game.chessboard.top=30;
	game.chessboard.left=10;
	game.chessboard.orientation=WHITE_BOTTOM;
	reset_board();
	/* Init the players */
	if( gt.game_type == GAMETYPE_UNLIMITED )
	{		
		game.chessboard.players.black.time = game.chessboard.players.white.time = 0;		
	}
	else
	{		
		game.chessboard.players.black.time = game.chessboard.players.white.time = gt.timer_minute*60 + gt.timer_second;		
	}
	game.chessboard.players.black.name="Black Player";		
	game.chessboard.players.white.name="White Player";
	game.chessboard.players.nextplayer=WHITE_PLAYER_NEXT;
}

/********************************************************
 * Reset kraly system options to default
 ********************************************************/
void reset_options() 
{
	game.options.animation_speed = 5;
	game.options.beep = TRUE;
	game.options.show_last_move = FALSE;
	game.options.ticks = TRUE;
}
