/********************************************************
 * 
 * Title: Kralj
 *
 * Module: Drawing
 *
 * Type: Header
 *
 * Author: Jurica Jurjevic
 *
 * Timestamp: 2000/02/14 00:54:21
 *
 *
 * Game drawing on the screen are all performed in this
 * library.
 *
 ********************************************************/

#ifndef _drawing_h
#define _drawing_h

/********************************************************
 * Definig the sprites of the chessfigures
 ********************************************************/
#define SPRITE_WHITE_PAWN SPRITE(0, 56)
#define SPRITE_BLACK_PAWN SPRITE(16, 56)
#define SPRITE_BACKGROUND_PAWN SPRITE(32, 56)

#define SPRITE_WHITE_ROOK SPRITE(0, 104)
#define SPRITE_BLACK_ROOK SPRITE(16, 104)
#define SPRITE_BACKGROUND_ROOK SPRITE(32, 104)

#define SPRITE_BLACK_KNIGHT SPRITE(16, 88)
#define SPRITE_WHITE_KNIGHT SPRITE(0, 88)
#define SPRITE_BACKGROUND_KNIGHT SPRITE(32, 88)

#define SPRITE_BLACK_BISHOP SPRITE(16, 72)
#define SPRITE_WHITE_BISHOP SPRITE(0, 72)
#define SPRITE_BACKGROUND_BISHOP SPRITE(32, 72)

#define SPRITE_BLACK_QUEEN SPRITE(16, 120)
#define SPRITE_WHITE_QUEEN SPRITE(0, 120)
#define SPRITE_BACKGROUND_QUEEN SPRITE(32, 120)

#define SPRITE_BLACK_KING SPRITE(16, 136)
#define SPRITE_WHITE_KING SPRITE(0, 136)
#define SPRITE_BACKGROUND_KING SPRITE(32, 136)

#define SPRITE_MODE_OR 0
#define SPRITE_MODE_CLEAR 1
#define SPRITE_MODE_XOR 2


/********************************************************
 * Show the startup screen
 ********************************************************/
void show_start_screen();

/********************************************************
 * Moving a figure with drag and drop?
 ********************************************************/
void move_drag_and_drop(unsigned char pix_x, unsigned char pix_y);

/********************************************************
 * Make the move visible - means draw and set it!
 * Global params game.chessboard.destination_field and
 * game.chessboard.selected_field used for positioning
 ********************************************************/
void make_move();

void draw_playground();
void draw_player_infos();
void draw_chessboard();
void draw_figure(unsigned char figure, unsigned char pixel_x, unsigned char pixel_y);
void draw_square(unsigned char mode, unsigned char posx, unsigned char posy);
void draw_field(unsigned char mode, unsigned char posx, unsigned char posy);
void draw_sprite( unsigned char x, unsigned char y, unsigned char w, unsigned char h, unsigned char sx, unsigned char sy, unsigned char m );


#endif
