/********************************************************
 * 
 * Title: Kralj
 *
 * Author: Jurica Jurjevic
 *
 * Timestamp: 2000/02/02 02:45:47
 *
 *
 * Alle chess calculations/algorithmics/rules
 * (not the engine) coded in here
 *
 ********************************************************/

#include "chess.h"
#include <avsys.h>

/********************************************************
 * Prove if the selected move goes ok
 * If the move is Ok, the internal settings are set
 * in this function
 * Return TRUE if ok, else FALSE to prevent the move
 ********************************************************/
unsigned char chess_make_move() 
{
	Field s; /* selected field */
	Field d; /* destination field */

	unsigned char legal_move = FALSE; /* FALSE if the move was illegal - otherwise TRUE */	
	
	s = game.chessboard.selected_field;
	d = game.chessboard.destination_field;


	/* Check if the figure can move the selected way */
	legal_move = check_figure_move(s.figure.type, s, d );


	/*
	 * If the move was illegal than set the figure back and
	 * abd return a false
	 */
	if( legal_move == FALSE )
	{
		game.chessboard.board[s.pos.x][s.pos.y]=s.figure.type;
		return FALSE;
	}
	
	/*
	 * Set the figure to the new position and capture the
	 * current figure.
	 */
	capture(d.pos.x,d.pos.y);
	game.chessboard.board[d.pos.x][d.pos.y] = s.figure.type;
	return TRUE;
}

/********************************************************
 * Check if the figure is able to make such a move
 * f = figure-type
 * TRUE if ok, FALSE if not
 ********************************************************/
unsigned char check_figure_move(unsigned char f, Field s, Field d ) 
{

	/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	 * DONT FORGET ENPASANT, CHECK, AND ROCHADE
	 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	 */

	/* Temporary variables */
	char temp_1, temp_2;

	/* It is never possible to put a figure over a hiw own figure */
	if( game.chessboard.board[d.pos.x][d.pos.y]/10 == f/10 ) return FALSE;

	temp_1 = s.pos.x - d.pos.x;			
	temp_2 = s.pos.y - d.pos.y;

	switch( f%10 )
	{
		case PAWNS:
			if( temp_1 > 1 || temp_1 < -1 ) return FALSE;			
			if( temp_1 == 0 && game.chessboard.board[d.pos.x][d.pos.y]!=NONE ) return FALSE;			
			if( temp_1 != 0  ) 
			{	
				/* Check up if move is enpasant capture */
				if( game.chessboard.board[d.pos.x][d.pos.y]==NONE ) return FALSE;			
			}
			/* Now check white and black pawns seperated */
			if( f == WHITE_PAWN )
			{				
				if( temp_2 > 2 || temp_2 < 1 ) return FALSE; /* */
				if( temp_2 == 2 && s.pos.y != ROW_2 ) return FALSE; /* Check for two field move from the baseline */
			}
			else
			{
				if( temp_2 < -2 || temp_2 > -1 ) return FALSE; /* */
				if( temp_2 == -2 && s.pos.y != ROW_7 ) return FALSE; /* Check for two field move from the baseline */
			}
			break;
		case BISHOPS:
			/* Bishop moves are easy - the abs(x) and abs(y) must be the same */
			if( dabs( temp_1 ) != dabs( temp_2 ) ) return FALSE;
			/* Check if any figures are between the selected and destination position */
			if( check_figures_between( f, s, d ) == FALSE ) return FALSE;
			break;
		case KNIGHTS:
			/* Knights are very easy - 2x and 1y or 1x and 2y*/
			if( !((dabs( temp_1 ) == 2 && dabs( temp_2 ) == 1) ||
				(dabs( temp_1 ) == 1 && dabs( temp_2 ) == 2)) ) return FALSE;
			break;
		case ROOKS:
			/* Rooks goes easy | or - */			
			if( temp_1!=0 && temp_2!=0 ) return FALSE;
			/* Check if any figures are between the selected and destination position */
			if( check_figures_between( f, s, d ) == FALSE ) return FALSE;
			break;
		case QUEENS:
			if( !( temp_1==0 || temp_2==0 || ( dabs( temp_1 ) == dabs( temp_2 ) ) ) ) return FALSE;
			if( check_figures_between( f, s, d ) == FALSE ) return FALSE;
			break;
		case KINGS:
			if( dabs( temp_1 ) > 1 || dabs( temp_2 ) > 1 ) return FALSE;
			break;
	}

	return TRUE;
}

/********************************************************
 * Check if there are any figures between the to fields
 * Allowed destinations are - \ | /
 ********************************************************/
unsigned char check_figures_between( unsigned char f, Field s, Field d )
{	
	unsigned char sx = s.pos.x;
	unsigned char sy = s.pos.y;
	unsigned char dx = d.pos.x;
	unsigned char dy = d.pos.y;

	while( !( sx == dx && sy == dy ) )
	{
		if( sx < dx ) sx++;
		if( sx > dx ) sx--;
		if( sy < dy ) sy++;
		if( sy > dy ) sy--;

		if( game.chessboard.board[sx][sy]/10 == f/10 ) return FALSE;
	}

	return TRUE;
}

/********************************************************
 * Now we capture the figure at the position (posx, posy)
 ********************************************************/
void capture(unsigned char posx, unsigned char posy ) 
{
	int i;

	if( game.chessboard.board[posx][posy] == NONE ) return; /* if there is no figure exit function */

	/** Reset the captured figures */
	for( i=0; i<MAX_FIGURES; i++ ) 
	{
		if( game.chessboard.captured[i] == NONE ) game.chessboard.captured[i] = game.chessboard.board[posx][posy];
	}

}

/********************************************************
 * Returns the field position with its occupy.
 ********************************************************/
Field get_chessboard_field(unsigned char x, unsigned char y) 
{
	
	Field f;
	
	int i;	
	int posx=game.chessboard.left;
	int posy=game.chessboard.top;
	int temp1, temp2;

	/* Init f */
	f.pos.x=-1;
	f.pos.y=-1;
	f.figure.type=NONE;
	f.figure.pos.x=0;
	f.figure.pos.y=0;
	f.offset.x=0;
	f.offset.y=0;
	

	/* Check coordinates */
	for(i=0; i<8; i++)
	{
		temp1=posy+i*18;
		temp2=posy+i*18+17;
		if(y>=temp1 && y<=temp2) 
		{
			f.pos.y=i;
			if( game.chessboard.orientation == WHITE_TOP ) f.pos.y=7-i; /* Only if white plays at top */
			f.offset.y=y-temp1;
			f.figure.pos.y=temp1+1;
		}
	}
	for(i=0; i<8; i++)
	{
		temp1=posx+i*18;
		temp2=posx+i*18+17;
		if(x>=temp1 && x<=temp2) 
		{
			f.pos.x=i;
			f.offset.x=x-temp1;
			f.figure.pos.x=temp1+1;
		}
	}
	if(f.pos.x>-1 && f.pos.x<8 && f.pos.y>-1 && f.pos.y<8) 
	{
		f.figure.type=game.chessboard.board[f.pos.x][f.pos.y];
	}

	return f;
}

/********************************************************
 * Reset the board - setup the startup positions
 ********************************************************/
void reset_board() {

	int i;

	/** Reset the captured figures */
	for( i=0; i<MAX_FIGURES; i++ ) game.chessboard.captured[i] = NONE;

	/** Row 8 */
	game.chessboard.board[COL_A][ROW_8]=BLACK_ROOK;
	game.chessboard.board[COL_B][ROW_8]=BLACK_KNIGHT;
	game.chessboard.board[COL_C][ROW_8]=BLACK_BISHOP;
	game.chessboard.board[COL_D][ROW_8]=BLACK_QUEEN;
	game.chessboard.board[COL_E][ROW_8]=BLACK_KING;
	game.chessboard.board[COL_F][ROW_8]=BLACK_BISHOP;
	game.chessboard.board[COL_G][ROW_8]=BLACK_KNIGHT;
	game.chessboard.board[COL_H][ROW_8]=BLACK_ROOK;

	/** Row 7 */
	game.chessboard.board[COL_A][ROW_7]=BLACK_PAWN;
	game.chessboard.board[COL_B][ROW_7]=BLACK_PAWN;
	game.chessboard.board[COL_C][ROW_7]=BLACK_PAWN;
	game.chessboard.board[COL_D][ROW_7]=BLACK_PAWN;
	game.chessboard.board[COL_E][ROW_7]=BLACK_PAWN;
	game.chessboard.board[COL_F][ROW_7]=BLACK_PAWN;
	game.chessboard.board[COL_G][ROW_7]=BLACK_PAWN;
	game.chessboard.board[COL_H][ROW_7]=BLACK_PAWN;
	
	/** Row 6 */
	game.chessboard.board[COL_A][ROW_6]=NONE;
	game.chessboard.board[COL_B][ROW_6]=NONE;
	game.chessboard.board[COL_C][ROW_6]=NONE;
	game.chessboard.board[COL_D][ROW_6]=NONE;
	game.chessboard.board[COL_E][ROW_6]=NONE;
	game.chessboard.board[COL_F][ROW_6]=NONE;
	game.chessboard.board[COL_G][ROW_6]=NONE;
	game.chessboard.board[COL_H][ROW_6]=NONE;

	/** Row 5 */
	game.chessboard.board[COL_A][ROW_5]=NONE;
	game.chessboard.board[COL_B][ROW_5]=NONE;
	game.chessboard.board[COL_C][ROW_5]=NONE;
	game.chessboard.board[COL_D][ROW_5]=NONE;
	game.chessboard.board[COL_E][ROW_5]=NONE;
	game.chessboard.board[COL_F][ROW_5]=NONE;
	game.chessboard.board[COL_G][ROW_5]=NONE;
	game.chessboard.board[COL_H][ROW_5]=NONE;

	/** Row  4 */
	game.chessboard.board[COL_A][ROW_4]=NONE;
	game.chessboard.board[COL_B][ROW_4]=NONE;
	game.chessboard.board[COL_C][ROW_4]=NONE;
	game.chessboard.board[COL_D][ROW_4]=NONE;
	game.chessboard.board[COL_E][ROW_4]=NONE;
	game.chessboard.board[COL_F][ROW_4]=NONE;
	game.chessboard.board[COL_G][ROW_4]=NONE;
	game.chessboard.board[COL_H][ROW_4]=NONE;

	/** Row 3 */
	game.chessboard.board[COL_A][ROW_3]=NONE;
	game.chessboard.board[COL_B][ROW_3]=NONE;
	game.chessboard.board[COL_C][ROW_3]=NONE;
	game.chessboard.board[COL_D][ROW_3]=NONE;
	game.chessboard.board[COL_E][ROW_3]=NONE;
	game.chessboard.board[COL_F][ROW_3]=NONE;
	game.chessboard.board[COL_G][ROW_3]=NONE;
	game.chessboard.board[COL_H][ROW_3]=NONE;

	/** Row 2 */
	game.chessboard.board[COL_A][ROW_2]=WHITE_PAWN;
	game.chessboard.board[COL_B][ROW_2]=WHITE_PAWN;
	game.chessboard.board[COL_C][ROW_2]=WHITE_PAWN;
	game.chessboard.board[COL_D][ROW_2]=WHITE_PAWN;
	game.chessboard.board[COL_E][ROW_2]=WHITE_PAWN;
	game.chessboard.board[COL_F][ROW_2]=WHITE_PAWN;
	game.chessboard.board[COL_G][ROW_2]=WHITE_PAWN;
	game.chessboard.board[COL_H][ROW_2]=WHITE_PAWN;

	/** Row 1 */
	game.chessboard.board[COL_A][ROW_1]=WHITE_ROOK;
	game.chessboard.board[COL_B][ROW_1]=WHITE_KNIGHT;
	game.chessboard.board[COL_C][ROW_1]=WHITE_BISHOP;
	game.chessboard.board[COL_D][ROW_1]=WHITE_QUEEN;
	game.chessboard.board[COL_E][ROW_1]=WHITE_KING;
	game.chessboard.board[COL_F][ROW_1]=WHITE_BISHOP;
	game.chessboard.board[COL_G][ROW_1]=WHITE_KNIGHT;
	game.chessboard.board[COL_H][ROW_1]=WHITE_ROOK;

}
