	.module	avadata.asm

	.area	_code
	.include "syscall.asm"
	.include "datacall.asm"

	.globl	_GetPrivateState
	.globl	_SetPrivateState
	.globl	_SaveListInfo
	.globl	_ReadListInfo
	.globl	_ReadListName
	.globl	_GetFreeTableID
	.globl	_GetTableCount
	.globl	_SaveTableName
	.globl	__ReadTableName
	.globl	_SaveFieldInfo
	.globl	_ReadFieldInfo
	.globl	_ChangeRecord
	.globl	__CreateRecord
	.globl	_DeleteRecord
	.globl	_GetRecordSize
	.globl	__InsertRecord
	.globl	_ModifyRecord
	.globl	_ReadRecord
	.globl	_IsAliveRecord
	.globl	_IsOverFilled
	.globl	_SaveIndexTable
	.globl	_LoadIndexTable
	.globl	_SavePreference
	.globl	_ReadPreference
	.globl	_DeletePreference
	.globl	_GetPreferenceLen
	.globl	_GetRecordCount
	.globl	_CheckFreeRecordSpace
	.globl	_GetProgramId
	.globl	_GetDataSize
	.globl	_AllocPIMRecordSpace
	.globl	_ReadCategoryInfo
	.globl	_SaveCategoryInfo
	
_GetPrivateState:
	call	bkpop0
	.dw		GetPrivateState
_SetPrivateState:
	call	bkpop2
	.dw		SetPrivateState
_SaveListInfo:
	call	bkpop2
	.dw		SaveListInfo
_ReadListInfo:
	call	bkpop2
	.dw		ReadListInfo
_ReadListName:
	call	bkpop1
	.dw		ReadListName
;_GetFreeTableID:
;	call	bkpop0
;	.dw		GetFreeTableID
;_GetTableCount:
;	call	bkpop0
;	.dw		GetTableCount
;_SaveTableName:
;	call	bkpop2
;	.dw		SaveTableName
__ReadTableName:
	call	bkpop2
	.dw		ReadTableName
_SaveFieldInfo:
	call	bkpop2
	.dw		SaveFieldInfo
_ReadFieldInfo:
	call	bkpop2
	.dw		ReadFieldInfo
_ChangeRecord:
	call	bkpop2
	.dw		ChangeRecord
__CreateRecord:
	call	bkpop2
	.dw		CreateRecord
_DeleteRecord:
	call	bkpop2
	.dw		DeleteRecord
_GetRecordSize:
	call	bkpop2
	.dw		GetRecordSize
__InsertRecord:
	call	bkpop2
	.dw		InsertRecord
_ModifyRecord:
	call	bkpop2
	.dw		ModifyRecord
_ReadRecord:
	call	bkpop2
	.dw		ReadRecord
_GetRecordCount:
	call	bkpop2
	.dw		GetRecordCount
_IsAliveRecord:
	call	bkpop2
	.dw		IsAliveRecord
_IsOverFilled:
	call	bkpop1
	.dw		IsOverFilled
_SaveIndexTable:
	call	bkpop1
	.dw		SaveIndexTable
_LoadIndexTable:
	call	bkpop1
	.dw		LoadIndexTable
_SavePreference:
	call	bkpop2
	.dw		SavePreference
_ReadPreference:
	call	bkpop2
	.dw		ReadPreference
_DeletePreference:
	call	bkpop1
	.dw		DeletePreference
_GetPreferenceLen:
	call	bkpop1
	.dw		GetPreferenceLen
_CheckFreeRecordSpace:
	call	bkpop1
	.dw		CheckFreeRecordSpace
_GetDataSize:
	call	bkpop1
	.dw		GetDataSize
_AllocPIMRecordSpace:
	call	bkpop2
	.dw		AllocPIMRecordSpace
_ReadCategoryInfo:
	call	bkpop2
	.dw		ReadCategoryInfo
_SaveCategoryInfo:
	call	bkpop2
	.dw		SaveCategoryInfo
_GetProgramId:
	call	GetRomBank
	ld		bc,#GetProgramId
	call	banked_function_call
	ld		h,#0
	ld		l,a
	ret

bkpop0:
	pop		hl
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	pop		hl
	ld		(retaddr),hl
	pop		hl
	ld		(retbank),hl
	pop		hl
	ld		(retfunc),hl
	call	banked_function_call
	ex		de,hl
	ld		hl,(retfunc)
	push	hl
	ld		hl,(retbank)
	push	hl
	ld		hl,(retaddr)
	push	hl
	ex		de,hl
	ret

bkpop1:
	pop		hl
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	pop		hl
	ld		(retaddr),hl
	pop		hl
	ld		(retbank),hl
	pop		hl
	ld		(retfunc),hl
	pop		hl
	call	banked_function_call
	push	bc
	ex		de,hl
	ld		hl,(retfunc)
	push	hl
	ld		hl,(retbank)
	push	hl
	ld		hl,(retaddr)
	push	hl
	ex		de,hl
	ret

bkpop2:
	pop		hl
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	pop		hl
	ld		(retaddr),hl
	pop		hl
	ld		(retbank),hl
	pop		hl
	ld		(retfunc),hl
	pop		hl
	pop		de
	call	banked_function_call
	push	bc
	push	bc
	ex		de,hl
	ld		hl,(retfunc)
	push	hl
	ld		hl,(retbank)
	push	hl
	ld		hl,(retaddr)
	push	hl
	ex		de,hl
	ret
