/* avicons.h
 *
 * Header file for Avigo system icon drawing function
 *
 *
 * Version 1.0
 * Copyright Bill Baxter
 * Oct 16, 1997
 *
 * Feel free to redistribute/reuse this code at no charge.
 * But be aware that it comes with no guarantees or warantees of any
 * kind.  Use at your own risk.  Do not use this code in the control 
 * system for a nuclear reactor.
 *
 * NOTES:
 * -  Drawing system icons onto the virtual screen 
 *    doesn't seem to work.  Maybe the system call is 
 *    already using the virtual screen.
 *
 * -  For a complete listing of the system icons, visit Hans Pufal's
 *    web site: http://www.digiweb.com/~hansp/avigo/sysicon.htm
 *
 * -  And don't forget to check back at http://billbaxter.com/avigo
 *    from time to time to see what's new in the world of the 
 *    Freeware Avigo SDK.
 */


/* This is a workaround for a Freeware SDK Bug with functions
 * that have char arguments
 */
typedef int CHAR;

/* MAX_ICON is the maximum icon index */
#define MAX_ICON 323


/* DrawSystemIcon takes the x and y coordinates at which to
 * draw the system icon, the icon index number, and a drawing mode
 * which can be PUT, OR, or XOR (maybe others too?).
 */
void DrawSystemIcon(CHAR x, CHAR y, int icon_number, int mode);

