/* avicons.c
 *
 * Implementation file for Avigo system icon drawing function
 *
 *
 * Version 1.0
 * Copyright Bill Baxter
 * Oct 16, 1997
 *
 * Feel free to redistribute/reuse this code at no charge.
 * But be aware that it comes with no guarantees or warantees of any
 * kind.  Use at your own risk.  Do not use this code in the control 
 * system for a nuclear reactor.
 *
 * NOTES:
 * -  Drawing system icons onto the virtual screen 
 *    doesn't seem to work.  Maybe the system call is 
 *    already using the virtual screen.
 *
 * -  For a complete listing of the system icons, visit Hans Pufal's
 *    web site: http://www.digiweb.com/~hansp/avigo/sysicon.htm
 *
 * -  And don't forget to check back at http://billbaxter.com/avigo
 *    from time to time to see what's new in the world of the 
 *    Freeware Avigo SDK.
 */

#include "avicons.h"

void DrawSystemIcon(CHAR x, CHAR y, int icon_number, int mode)
{
    _asm
    {
        ld   l, _mode+0(ix)
        ld   h, _mode+1(ix)
        push hl
        ld   l, _icon_number+0(ix)
        ld   h, _icon_number+1(ix)
        push hl
        ld   e, _y(ix)
        ld   l, _x(ix)
        call 0x0168
        pop bc
        pop bc
    }
}
