/** AVIGOCS - takes an avigo .pgm file and fixes checksums **/

/**  .pgm file must include the language info (it will be greater than 1Mb) **/


#include <stdio.h>
#include <stdlib.h>

unsigned char pgm[0x200000];

void csum (unsigned int begin, unsigned int end, unsigned int cs_place)
{
	unsigned int sum, c1, c2, i;

	pgm[cs_place + 0] = 0;
	pgm[cs_place + 1] = 0;
	pgm[cs_place + 2] = 0;
	pgm[cs_place + 3] = 0;

	sum = 0;
	for (i = begin; i < end; i++) {
		sum += pgm[i];
	}
	sum = sum & 0xFFFF;

	c1 = (sum & 0xFF00) >> 8;
	c2 = sum & 0xFF;

	if (sum == 0xFF00) {
		pgm[cs_place + 0] = 0x00;
		pgm[cs_place + 1] = 0x00;
		pgm[cs_place + 2] = 0x80;
		pgm[cs_place + 3] = 0x80;
	}else if (c2 == 0) {
		pgm[cs_place + 0] = 0;
		pgm[cs_place + 1] = c1+1;
		pgm[cs_place + 2] = 0x100-(c1+1);
		pgm[cs_place + 3] = 0;
	}else if (sum == 0xFE01) {
		pgm[cs_place + 0] = 0x01;
		pgm[cs_place + 1] = 0xFF;
		pgm[cs_place + 2] = 0x00;
		pgm[cs_place + 3] = 0x00;
	}else if (c1 == 0xFE) {
		pgm[cs_place + 0] = c2;
		pgm[cs_place + 1] = 0;
		pgm[cs_place + 2] = 0xff;
		pgm[cs_place + 3] = 0x101-c2;
	}else{
		pgm[cs_place + 0] = c2;
		pgm[cs_place + 1] = c1+2;
		pgm[cs_place + 2] = 0x100-c2;
		pgm[cs_place + 3] = 0x100-(c1+2);
	}

}


main(int argc, char **argv)
{

	FILE *infile, *outfile;
	int c;
	unsigned int len_pgm, i;

	puts ("Avigo Checksum:");

	if (argc != 2) {
		puts ("  Usage: Just needs name of .pgm file to modify.\n\n");
		exit (1);
	}
 

	/**** read in the file ****/
    if ( (infile = fopen (argv[1], "rb")) == NULL ) {
		puts ("  ERROR: Problem opening file for input.");
		exit (2);
	}

	len_pgm = 0;
	while ( ((c = getc(infile)) != EOF) && (len_pgm < 0x200000) ) {
		pgm[len_pgm++] = c;
	}

	if (c != EOF) {
		puts ("  ERROR: File too long: I can't handle anything longer than 2 Mb pgm files :(.");
		exit (3);
	}

    if (len_pgm % 0x10000 != 0) {
		puts ("  ERROR: File must be a multiple of 64Kb.");
		exit (4);
	}

	if (len_pgm <= 0x100000) {
		puts ("  ERROR: File must be greater than 1 Mb (i.e., the language info must be attached).");
		exit (5);
	}

	fclose (infile);


	/**** process the checksums ****/
	csum (0, 0x10000, 0x3FF0);
	csum (0x10000, 0x100000, 0xFFFF0);
	csum (0x100000, len_pgm, len_pgm - 0x10);


	/**** write the file ****/
    if ((outfile = fopen (argv[1], "wb")) == NULL ) {
		puts ("  ERROR: Problem opening file for output.");
		exit (6);
	}

    for (i = 0; i < len_pgm; i++)
		putc (pgm[i], outfile);

    fclose (outfile);
		
	puts ("  Finished.");

	return (0);
}