#include "ressdk.h"
#include "packet.h"
#include "f_sdkapi.h"
#include "memo.h"
#include "windows.h"
#include "chooses.h"
#include "choose.h"


static BANKED void ReadMenu(void)
{
 int cnt,i;
 char *p;

 /* get num memos */
 /*dapLoadIndexTable(TYPE_MEMO);*/

 CurPos = 0;
 MemoCnt = GetMemoCount();
 
 if (MemoCnt>0)
 {
  for (i=0,cnt=0; i<=MemoCnt; i++)
  {
   if (p = GetMemoTitle(i))
   {
    if (strlen(p)>0)
    {
	 /* check for shortcut */
     if (ShortCut)
       if (toupper(p[0]) != ShortCut) continue;
     /* if only certain ext  wanted */
     if (strlen(Extention)>0)
      if (!strstr(p, Extention))  continue;	 
     /* ok display that one */
     Indexes[cnt++]=i;
    }
   }
  }
  MemoCnt = cnt;
 }
}

static BANKED void DrawMenu(void)
{
 int i, y, sz;
 char *p;

 ClearLCDArea(WORK_LEFT, WORK_TOP, WORK_RIGHT, WORK_BOTTOM, 0);
 SetFontType(PRPFONT11N);

 /* draw alphabet tabs */
 DrawSystemIcon(0, WORK_BOTTOM+1, 1, PUT);

 for (i=CurPos,y=WORK_TOP; i<CurPos+MAX_LINES; i++, y+=12)
 {
  if (i>=MemoCnt) break;

  ClearLCDArea(WORK_LEFT+3, y, WORK_RIGHT, y+10, 0);

  if ((p = GetMemoTitle(Indexes[i])))
  {
   TmpStr[0] = 0x0B;
   TmpStr[1] = 0x20;
   strcpy(&TmpStr[2], p);
   
   if (GetStringLength(TmpStr, GetFontType())>=WORK_RIGHT-6)
   {    
    sz = strlen(TmpStr);
    while(GetStringLength(TmpStr, GetFontType())>=WORK_RIGHT-6) 
    {
     sz--;
     TmpStr[sz]=0;
    }
    TmpStr[sz]='.';
	TmpStr[sz+1]='.';
	TmpStr[sz+2]=0;
   }
   WriteString(WORK_LEFT+3, y, TmpStr, 0);
  }
 }
}


BANKED int GetClickedMemo(byte handle, int xpos,int ypos)
{
 int i,y;
 byte x1, x2;

 /* check for shortcuts */
 if (ypos>WORK_BOTTOM)
 {
  i=0;

  while(ShortCuts[i].x1 > 0)
  {
   x1 = ShortCuts[i].x1;
   x2 = ShortCuts[i].x2;
   if ((xpos >= x1) && (xpos <= x2))
   {
    ShortCut = toupper(ShortCuts[i].c);
    /* update title */
    strcpy(ChooseTitle, DefChooseTitle);
    y = strlen(ChooseTitle);
    ChooseTitle[y-2] = ShortCut;
    /* reverse video letter */
	PressAtButton(xpos, ypos, x1-1, 230, x2+1, 236);
	PostMessage(handle, evPaint, 0, 0);
	return -1;
   }
   i++;
  }
 }

 if ((ypos>=WORK_BOTTOM-3) || (xpos>WORK_RIGHT)) return -1;
 if (ypos<WORK_TOP-2) return -1;

 for (i=0,y=WORK_TOP;i<MaxItems; i++,y+=12)
 {
  if ((ypos >= y) && (ypos <= y+11) && ((CurPos+i)<MemoCnt))
  {
    if (PressAtButton(xpos, ypos, WORK_LEFT, y, WORK_RIGHT, y+11))
      return Indexes[CurPos+i];
    else
      break;
  }
 }
 return -1;
}

static BANKED int ChooseWndProc(byte handle, unsigned short evType, byte x, byte y)
{
 PDESKBOX *dsk;
 PVIEW *pg;

 switch(evType)
 {
  case evCommand:
  		switch(GetCmd(x,y))
		{
		 case mcReset:
			ShortCut = 0;
			strcpy(ChooseTitle, DefChooseTitle);
			PostMessage(handle, evPaint, 0, 0);
			break;

		 case mcClose:
  			PostQuitMessage(handle, x);
  			break;

  		 case cmPgDn:
  			CurPos+=MAX_LINES;
  			if (CurPos>=MemoCnt) CurPos = 0;
  			DrawMenu();
  			break;

  		 case cmPgUp:
  			CurPos -= MAX_LINES;
  			if (CurPos<0) CurPos = 0;
  			DrawMenu();
  			break;		

  		}break;

  case evPaint:	
  		ReadMenu();
  		DrawMenu();
  		break;

  case evKeyDown:
  		PostQuitMessage(handle, x);
  		break;

  case evPenDown:
		if ((ChosenIndex = GetClickedMemo(handle, x, y))>=0)
			/*PostMessage(handle, evQuit, APPLICATION, 0);*/
			DestroyWindow(handle);
		break;

  case evCreate:
		dsk = (PDESKBOX *) GetWindowPtr(handle);
		pg = (PVIEW *) InsertPageArrow((PDESKBOX *) dsk, 'Z', (PVIEW *) dsk);
		pg->top -= 13;
		pg->bottom -= 13;		
		break;
 }
}

BANKED int ChooseFile(byte handle, CONST_FAR_PTR ext)
{
 Window Win;
 SetFontType(PRPFONT11N);
 
 ChosenIndex = -1;
 fstrcpy(Extention, ext);

 strcpy(ChooseTitle, DefChooseTitle);

 Win.wTitle = MK_FAR_PTR(ChooseTitle);
 Win.wMenu =  MK_FAR_PTR(ChooseMenu);
 Win.wleft = 0;
 Win.wtop = 0;
 Win.wright = ScreenWidth()-1;
 Win.wbottom = ScreenHeight()-1;
 Win.wDir = PORTRAIT;
 Win.Modal = TRUE;
 Win.wflags = bafCheck|bafClose|bafDotTitle;
 BankedAssign(Win.WndProc,ChooseWndProc);

 CreateModalWindow(MK_FAR_PTR(Win), handle, FALSE);

 return(ChosenIndex);
}

