#include "p100plib.h"
#include "ressdk.h"
#include "f_sdkapi.h"
#include "packet.h"
#include "memo.h"

#define PRIVATE_FIELD 0
#define CATEGORY_FIELD 1
#define TITLE_FIELD 2
#define TEXT_FIELD 3
#define FIELD_COUNT_OFFSET 8
#define LENGTH_OFFSET 2
#define MEMO_FIELD_COUNT 4
#define PIMHEAD_SIZE (sizeof(PIMHEAD))
#define RECHEAD_SIZE (sizeof(RECHEAD))

char *GetField(char *Buffer, short FieldId);
unsigned char  GetFieldCount (char *Buffer);
unsigned short GetRecordLength (char *Buffer);

extern unsigned char StartRomBank;

static char				TmpTok[128] = "";
static unsigned char	Private[1] = "";
static unsigned short	PrivateLength = 0;
static char 			SavedCategory = 0;

static BYTE				MemoBuffer[4000] = "";

static RECHEAD 			memo_rec;
static PIMHEAD 			memo_head;

static int 	TextPos;
static int 	TextSize;

int GetMemoCount()
{
 int i,j;

 dapGetRecordCount(TYPE_MEMO, &i, &j);
 return (i);
}


CONST_FAR_PTR GetMemoText(int index)
{
 int size;
 PIMHEAD *p;
 
 dapLoadIndexTable(TYPE_MEMO);
 size = dapGetRecordSize(index);

 if (dapReadRecord(index, 0, MemoBuffer, size) == SUCCESS)
 {
  p = (PIMHEAD *) MemoBuffer;
  SavedCategory = p->category;
  return(MK_FAR_PTR(GetField(MemoBuffer, TITLE_FIELD + 1)));
 }
 
 return (0);
}


short CreateMemo(CONST_FAR_PTR title, CONST_FAR_PTR text,int textlen)
{
 char Category[1];
 short ret;

 fstrcpy(TmpTok,title);

 dapLoadIndexTable(TYPE_MEMO);

 Category[0] = '\0';

 if (textlen > MAX_MEMO_SIZE) textlen = MAX_MEMO_SIZE;

 memo_rec.offset = PIMHEAD_SIZE + RECHEAD_SIZE*MEMO_FIELD_COUNT;
 memcpy(MemoBuffer + PIMHEAD_SIZE + RECHEAD_SIZE*PRIVATE_FIELD, &memo_rec, RECHEAD_SIZE);
 memcpy(MemoBuffer + memo_rec.offset, &Private, PrivateLength); 
 memo_rec.offset = memo_rec.offset + PrivateLength;
 
 memcpy(MemoBuffer + PIMHEAD_SIZE + RECHEAD_SIZE*CATEGORY_FIELD, &memo_rec, RECHEAD_SIZE);
 memcpy(MemoBuffer + memo_rec.offset, Category, 0); 
 memo_rec.offset = memo_rec.offset + 0;

 memcpy(MemoBuffer + PIMHEAD_SIZE + RECHEAD_SIZE*TITLE_FIELD, &memo_rec, RECHEAD_SIZE);
 memcpy(MemoBuffer + memo_rec.offset, TmpTok, strlen(TmpTok) + 1); 
 memo_rec.offset = memo_rec.offset + strlen(TmpTok) + 1;

 memcpy(MemoBuffer + PIMHEAD_SIZE + RECHEAD_SIZE*TEXT_FIELD, &memo_rec, RECHEAD_SIZE);
 fmemcpy(MemoBuffer + memo_rec.offset, text, textlen + 1); 
 memo_rec.offset = memo_rec.offset + textlen + 1;
 memset(&memo_head, 0, PIMHEAD_SIZE);
 memo_head.typeID = TYPE_MEMO;
 memo_head.fieldCount = MEMO_FIELD_COUNT;
 memo_head.recLength = memo_rec.offset;
 memo_head.synKeyOffset = memo_head.recLength;

 memo_head.category = SavedCategory ;

 memcpy(MemoBuffer, &memo_head, PIMHEAD_SIZE);
 memcpy (&memo_head, MemoBuffer, PIMHEAD_SIZE);
 dapCheckFreeRecordSpace (memo_head.recLength);
 ret = dapCreateRecord (MemoBuffer, memo_head.recLength);

 dapSaveIndexTable();

 return ret;
}


char *GetField(char *Buffer, short FieldId)
{
 unsigned short FieldLength;
 RECHEAD RecHead;
 RECHEAD NextRecHead;

 memcpy (&RecHead, Buffer + sizeof (PIMHEAD) + (sizeof (RECHEAD))*FieldId, sizeof (RECHEAD));

/*********************************************************************************
* If this is not the last field, we can use the offset of the next field to
* determine the length. If its that last field we need to use the total record
* length to determine the field length.
*********************************************************************************/

 if (FieldId < GetFieldCount(Buffer) - 1)
 {
  memcpy (&NextRecHead, Buffer + sizeof (PIMHEAD) + (sizeof (RECHEAD))*(FieldId + 1), sizeof (RECHEAD));
 }
 else
 {
  NextRecHead.offset = GetRecordLength (Buffer);
 }
 FieldLength = NextRecHead.offset - RecHead.offset;
 /*memcpy (ReturnPtr, Buffer + RecHead.offset, FieldLength);*/

 return (Buffer + RecHead.offset);
}

unsigned char GetFieldCount (char *Buffer)
{

unsigned char FieldCount;

memcpy (&FieldCount, Buffer + FIELD_COUNT_OFFSET, sizeof (char));
return FieldCount;

}

unsigned short GetRecordLength (char *Buffer)
{

unsigned short Length;

memcpy (&Length, Buffer + LENGTH_OFFSET, sizeof (short));
return Length;

}


