#include "ressdk.h"
#include "packet.h"
#include "f_sdkapi.h"
#include "..\mlib.h"
#include "main.h"
#include "..\window.h"
#include "tictac.h"


void ShowAboutBox()
{
 MessageBox(MK_FAR_PTR(AboutMsg),mfInformation | mfOKButton);
}

void YouWon()
{
 WarningBeep();
 MessageBox(MK_FAR_PTR(YouWonMsg),mfInformation | mfOKButton);
}

void far Iwon()
{
 WarningBeep();
 MessageBox(MK_FAR_PTR(IwonMsg),mfInformation | mfOKButton);
}

void InvalidMove()
{
 MessageBox(MK_FAR_PTR(InvalidMsg),mfInformation | mfOKButton);
}

void InitBoard(void)
{
 int x, y, z;

 for(x=0;x<=4;x++)
   for(y=0;y<4;y++)
     for(z=0;z<4;z++) board[x][y][z]=0;
}

void InitGame(void)
{  
 KeepPlaying = 1;
 ClearLCDArea(2, 20, 158, 238, 0);
 ShowAboutBox();
 randomize();
 InitBoard();
}

int LocateClick(int penx, int peny,int *x, int *y, int *z)
{
 for (*z=0;*z<4; (*z)++)
   for (*y=0; *y<4; (*y)++)
     for(*x=0; *x<4; (*x)++)
       if((penx >= (BallXcoords[*y][*x]-2) && penx <= BallXcoords[*y][*x]+(Xinc-6)) &&
          (peny >= (BallYcoords[*z][*y]+2) && peny <= BallYcoords[*z][*y]+(Yinc-2)))
           return(TRUE);

 return(FALSE);
}

void PlotBall(int x,int y,int z,int attr)
{
 short i,j;

 if (attr == DRAW_BLACK)
 {
  for (i=0; i<4; i++)
  {
   FillCircle( BallXcoords[y][x], BallYcoords[z][y], 5, attr+DRAW_XOR);
   for(j=0; j<6000; j++);
   FillCircle( BallXcoords[y][x], BallYcoords[z][y], 5, attr+DRAW_XOR);
   for(j=0; j<6000; j++);
  }
 }
 FillCircle( BallXcoords[y][x], BallYcoords[z][y], 5, attr);
}

void DrawScreen(void)
{
 short i,j, x, y ,z;

 for (i=0; i<4; i++)
 {
  /* draw 1D board */
  for (j=0; j<4; j++)
  {
   DrawLine( BoardX[j],   BoardY[i][j], 
             BoardX[j+1], BoardY[i][j+1], DRAW_BLACK);
  }
  /* draw horizontal board lines */
  for (j=1; j<4; j++)
  {
   DrawLine( BoardX[0]-((Xinc-7)*j), BoardY[i][0]+(Yinc*j), 
             BoardX[1]-((Xinc-7)*j), BoardY[i][1]+(Yinc*j), DRAW_BLACK);

  }
  /* draw vertical board lines */
  for (j=1; j<4; j++)
  {
   DrawLine( BoardX[0]+(Xinc*j), BoardY[i][0], 
             BoardX[3]+(Xinc*j), BoardY[i][2], DRAW_BLACK);

  }
 }
}

/*
/
/ MAIN WINDOW HANDLERS 
/
/
*/

void OnCreate(VOID_PTR thisView)
{
 /* insert page arrow */
 /*InsertPageArrow((PDESKBOX *) thisView, 'A', (PVIEW *) thisView);*/
 InitGame();
}


void OnCommand(VOID_PTR thisView, WORD Cmd)
{
 char str[10];

 switch(Cmd)
 {
  case mcNew:
      InitGame();
      DrawScreen();
      break;

  case mcExit:  
      EndState = mcExit;
      break;

  case mcAbout:
      ShowAboutBox();
      break;

  case cmPgDn:
      break;

  case cmPgUp:
      break;
 }
}

void OnPaint(VOID_PTR thisView)
{
 int x,y,z;

 DrawScreen();
 /* redraw board */
 for (z=0; z<4; z++)
   for (y=0; y<4; y++)
     for (x=0; x<4; x++)
       if (board[z][y][x])
         /* redraw balls using board content as attribute */
         PlotBall(x,y,z,(board[z][y][x]-1));
}

void OnPenDown(VOID_PTR thisView, unsigned char x, unsigned char y)
{
 int xx, yy ,zz;

 if (KeepPlaying)
 {
  if (LocateClick(x, y, &xx, &yy, &zz))
  {
   if (board[zz][yy][xx])
     InvalidMove();
   else
   {
    PlotBall(xx, yy, zz, DRAW_GRAY);
    board[zz][yy][xx] = 1;
    /* test player move */
    CompMove(0);
    /* did ye win */
    if (!KeepPlaying) YouWon();
    /* make computer play */
    else 
    {
     CompMove(1);
     /* did ye win */
     /*if (!KeepPlaying) Iwon();*/
    }
   }
  }
 }
}

void OnPenUp(VOID_PTR thisView, unsigned char x, unsigned char y)
{}

void OnPenMove(VOID_PTR thisView, unsigned char x, unsigned char y)
{}

void OnPenAuto(VOID_PTR thisView, unsigned char x, unsigned char y) 
{}

void OnKeyDown(VOID_PTR thisView, unsigned char KeyCode) 
{
 switch(KeyCode)
 {
  /* pgdn */
  case 7: 
    break;

    /* pgup */
  case 6: 
    break;
 }
}

void OnTimer(VOID_PTR thisView)
{}

void OnUnknown(VOID_PTR thisView, short *evType, unsigned char x, unsigned char y)
{}

short main(void)
{
 unsigned short retval;

 ClearLCD(0);
 SetFontType(PRPFONT11N);

 do
 {
  retval = StartApplication(MK_FAR_PTR(AppTitle),MK_FAR_PTR(AppMenu));
 } while (retval == cmOK);
 
 if (retval == cmCancel)
 {
  retval = APPLICATION;
 }
 return retval;
}



