#include "ressdk.h"
#include "packet.h"
#include "f_sdkapi.h"
#include "math.h"
#include "..\windows.h"
#include "..\keyb.h"
#include "..\about.h";
#include "main.h"

extern unsigned char StartRomBank;

static BANKED void CallBackProc(byte handle, rect *r)
{
 byte i;

 SetFontType(PRPFONT11B);
 i = DrawString(handle, 5, 12, MK_FAR_PTR("Terminal V"), 0);
 DrawString(handle, i, 12, MK_FAR_PTR(STR_VERS), 0);
 SetFontType(PRPFONT11N);
 DrawString(handle, 5, 25, MK_FAR_PTR("\xA9 Ollivier Civiol 1998."), 0);
 SetFontType(PRPFONT7N);
 DrawString(handle, 5, (r->bottom-r->top)-22, MK_FAR_PTR("ociviol@astecsoft.com"), 0);
 DrawString(handle, 5, (r->bottom-r->top)-12, MK_FAR_PTR("www.astecsoft.com/avigo"), 0);
 SetFontType(PRPFONT11N);
}

static BANKED void BlinkCursor(void)
{
 FillRect(CurPosX, CurPosY, CurPosX+1, CurPosY+CHARH, DRAW_XOR);
 CursorOn ^= 1;
}

static BANKED void ScrollTermUp(void)
{
 if (CursorOn) BlinkCursor();
 BackupWindow(0, DebY+CHARH, 159, MaxY, GetLCDBackBufAddr());
 RestoreWindow(0, DebY, GetLCDBackBufAddr(), PUT);
 ClearLCDArea(DebX, (MaxY-CHARH)+1, MaxX, MaxY, 0);
}

static BANKED void PrintChar(char c)
{
 char str[3];

 if (c != BACK_SPACE)
 {
  str[0] = c;
  str[1] = 0;

  SetFontType(PRPFONT11N);
  if (CursorOn) BlinkCursor();

  /* check if won't fit in X */
  if(c == '\r') CurPosX = DebX;
  else
  if (((CurPosX + GetStringLength(str, PRPFONT11N)) >= MaxX) || (c == '\n'))
  {
   /* check if bottom reached */
   if (CurPosY+CHARH>=MaxY) ScrollTermUp();
   else CurPosY += CHARH;
  }
  else
  {
   WriteString(CurPosX, CurPosY, str, 0);
   CurPosX += GetStringLength(str, PRPFONT11N)+1;
  }
  /* checkY */ 
  /*if (CurPosY>=MaxY) ScrollTermUp();*/
 }
}

static BANKED void DrawWorkSpace(byte handle)
{
 rect r;

 GetWindowsRect(handle, &r);

 DebX = r.left+5;
 DebY = r.top+16;
 MaxX = r.right-5,
 MaxY = DebY + (MAXLINES*CHARH);
 
 DrawRect(DebX-1, DebY-1, MaxX+1, MaxY+1, DRAW_BLACK);

 CurPosX = DebX;
 CurPosY = DebY;
}

/*
/
/ MAIN WINDOW HANDLERS 
/
/
*/

static BANKED void OnCommand(byte handle, WORD Cmd)
{
 TAbout SAbout;

 switch(Cmd)
 {
 /*
  case mcRegister:
  		Prefs.Registered = CheckReg(PROG_NUM);
		if (!Prefs.Registered) ShowNagBox();
		break;
 */

  case mcConnectIR:
		if (!Connected)
		{		 
  		 Connected = TRUE;
		 OpenComm(handle, PORT_IR, SPEED_115000);
		}
		else MessageBox(MK_FAR_PTR(ConnErr2), mfWarning | mfOKButton);
  		break;

  case mcConnectRS:
  		if (!Connected)
		{		 
  		 Connected = TRUE;		 
		 OpenComm(handle, PORT_RS, SPEED_115000);
		}
		else MessageBox(MK_FAR_PTR(ConnErr2), mfWarning | mfOKButton);
  		break;

  case mcStop:
		if (CursorOn) BlinkCursor();
  		if (Connected)
		{
		 CloseComm();
		 Connected = FALSE;
		}
		else MessageBox(MK_FAR_PTR(ConnErr), mfWarning | mfOKButton);
		break;

  case mcExit:  
      /*dapSavePreference(CurrentAppID, (BYTE *) Prefs, sizeof(TPref));*/
      PostQuitMessage(handle, APPLICATION);
      break;

  case mcAbout:
      SAbout.width = 150;
      SAbout.height = 80;
	  BankedAssign(SAbout.CallBack, CallBackProc);
      AboutBox(handle, MK_FAR_PTR(SAbout));	  
      break;

 }
}

static BANKED int TermWndProc(byte handle, unsigned short evType, byte x, byte y)
{
 int v, i;
 byte c;
 
 switch(evType)
 {
  case evComChar:
		PrintChar(x);
		break;

  case evChar:
  		if (Connected) 
		{
 		 if (x == '\n')  SendByte('\r');		  
		 SendByte(x);		 
		}
  		break;

  case evDestroy:
		if (Connected) CloseComm();
		DestroyWindow(KeybWin);
		break;

  case evKeyDown:
		PostQuitMessage(handle, x);
		break;

  case evCommand:
		OnCommand(handle, ((WORD) x << 8) | (WORD) y);
		break;

  case evFastTimer:
  		BlinkCnt++;
		if (BlinkCnt < 4) break;
		BlinkCnt = 0; 
 
  case evTimer:
  		if (Connected) BlinkCursor();
		break;

  case evCreate:
		/* make keyb window */
		KeybWin = StartKeyBoard(handle, 0);
		PostMessage(handle, evCommand, HighByte(mcAbout), LowByte(mcAbout));
		break;

  case evPaint:
        DrawWorkSpace(handle);
 		break;

  case evPenDown:
  		break;
 }
}

BANKED void WinMain(void)
{
 Window Win;

 ClearLCD(0);
 SetFontType(PRPFONT11N);

 Win.wTitle = MK_FAR_PTR(AppTitle);
 Win.wMenu =  MK_FAR_PTR(AppMenu);
 Win.wleft = 0;
 Win.wtop = 0;
 Win.wright = 159;
 Win.wbottom = 155;
 Win.Modal = FALSE;
 Win.wDir = 0;
 Win.wflags = bafDotTitle;

 BankedAssign(Win.WndProc,TermWndProc);
 CreateWindow(MK_FAR_PTR(Win));
}


