#include "comm.h"
/******************************************************************
TI has just released this information. I thought that you might find it
useful.

Unfortunately, interrupt-driven communications are not available.
Here is a way to use device-polling methods.

1. InitComm
     Initializes the communication device.

     Parameters:
     L = mode   0 = IR, 1 = RS232
        DE = divider     The baud rate divider value.
                         1 = 115200, 2 = 57600, ? 12 = 9600.

     Returns :   None.

2 SendOneByte
        Waits until UART transmit buffer is empty, then gives
              the byte to the UART.

     Parameters:
     L = byte to send.

     Returns:  None.

3 ReceiveOneByte
     Returns a byte if UART has received one.

     Parameters: None

     Returns :
     A = received byte (if there is one).
        Z-flag is set if character has been received.
        Z-flag is clear if no character yet at UART.

4. CloseComm
        Shuts down communications. If you have just used
        "SendOneByte", you should wait a fraction of a second
        before calling this so that that byte can make it fully
        out of the UART.

     Parameters:  None.

     Returns :   None.


*****************************************************************/


/*
Initializes the communication device.

     Parameters:
     mode			0 = IR 
					1 = RS232
     baud rate		1  = 115200
					2  = 57600
					12 = 9600.

*/


static short AutoWakeUp;


void CloseComm(void)
{
.asm
	ld		hl,(_AutoWakeUp)
	ld		a,l
	ld      (c04bh),a
.endasm
}

void InitComm(short Mode, short Rate)
{
 register short b;
 register short a;
 

 a = Mode;
 b = Rate;

.asm
;Here is where the communications happens.
;get rate
	ld		l,(ix+2+?TSC1)
  	ld		h,(ix+2+?TSC1+1)
  	ld		d,h
  	ld		e,l
; get Mode
	ld		l,(ix+0+?TSC1)
  	ld		h,(ix+0+?TSC1+1)
	call    018CH      ;initialize communications
	ld      b,10
.endasm

/* set autowakeup off */
.asm
	ld      a,(c04bh)
	ld		h,0
	ld 		l,a
	ld		(_AutoWakeUp),hl
	or      a,1
	ld      (c04bh),a
.endasm 

/*
.asm
;Disables communications auto-wakeup
	di
	ld      a,(c04bh)
	push    af           ;store original value
	or      a,1
	ld      (c04bh),a
	ei

;Here is where the communications happens.
	ld      l,1        ;choose RS-232
	ld      DE,12      ;choose 9600 baud
	call    018CH      ;initialize communications
	ld      b,10
.endasm
*/
}
     

/*
ReceiveByte2 is a routine that is a replacement for the system's
ReceiveOneByteroutine. Below it is a routine called Example.
Include these routines in a .asm file, and when you call Example,
the Avigo will echo the next 9 characters it receives over the
serial port. Set your Win95 HyperTerminal program to 9600-8-N-1
and you can try it out.
*/

void SendByte(short Byte)
{
.asm
	ld	l,(ix+0+?TSC2)
	ld	h,(ix+0+?TSC2+1)
;	ld      l,a
	call    0192H        ;send byte back
.endasm
}

int ReceiveByte(void)
{
.asm
	PUSH    BC
	LD      B,FFH
RB2loop:
	IN      A,(35H)
	LD      C,A
	AND     1EH
	JR      NZ,RB2skip1
	BIT     0,C
	JR      NZ,RB2skip2
	DJNZ    RB2loop
	LD      A,00H
	LD      B,01H
	BIT     0,B
	JR      RB2exit
RB2skip1:
	IN      A,(30H)
	LD      A,00H
	LD      B,01H
	BIT     0,B
	JR      RB2exit
RB2skip2:
	IN      A,(30H)
	LD      B,00H
	BIT     0,B
RB2exit:
	POP     BC

	ld	hl,0
;	ld	h,1
;	jr  nz, RB2exit2
;	ld	h,0
;RB2exit2:
	ld	l,a
.endasm
}



