#include "ressdk.h"
#include "f_sdkapi.h"

typedef unsigned int  word;
typedef unsigned char byte;
typedef unsigned long ulong;

#ifndef NULL
#define NULL '\0'
#endif

#ifndef CRLF
#define CRLF "\r\n";
#endif 

#ifndef evPaint
#define evPaint		0x81
#define evCreate	0x82
#define evQuit		0x83
#define evDestroy	0x84

#define MAX_WINDOWS	15
#define MAX_MSGS	100

#endif

typedef struct TagMessage
{
 byte handle;
 unsigned short evType;
 byte x;
 byte y;
}Message;


typedef struct TagWindow
{
 int 			used;
 int			Modal;
 byte			wleft;
 byte			wtop;
 byte			wright;
 byte			wbottom;
 unsigned short	wflags;
 int 			(*WndProc)(byte, unsigned short , byte, byte);
 unsigned short	WndProcBank;   
 CONST_FAR_PTR	wTitle;
 CONST_FAR_PTR	wMenu;
 PDESKBOX 		*Wnd;
}Window;


extern BANKED void 		PostMessage(byte handle, unsigned short evType, byte x, byte y);
extern BANKED short		RunApplication(void);
extern BANKED byte		CreateWindow(CONST_FAR_PTR Win);
extern BANKED short		CreateModalWindow(CONST_FAR_PTR Win);
extern BANKED void  	DestroyWindow(byte handle);
extern BANKED VOID_PTR	GetWindowPtr(byte handle);
extern BANKED void  	RotateWindow(byte handle);
extern BANKED byte		GetWinHeight(byte handle);
extern BANKED byte		GetWinWidth(byte handle);
extern BANKED void  	DispatchMessages(void);
extern BANKED void 		InsertControl(byte handle, PVIEW *p);

extern BANKED void 		DrawString(byte h, byte x, byte y, CONST_FAR_PTR str, short attr);
extern BANKED void 		DrawTime(byte h, byte x, byte y, short attr);
extern BANKED char 		DecimalSeparator(void);
extern BANKED int 		isdigit(char c);
extern BANKED int 		isalpha(char c); 
extern BANKED int 		printff(int v);
extern BANKED int 		printfn(int v);
extern BANKED int 		printfs(CONST_FAR_PTR v);
