#include "defaults.h"
#include "ressdk.h" 

void OnPaint(VOID_PTR thisView);
void OnCreate(PDESKBOX *thisView);
void OnPenDown(VOID_PTR thisView, unsigned char x, unsigned char y);
void OnPenUp(VOID_PTR thisView, unsigned char x, unsigned char y);
void OnPenMove(VOID_PTR thisView, unsigned char x, unsigned char y);
void OnPenAuto(VOID_PTR thisView, unsigned char x, unsigned char y); 
void OnUnknown(VOID_PTR thisView, short *evType, unsigned char x, unsigned char y); 
void OnKeyDown(VOID_PTR thisView, unsigned char KeyCode); 
void OnTimer(VOID_PTR thisView);
void OnCommand(VOID_PTR thisView, WORD Cmd);

void far _DefaultDrawHandler(VOID_PTR thisView)
{
 /* default system paint proc */
 PDESKBOX_draw(thisView);
 /*DrawLine(Left, Bottom - 25, Right, Bottom - 25, DRAW_B2DOT);*/
 /* dispatch paint message */
 OnPaint(thisView);
}


void far _DefaultProcHandler(VOID_PTR thisView, unsigned short *evType, unsigned char x, unsigned char y)
{
 /* default system proc handler */
 PDESKBOX_handleEvent(thisView, evType, x, y);
 /* dispatch messages */
 switch(*evType)
 {
  case evCommand: 
     OnCommand(thisView, ((WORD) x << 8) | (WORD) y);
     break;

  case evPenDown :
     OnPenDown(thisView,x,y);
     break;

  case evPenDownMove :
     OnPenMove(thisView,x,y);
     break;

  case evPenAuto :
     OnPenAuto(thisView,x,y);
     break;

  case evPenUp :
     OnPenUp(thisView,x,y);
     break;

  /*case evPen :*/
     
  case evKeyDown:
     OnKeyDown(thisView, x);
     break;

  case evTimer :
     OnTimer(thisView);
     break;

  default:
     OnUnknown(thisView, evType, x, y);
     break;
 }
/* ApplicationProcHandler(thisView, evType, x, y);*/
}


VOID_PTR CreateMainWindow(CONST_FAR_PTR title, CONST_FAR_PTR menu)
{
 VOID_PTR retval;
 PDESKBOX *dsk;

 dsk = (PDESKBOX *) 
   CreateDeskBox('A', 0, 0, 159, 239, title, menu, 0, bafClose|bafDotTitle);
 dsk->options &= ~ofFindable;

 BankedAssign(dsk->handleEvent, _DefaultProcHandler);
 BankedAssign(dsk->draw, _DefaultDrawHandler);

 /* dispatch the OnCreate message */
 OnCreate(dsk);

 retval = dsk;
 return retval;
}

WORD StartApplication(CONST_FAR_PTR title, CONST_FAR_PTR menu)
{
 PDESKBOX *dsk;
 WORD retval;

 dsk = (PDESKBOX *)CreateMainWindow(title, menu);
 retval = ExecView ((PGROUP *) dsk);

 Destroy ((VOID_PTR) dsk);
	
 return retval;
}



