#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
 *	iver : a program to put version number information into the icon
 *        bitmap of an Avigo application program.
 *
 *			 Invoke with the name of the application followed by the X and
 *			 Y coordinates in the icon image of where to place the version
 *			 number.
 *
 *			 Now also optionally shows all header fileds and displays
 *			 large version of application icon.
 *
 *	 Copyleft 1998 by Hans B Pufal <mailto:hansp@digiweb.com>
 */

unsigned char
	img[512],

	digits[] = {
		0x06, 0x09, 0x09, 0x09, 0x09, 0x09, 0x06,  /* 0 */
		0x02, 0x06, 0x02, 0x02, 0x02, 0x02, 0x02,	 /* 1 */
		0x06, 0x09, 0x01, 0x06, 0x08, 0x08, 0x0F,	 /* 2 */
		0x0E, 0x01, 0x01, 0x06, 0x01, 0x01, 0x0e,	 /* 3 */
		0x09, 0x09, 0x09, 0x0F, 0x01, 0x01, 0x01,	 /* 4 */
		0x0F, 0x08, 0x08, 0x0E, 0x01, 0x09, 0x06,	 /* 5 */
		0x06, 0x09, 0x08, 0x0E, 0x09, 0x09, 0x06,	 /* 6 */
		0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,	 /* 7 */
		0x06, 0x09, 0x09, 0x06, 0x09, 0x09, 0x06,	 /* 8 */
		0x06, 0x09, 0x09, 0x07, 0x01, 0x09, 0x06,	 /* 9 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C	 /* . */
	};


void setbit (int x, int y, int v)
{
	unsigned char
		*imgp = img + 0x47 + (7 * y) + (x >> 3),
		vbit = 1 << (7 - (x & 7));

	if (v)
		*imgp |= vbit;
	else
		*imgp &= ~ vbit;

}


void setdigit (int x, int y, int d)
{
	unsigned char
		dbit,
		*dp = digits + d * 7;

	int
		i,j;

	for (i = 0; i < 7; i++)
	{
		dbit = 0x08;
		for (j = 0; j< 4; j++)
		{
			setbit (x+j, y, *dp & dbit);
			dbit >>= 1;
		}

		setbit (x+4, y, 0);

		y++;
		dp++;
	}

	setbit (x, y, 0);
	setbit (x+1, y, 0);
	setbit (x+2, y, 0);
	setbit (x+3, y, 0);
	setbit (x+4, y, 0);
}


static char *months[] =	{
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};


#define mname(i) (((i > 0) && (i <= 12)) ? months[i-1] : "???")



void show_icon (int w, int h, int t, unsigned char *s)

{

	unsigned char
		bits,
		cnt;

	int
		x, y;


	
	for (y = 0; y < h; y++)
	{
		bits = *s++;
		cnt = (t && ((bits == 0) || (bits == 0xFF))) ? *s++ : 1;

		printf ("    '");

		for (x = 0; x < w; x++)
		{

			printf ("%c", (bits & (1 << (7-(x & 7)))) ? '*' : ' ');

			if (((x & 7) == 7) && (--cnt == 0))
			{
				bits = *s++;
				cnt = (t && ((bits == 0) || (bits == 0xFF))) ? *s++ : 1;
			}
		}

		printf ("'\n");
	}

}



void header_dump (void)
{
	char
		s[16];

	printf ("[01] Entry point : $%04X\n", (unsigned int)img[1] + ((unsigned int)img[2] << 8)); 
	printf ("[03]   Copyright : %s\n", strncpy (s, img+3, 16));
	printf ("[13]  Other info : %s\n", strncpy (s, img+0x13, 16));

	switch (img[0x23])
	{
	case 1:
		printf ("[23]        Type : Calculator\n");
		break;

	case 2:
	case 0xFF:
		printf ("[23]        Type : Application\n");
		break;

	default:
		printf ("[23]        Type : ?App $%02X\n", img[0x23]);
		break;
	}

	printf ("[24]          ?? : $%02X, $%02X\n", img[0x24], img[0x25]);
	printf ("[26]        Date : %2d %3s %4d\n", img[0x28], mname(img[0x27]), 1901 + img[0x26]); 
	printf ("[29]        Time : %02d:%02d:%02d\n", img[0x29], img[0x2A], img[0x2B]);
	printf ("[2C]    App name : %s\n", strncpy (s, img+0x2C, 16));
	printf ("[3C]     Version : %d.%02d\n", img[0x3C], img[0x3D]);
	printf ("[3E]          ?? : $%02X, $%02X\n", img[0x3E], img[0x3F]);
	printf ("[40]        Size : %dKb\n", img[0x40]);
	printf ("[41]          ?? : $%02X, $%02X\n", img[0x41], img[0x42]);
}


int main (int argc, char *argv[])
{
	FILE
		*imgfile;

	unsigned char
		ver_1,
		ver_2;

	char
		imgname[80];

	int
		argi,
		errflag = 0,
		xflag = 1,
		yflag = 1,
		fflag = 1,
		hexflag = 0,
		dumpflag = 0,
		x,
		y;


	for (argi = 1; argi < argc; argi++)
	{
		switch (*argv[argi])
		{
		case '-':
		case '/':
			switch (*(argv[argi]+1))
			{
			case 'd':
			case 'D':
				dumpflag ^= 1;
				break;

			case 'h':
			case 'H':
				hexflag ^= 1;
				break;

			case 'i':
			case 'I':
				dumpflag ^= 2;
				break;

			default:
				printf ("Bad option : \n\n");

			case '?':
				printf ("iver 1.2 : Avigo header file display/modify\n\n");
				printf ("invoke with :\n\n");
				printf ("   [-[dhi?] appname [x y]\n\n");
				printf ("    -d invokes header dump\n");
				printf ("    -i invokes icon display\n");
				printf ("    -h interprets version number as hex\n");
				printf ("    -? shows this help\n");
				printf ("    appname is an application binary\n");
				printf ("    x and y are decimal numbers specifying icon coordinates for version\n");

				exit (1);
			}

			break;

		case '0': case '1': case '2':
		case '3': case '4': case '5':
		case '6': case '7': case '8':
		case '9':	
			if (xflag)
			{
				x = atoi (argv[argi]);
				xflag = 0;
			}

			else if (yflag)
			{
				y = atoi (argv[argi]);
				yflag = 0;
			}

			else
			{
				printf ("Too many numeric parameters, need only 2 : X and Y\n");
			 	errflag++;
			}

			break;

		default:
			if (fflag)
			{
				strcpy (imgname, argv[argi]);

				if (NULL == (imgfile = fopen (imgname, "r+b")))
				{
					strcat (imgname, ".app");

					if (NULL == (imgfile = fopen (imgname, "r+b")))
					{
						printf ("Cannot open file '%s'\n", argv[argi]);
						errflag++;
					}
				}

				fflag = 0;
			}
			else
			{
				printf ("Cannot specify more than one file\n");
				errflag++;
			}
			break;
		}
	}

	if (fflag)
	{
		printf ("Must specify application file name\n");
		errflag++;
	} else
	{
		if (512 != fread (img, 1, 512, imgfile))
		{
			perror ("fread failed ");
			exit (1);
		}

		if ((img[0x44] != 0x34) || (img[0x45] != 0x32) || (img[0x46] != 0))
		{
			printf ("%s does not appear to be an Avigo app file\n");
			exit (1);
		}
	}

	if ((errflag == 0) && (dumpflag))
	{
		if (dumpflag & 1)
			header_dump ();

		if (dumpflag & 2)
			show_icon (img[0x44], img[0x45], img[0x46], &img[0x47]);

		if (xflag || yflag)
			exit (0);
	}


	if (xflag  || yflag)
	{
		printf ("Must specify X and Y coordinates of version in icon\n");
		errflag++;
	}

	if (img[0x47] != 0)
	{
		printf ("Cannot edit compressed icon\n");
		errflag++;
	}

	if (errflag)
		return 1;

	ver_1 = img[0x3C];
	ver_2 = img[0x3D];

	if (hexflag)
	{
		ver_1 = ver_1 & 0x0F + 10 * (ver_1 >> 4);
		ver_2 = ver_2 & 0x0F + 10 * (ver_2 >> 4);
	}


	printf ("Stamping %s with version %d.%02d at (%d,%d)\n", imgname,
		ver_1, ver_2, x, y);

	if (ver_1 > 9)
	{
		setdigit (x, y, ver_1/10);
		x += 5;
	}

	setdigit (x, y, ver_1 % 10);
	x += 5;
	setdigit (x, y, 10);
	x += 3;
	setdigit (x, y, ver_2 / 10);
	x += 5;
	setdigit (x, y, ver_2 % 10);

	fseek (imgfile, 0L, SEEK_SET);

	if (512 != fwrite (img, 1, 512, imgfile))
		perror ("fwrite failed ");

	fclose (imgfile);

	return 0;
}
