/**********************************************************************
Project:	Maze for Avigo
Module:		Main
File:		amazea.c

	A Mazing Avigo Copyright (c) 1998 by Jouni Miettunen
***********************************************************************

Description:
	Simple maze for Avigo. Avigo porting based on Sokoban
	sample program from Freeware Avigo SDK made by G. Vermeulen

	avapp -p1 -ramazea.app
	avapp -p1 -dAmazea
	
History:

Version: Maze 0.1         15 October 1998        Jouni Miettunen
	JOM 151098 Started based on Drobos

Version: Maze 0.2         23 October 1998        Jouni Miettunen
	JOM 221098 GUI stuff added, play speedup
	JOM 231098 Skeleton application released (maze stripped)	

Version: Maze 0.3         26 October 1998        Jouni Miettunen
	JOM 241098 New maze algorithm
	JOM 251098 Menu handling

Version: Maze 0.31        18 November 1998        Jouni Miettunen
	JOM 181198 recompile with AfSDK 0.92b1 (16k application!)

Version: Maze 0.31        26 May 1999        	  Samuel Arriaga
	JOM 260599 Now Menu handling Works 
		   recompile with AfSDK 0.93b2 (still 16k !)
**********************************************************************/

#include "amazea.h"

/**********************************************************************/
int New =0;
void delay_sec() {
    int i;
    for (i=0; i<20; i++)
        Delay_10ms();
}

int main ()
{
int nResult = 0;

	init_screen();

	do
	{
		generate_maze();
		draw_maze();
		ClearKeyBuffer();

		do
		{
			if (nResult = move_in_maze())
				break;
				
		} while (1);

	} while (gMode == MODE_NEW);
	
	return nResult;

} /* End of main */

/**********************************************************************/
void init_screen()
{
int	x;

	/***** Start of general stuff *****/

	SetFontType(PRPFONT11B);
	x = GetStringLength(PROGRAM_TITLE,PRPFONT11B);

	SetToVirtualLCD(0);
	ClearLCD(0);

	/* Title bar and frame */
	DrawRect(0,11,LCD_WIDTH-1,LCD_HEIGHT-1,DRAW_BLACK);
	DrawSystemIcon(0,0,43,PUT);
	DrawSystemIcon(147,0,43,PUT);
	FillRect(9,0,150,8,DRAW_BLACK);
	FillRect(0,9,159,10,DRAW_BLACK);

	/* Exit and menu buttons */
	DrawSystemIcon(144,2,126,PUT);
	DrawSystemIcon(3,2,220,PUT);

	/* Title */
	WriteString(14,0,PROGRAM_TITLE,DRAW_WHITE);
	DrawLine(x+15,8,143,8,DRAW_W3DOT);

	/***** End of general stuff *****/

	/* Play area */
	DrawRect(OFFSET_X-1,OFFSET_Y-1,OFFSET_X+MX*8+1,OFFSET_Y+MY*8+1,DRAW_BLACK);

/*	DrawRect
	(
		NEW_X1,
		NEW_Y1,
		NEW_X2,
		NEW_Y2,
		DRAW_BLACK
	);

	DrawSystemIcon(NEW_X1,NEW_Y1,19,PUT);
	DrawSystemIcon(NEW_X2,NEW_Y1,23,PUT);
	WriteString(NEW_X1+8,NEW_Y1+3,STR_NEW_GAME,DRAW_BLACK);
*/

	SetToRealLCD(0);

	LCDCopy(VIRTTOREAL);

	gMode = MODE_NEW;
	randomize();
	
} /* End of init_screen */

/**********************************************************************/
void generate_maze()
{
int i,j;

        DrawSystemIcon(20, 108, 44, PUT);
        DrawSystemIcon(128, 108, 48, PUT);
	FillRect(25,108,132,120,DRAW_BLACK);

	SetFontType(PRPFONT7N);
	WriteString(36,110,"Creating New Maze ...",1);

	/* Cleanup */
	/* memset(gMap,0,sizeof(gMap)); */
	for (i=0; i<MX; i++)
		for (j=0; j<MY; j++)
			gMap[i][j] = 0;
			
	/* Create new */
	MakeMaze(0,0);

	gManx = 0;
	gMany = 0;
	/*gMap[gManx][gMany] |= FLAG_TILE_DOT;*/
		
} /* End of generate_maze */

/**********************************************************************/
int move_in_maze ()
{
unsigned char penx,peny;
int key;

	while (-1)
	{
		key = GetKey(&penx,&peny);
		switch (key)
		{
		case 0:
		case PGDN:
		case PGUP:
			key = 0;
			break;
		case 255:
			if (key = handle_pen_press(penx,peny))
			{
				switch (key)
				{
				case 1:
					/* Moved man, but return zero to continue */
					return 0;
				case 2:
					/* We won a game */
					gMode = MODE_NEW;
					/* do winning screen */
					return 2;
				case 100:
					/* New game */
					gMode = MODE_NEW;
					return 100;
				case -1:
					/* Exit program */
					gMode = MODE_EXIT;
					return APPLICATION;
				default:				
					return 0;
				}
			}
			break;
		default:
			return key;
		}
	}
	return 0;

} /* End of move_in_maze */

/**********************************************************************/
void draw_tile(int x,int y)
{
int	x1, x2, y1, y2;
int	iTile;

	x1 = OFFSET_X + (x<<3);
	x2 = x1 + 8;
	y1 = OFFSET_Y + (y<<3);
	y2 = y1 + 8;
	iTile = gMap[x][y];
	
	if (!(iTile & FLAG_OPEN_UP))
		DrawLine(x1,y1,x2,y1,DRAW_BLACK);
	if (!(iTile & FLAG_OPEN_LEFT))
		DrawLine(x1,y1,x1,y2,DRAW_BLACK);
	if (!(iTile & FLAG_OPEN_DOWN))
		DrawLine(x1,y2,x2,y2,DRAW_BLACK);
	if (!(iTile & FLAG_OPEN_RIGHT))
		DrawLine(x2,y1,x2,y2,DRAW_BLACK);
	
} /* End of draw_tile */

/**********************************************************************/
void draw_maze()
{
int
	x,y;
unsigned char
	ucSaveDotSize;

	ucSaveDotSize = GetDotSize();
	SetDotSize(1);

	SetToVirtualLCD(0);

	ClearLCDArea
	(
		OFFSET_X,
		OFFSET_Y,
		OFFSET_X + (MX-1)*8 + 7,
		OFFSET_Y + (MY-1)*8 + 7,
		0
	);

	for (y = 0; y<MY; y++)
		for (x = 0; x<MX; x++)
			draw_tile(x,y);

	/* Start at (0,0), finish at (MX-1,MY-1) */
	FillCircle(OFFSET_X+4,OFFSET_Y+4,3,DRAW_BLACK);
	FillCircle(OFFSET_X+((MX-1)<<3)+4,OFFSET_Y+((MY-1)<<3)+4,3,DRAW_BLACK);
	DrawDot(OFFSET_X+(gManx<<3)+3,OFFSET_Y+(gMany<<3)+3,DRAW_BLACK);

	SetToRealLCD(0);
	LCDCopy(VIRTTOREAL);

	SetDotSize(ucSaveDotSize);
	gMap[gManx][gMany] |= FLAG_TILE_DOT;
	
} /* End of draw_maze */

/**********************************************************************/
int move_man (int dx,int dy)
{
int
	iResult,
	x = gManx + dx,
	y = gMany + dy;
unsigned char
	ucSaveDotSize;

	/* Can we go wanted direction */
	if
	(
		/* Out of field */
		x < 0 ||
		x >= MX ||
		y < 0 ||
		y >= MY
	)
	{
		return 0;
	}
	
	/* Is direction allowed */
	if (dx)
	{
		iResult = (dx == 1) ? FLAG_OPEN_RIGHT : FLAG_OPEN_LEFT;
	}
	else
	{
		iResult = (dy == 1) ? FLAG_OPEN_DOWN : FLAG_OPEN_UP;
	}

	if (!(gMap[gManx][gMany] & iResult))
	{
		return 0;
	}
	iResult = 0;

	ucSaveDotSize = GetDotSize();
	SetDotSize(1);

	/* Trying to go backwards */
	if (gMap[x][y] & FLAG_TILE_DOT)
	{
		/* Go back where you came from */
		gMap[gManx][gMany] &= ~FLAG_TILE_DOT;
		SetToVirtualLCD(0);
		DrawDot(OFFSET_X+(gManx<<3)+3, OFFSET_Y+(gMany<<3)+3,DRAW_WHITE);
		SetToRealLCD(0);
		DrawDot(OFFSET_X+(gManx<<3)+3, OFFSET_Y+(gMany<<3)+3,DRAW_WHITE);
		gManx += dx;
		gMany += dy;
	}		
	else
	{
		/* Moving into empty place is allowed */
		gManx += dx;
		gMany += dy;
		gMap[gManx][gMany] |= FLAG_TILE_DOT;
		SetToVirtualLCD(0);
		DrawDot(OFFSET_X+(gManx<<3)+3, OFFSET_Y+(gMany<<3)+3,DRAW_BLACK);
		SetToRealLCD(0);
		DrawDot(OFFSET_X+(gManx<<3)+3, OFFSET_Y+(gMany<<3)+3,DRAW_BLACK);

		/* Did we finish maze */
		if (gManx == MX-1 && gMany == MY-1)
			iResult = 2;
	}

	SetDotSize(ucSaveDotSize);

	/* 0 - no action */
	/* 1 - made a move */
	/* 2 - winning move */
	return (iResult);
	
} /* End of move_man */

/**********************************************************************/
int handle_pen_press (int x,int y)
{
	int dx,dy,iResult;
	int dx_sign = 1, dy_sign = 1;
	unsigned char penx,peny;

	/* Click on playing area */
	if
	(
		y >= OFFSET_Y &&
		y < OFFSET_Y + MY*8 &&
		x >= OFFSET_X &&
		x < OFFSET_X + MX*8
	)
	{
		y -= OFFSET_Y;
		x -= OFFSET_X;
		/* (dx,dy) is pressed (8x8) tile */
		dx = (x>>3) - gManx;
		dy = (y>>3) - gMany;

		if (dx && dy)
		{
			if (dx<0)
			{
				dx_sign = -1;
				dx *= -1;
			}
			if (dy<0)
			{
				dy_sign = -1;
				dy *= -1;
			}
			if (dx<dy)
				dx = 0;
			else
				dy = 0;

			dx *= dx_sign;
			dy *= dy_sign;
		}
		
		if (dy>1)
			dy = 1;
		else if (dy<-1)
			dy = -1;

		if (dx>1)
			dx = 1;
		else if (dx<-1)
			dx = -1;

		if (dx | dy)
			return (move_man(dx,dy));
		else		
			return 1;
	}

	/* Press MENU button */
	else if (x>MENU_X1 && x<MENU_X2 && y>MENU_Y1 && y<MENU_Y2)
	{
		iResult = handle_menu_button();
		LCDCopy(VIRTTOREAL);
		if(New==1)
		{
		New=0;
		return 100;
		}


	}
	
	/* Press EXIT button */
	else if (x>EXIT_X1 && x<EXIT_X2 && y>EXIT_Y1 && y<EXIT_Y2)
	{
		if (handle_exit_button() == 1)
		{
			return -1;
		}
	}
	
	return 0;

} /* End of handle_pen_press */

/**********************************************************************/
int handle_exit_button()
{
unsigned char penx,peny;
int iExitSelected = 0;

	while (GetKey(&penx,&peny))
	{
		if (penx>EXIT_X1 && penx<EXIT_X2 && peny>EXIT_Y1 && peny<EXIT_Y2)
		{
			if (iExitSelected == 1)
				continue;
			/* Hilight exit icon */
			DrawSystemIcon(144,2,129,PUT);
			iExitSelected = 1;
		}
		else
		{
			if (iExitSelected == 0)
				continue;
			/* Normal exit icon */
			DrawSystemIcon(144,2,126,PUT);
			iExitSelected = 0;
		}
	}

	if (iExitSelected)
	{
		/* Normal exit icon */
		DrawSystemIcon(144,2,126,PUT);
	}

	return (iExitSelected);

} /* End of handle_exit_button */

/**********************************************************************/
int handle_menu_button()
{
	/**   Code by Samuel Arriaga Flrez  ****/
	unsigned char penx,peny;
	int iMenuSelected = 0;
	int push = 0;

	SetToVirtualLCD(1);
	SetToRealLCD(0);
	ClearKeyBuffer();

	FillRect(2,13,80,40,DRAW_WHITE);
	DrawLine(1,39,78,39,DRAW_B1DOT);
	DrawLine(79,14,79,39,DRAW_B1DOT);
	DrawLine(80,12,80,37,DRAW_BLACK);
	DrawLine(2,40,79,40,DRAW_BLACK);
	SetFontType(PRPFONT11N);
	WriteString(5,13,"New Maze",DRAW_BLACK);
	WriteString(5,26,"About",DRAW_BLACK);

	do
	{
	while (GetKey(&penx,&peny))
	{
		if(peny>13 && peny<24 && penx<80)
		{
			InverseLCDArea(2,13,77,24);
			/* start new game */
			delay_sec();
			push =1;
			New = 1;

		}

		if(peny>24 && peny<39 && penx<80)
		{
			InverseLCDArea(2,25,77,37);
			MessageBox("  A Mazing Avigo v. 1.4  1998 by Jouni Miettunen. Modifications, by Samuel Arriaga Flrez.",mfWarning|mfOKButton);
			LCDCopy(VIRTTOREAL);
			push = 1;
			return 1;
		}
		
		if(peny>40 || penx>80)
		{
		push = 1;
		}

	}
	} while( push == 0);

	return (iMenuSelected);

} /* End of handle_menu_button && Samuel Arriaga's Code*/


/**********************************************************************/
int CountOpenings(int x, int y)
{
	if (x<0 || x>=MX || y<0 || y>=MY)
		return 5;

	return (gMap[x][y]);

} /* End of CountOpenings */

/**********************************************************************/
int CanWalk (int x, int y)
{
	if (CountOpenings(x+1,y) == 0) return 1; /* right */
	if (CountOpenings(x,y-1) == 0) return 1; /* up    */
	if (CountOpenings(x-1,y) == 0) return 1; /* left  */
	if (CountOpenings(x,y+1) == 0) return 1; /* down  */

	return 0;

} /* End of CanWalk */

/**********************************************************************/
int GetLocation(int *x, int *y)
{
	int i;
	int j;

	i = random(MX);
	j = random(MY);

	for (; i<MX; ++i)
	{
		for (; j<MY; ++j)
		{
			if (gMap[i][j] && CanWalk(i,j))
			{
				*x = i;
				*y = j;
				return 1;
			}
		}
		j = 0;
	}
	
	for (i = 0; i < MX; i++)
	{
		for (j = 0; j < MY; j++)
		{
			if (gMap[i][j] && CanWalk(i,j))
			{
				*x = i;
				*y = j;
				return 1;
			}
		}
	}

	return (-1);
	
} /* End of GetLocation */

/**********************************************************************/
void MakeMaze(int begx, int begy)
{
int
	x = begx,
	y = begy,
	xx,
	yy,
	i,
	j;
int
	iCounter = MX * MY - 1;

	while (iCounter)
	{
		/* Can we continue */
		if (CanWalk(x,y) == 0)
		{
			/* Get new starting location */
			if (GetLocation(&x,&y) == -1)
				return;
		}

#define GO_UP	0
#define GO_DOWN	1
#define GO_LEFT	2
#define GO_RIGHT	3

		/* Get random direction */
		if (x==0)
			i = GO_RIGHT;
		else if (y==0)
			i = GO_DOWN;
		else if (x==MX-1)
			i = GO_LEFT;
		else if (y==MY-1)
			i = GO_UP;
		else
			i = random(4);

		/* Try to go given direction, else find next best */
		switch (i)
		{
		case GO_LEFT:
			xx = -1;
			yy = 0;
			if (CountOpenings(x+xx,y+yy) == 0) break;
		case GO_RIGHT:
			i = GO_RIGHT;
			xx = 1;
			yy = 0;
			if (CountOpenings(x+xx,y+yy) == 0) break;
		case GO_UP:
			i = GO_UP;
			xx = 0;
			yy = -1;
			if (CountOpenings(x+xx,y+yy) == 0) break;
		case GO_DOWN:
			i = GO_DOWN;
			xx = 0;
			yy = 1;
			if (CountOpenings(x+xx,y+yy) == 0) break;

			/* First case again, in case we started from last 'real' case */
			i = GO_LEFT;
			xx = -1;
			yy = 0;
			if (CountOpenings(x+xx,y+yy) == 0) break;

			/* Second case again, in case we started from last 'real' case */
			i = GO_RIGHT;
			xx = 1;
			yy = 0;
			if (CountOpenings(x+xx,y+yy) == 0) break;

			/* Third case again, in case we started from last 'real' case */
			i = GO_UP;
			xx = 0;
			yy = -1;
		}

		/* Get random distance */
		switch (i)
		{
		case GO_LEFT:
		case GO_RIGHT:
			j = 2;
			break;
		default:
			j = 1;
		}
		j = random(j) + 2;

		/* Walk chosen distance into chosen direction */
		do
		{
			iCounter--;

			switch (i)
			{
			case GO_LEFT:
				gMap[x][y] |= FLAG_OPEN_LEFT;
				break;
			case GO_RIGHT:
				gMap[x][y] |= FLAG_OPEN_RIGHT;
				break;
			case GO_UP:
				gMap[x][y] |= FLAG_OPEN_UP;
				break;
			case GO_DOWN:
				gMap[x][y] |= FLAG_OPEN_DOWN;
				break;
			}

			x += xx;
			y += yy;

			switch (i)
			{
			case GO_LEFT:
				gMap[x][y] |= FLAG_OPEN_RIGHT;
				break;
			case GO_RIGHT:
				gMap[x][y] |= FLAG_OPEN_LEFT;
				break;
			case GO_UP:
				gMap[x][y] |= FLAG_OPEN_DOWN;
				break;
			case GO_DOWN:
				gMap[x][y] |= FLAG_OPEN_UP;
				break;
			}
		} while ((--j > 0) && (CountOpenings(x+xx,y+yy) == 0));
	}
} /* End of MakeMaze */

/**********************************************************************/
/*************************** A HAPPY END ******************************/
/**********************************************************************/
