/* file to be used with the WriteText routine (soon) in libgraphics
 * Per Bothner, Dec 1982
 * Inline command characters
 */

#ifndef BELL
#include <chars.h>
#endif

#include <bitbltops.h>

#define MINCHAR 	' '	/* first ordinary graphics character */
#define MAXCHAR		126	/* last ordinary graphics character */

#ifndef NULL
#define NULL		0
#endif
#define STOP		NULL	/* end of string */
#define FILL		127	/* no-op charcter: DEL */
#define FONT0		0320
#define FONT1		(FONT0+1)
#define FONT2		(FONT0+2)
#define FONT3		(FONT0+3)
#define FONT4		(FONT0+4)
#define FONT5		(FONT0+5)
#define FONT6		(FONT0+6)
#define FONT7		(FONT0+7)
#define FONT8		(FONT0+8)
#define FONT9		(FONT0+9)
#define FONT10		(FONT0+10)
#define FONT11		(FONT0+11)
#define FONT12		(FONT0+12)
#define FONT13		(FONT0+13)
#define FONT14		(FONT0+14)
#define FONT15		(FONT0+15)
#define FONTn		0340	/* Followed by byte to give font number - not implemented */
#define	QUOTE		0341
#define BegInverse	0342	/* Inverse video */
#define EndInverse	0343	/* Regular video, as opposed to inverse video */
#define BegItalic	0344
#define EndItalic	0345
#define BegBold		0346
#define EndBold		0347
#define SmallHskip	0350 /* followed by signed byte to give delta x */
#define After1ByteArg	0500	/* can be placed after codes which take one-byte
			arguments (e.g. QUOTE). This is to allow backwards parsing */

#define Left		0360
#define Right		0361
#define Up		0362
#define Down		0363
#define BegGroup	0364
#define EndGroup	0365
#define DELETE		0366

typedef struct _FontCodes
  {
    unsigned backgroundColor :1;	/* 1=white (default), 0=black */
    unsigned mustClearBackground :1;	/* 0 if paint, 1 if copy */
    unsigned fixedHeight :1;
    unsigned inverseIfHigh :1;	/* inverse video if high order bit set */
    unsigned char function;	/* some GXfunction such that mask bits=1 mean Noop */
    unsigned char unused;
    unsigned char fontNum;
  } FontCodes;

#define TextWhite	0x80000000
#define TextCopy	0x40000000
#define InverseIfHigh	0x10000000
#define TextStdPaint	(TextWhite|0x20000000|		\
	(((GXpaintInverted & 0x0F)|(GXnoop & 0xF0))<<16))
#define TextStdCopy	(TextWhite|TextCopy|0x20000000|	\
	(((GXcopyInverted & 0x0F)|(GXnoop & 0xF0))<<16))

enum TextRetCode /* codes returned by gentext, showing why */
  {
    TextRetOther,
    TextRetError,	/* bad font number and other bugs */
    TextRetBelow,	/* text is below clipping region */
    TextRetAbove,	/* text is above clipping region */
    TextRetRight,	/* text is to the right of the clipping region */
    TextRetCount,	/* used up count of characters to display */
    TextRetStop,	/* found a "stop" code (that is a zero byte) */
    TextRetLine		/* found a <LF> character in string */
  };
