#ifndef _COORDINATES
#define _COORDINATES
#define Scaled long	/* fixpoint number with 16 bits of fraction */

#ifdef OLD_COORDS
/* OLD STYLE */
/* The Y coordinate is stored first to emphasize that we're not really
 * using X/Y-coordinates. Rather, we are using row/column-coordinates:
 * The Y- or column-coordinate increases \down/ the screen/page.
 */

#define X 1	/* the x coordinate is normally measured left-to-right. */
#define Y 0	/* the y coordinate is normally measured top-to-bottom. */

typedef short Vector[2];
typedef Scaled ScaledVector[2];
#else
/* PROPOSED IMPROVEMENT: */
typedef struct
  {
    short v;	/* row number: going down with increasing v */
    short h;	/* column number: going right with increasing h */
  } Vector;

typedef struct { Scaled v, h;} ScaledVector;

typedef struct
  {
    short x, y;	/* normal Cartesian coordintes, with origin at bottom left */
  } Point;

#endif

typedef struct Rectangle
  {
    Vector start;
    Vector size;
  } Rectangle;
#endif _COORDINATES
