/*
 * A struct BitPtr points to a particular bit in a VRaster.
 * It is used for scanning though the bits of a VRaster
 */
 
#include <Vfont.h>

struct BitPtr
  {
    short x, y;
    /*rest is "user-invisible" */
    VRaster *r;
    BitWord *ptr;	/* points to current word */
    BitWord mask;	/* == BitWordOnes >> (col & (BitWord - 1)) */
  };

/* values for 'color' parameter of SearchBit */
#define SearchWhite 0
#define SearchBlack 1
#define SearchEdge 0
#define SearchDown 2
#define SearchUp 4

#ifdef LITTLE_ENDIAN
#define RSHIFT <<
#define SetRSHIFT <<=
#else /* BIG_ENDIAN */
#define RSHIFT >>
#define SetRSHIFT >>=
#endif

/* some of these could be optimized */
#define StdRight1Bit(bp) { register mask; (bp)->x++; \
	if ((mask = (bp)->mask RSHIFT 1) == 0) \
	{ (bp)->ptr++; mask = BitWordOnes;} (bp)->mask = mask; }
#define GetBit(bp) ((bp)->ptr & (bp)->mask & ~((bp)->mask RSHIFT 1))
#define Paint1Bit(bp) \
 { BitWord mask = (bp)->mask; mask &= ~(mask RSHIFT 1); *(bp)->ptr |= mask; }
#define ClearOneBit(bp) \
 { BitWord mask = ~(bp)->mask; mask |= (mask RSHIFT 1); *(bp)->ptr &= mask; }
#define SkipBitPtr(bp, n) \
  { register i = n; while (--i>=0) Right1Bit(bp); }
#define StdPaintNBits(bp, n) /* set n bits to black, then increment */	\
 { register i=n; register mask=(bp)->mask; register BitWord *ptr=(bp)->ptr;\
   while (--i>=0) {\
	*ptr |= mask & ~(mask RSHIFT 1);\
	if ((mask SetRSHIFT 1) == 0) {mask = BitWordOnes; ptr++;\
	  for (; i>=16; i-=16) *ptr++ = mask; }\
   } (bp)->x += (n); (bp)->mask = mask; (bp)->ptr = ptr; }
#define PaintNBitsSun100(bp, n) /* ditto, but Sun-100-like columns  */ \
 { register i=n; register mask=(bp)->mask; register BitWord *ptr=(bp)->ptr;\
   while (--i>=0) {\
	*ptr |= mask & ~(mask >> 1);\
	if ((mask >>= 1) == 0) {ptr+=(bp)->r[-1].stride; mask = BitWordOnes;}\
   } (bp)->x += (n); (bp)->mask = mask; (bp)->ptr = ptr;}
#define ColumnarRight1Bit(bp) { (bp)->x++; \
	if (((bp)->mask >>= 1) == 0)	\
	 { (bp)->ptr+=(bp)->r->stride???; (bp)->mask = BitWordOnes;}}
#define PaintNBits StdPaintNBits
#define Right1Bit StdRight1Bit
