/*
 * V well-known or static group identifiers.
 * Copyright (c) 1985 Stanford University, all rights reserved.
 *
 */

#ifndef VGROUPIDS

#define VGROUPIDS

#define IsGroupId( gid ) (gid & GROUP_ID_BIT)

#define IsLocalGroupId( gid )					\
 ((gid&(GROUP_ID_BIT|LOCAL_GROUP_BIT)) == (GROUP_ID_BIT|LOCAL_GROUP_BIT))

#define IsGlobalGroupId( gid )					\
 ((gid&(GROUP_ID_BIT|LOCAL_GROUP_BIT)) == GROUP_ID_BIT)

/* Static logical host group definitions.
 *
 * Each group-id must have both the GROUP_ID_BIT and the STATIC_GROUP_BIT
 *  turned on to be valid.  Group ids should be chosen with attention to the
 *  UNRESTRICTED and LOCAL_GROUP_BITs as well.  These manifests are defined 
 *  in Venviron.h.
 *
 * All V machines belong to logical host group 0.  Thus, this is used for 
 *  server groups in which we expect every machine to have members, for 
 *  example, the kernel server group and the team server group.  The
 *  V/Unix server belongs to logical host groups 0 and 1, so logical
 *  host group 1 is used for the storage server group and time server
 *  group.  Other static groups have their own unique logical host groups 
 *  assigned.
 */

/* Logical host zero represents the static local groups on this host. Group
 * ids are used instead of pids because migrating processes need to talk to
 * the server on the local machine instead of the server on the machine that
 * they were created on.
 */
#define GenericGid(gid)\
	if ( !( (gid) & LOGICAL_HOST_PART) && ( (gid) & LOCAL_GROUP_BIT ) )\
	    (gid) |= PidLhn(KernelServerPid)

/* Global groups -- systemwide.  Note: some are currently unused.
 * The only restricted groups are those whose members are all expected
 *   to be on the first team or in the kernel, and those expected to
 *   have only one member.
 */
#define LHG(n)	((n)<<17)
#define STATIC_GID(n) (LHG(n)|GROUP_ID_BIT|STATIC_GROUP_BIT)

#define VKERNEL_SERVER_GROUP	(STATIC_GID(0)|0x00)
#define VTEAM_SERVER_GROUP	(STATIC_GID(0)|0x04)
#define VSTORAGE_SERVER_GROUP	(STATIC_GID(1)|0x10|UNRESTRICTED_GROUP_BIT)
#define VTIME_SERVER_GROUP	(STATIC_GID(1)|0x0C|UNRESTRICTED_GROUP_BIT)
#define VSERVICE_SERVER_GROUP	(STATIC_GID(3)|0x08|UNRESTRICTED_GROUP_BIT)
#define VEXCEPTION_SERVER_GROUP	(STATIC_GID(0)|0x14)
#define VDEVICE_SERVER_GROUP	(STATIC_GID(0)|0x18)
#define VINTERNET_SERVER_GROUP	(STATIC_GID(4)|0x1C|UNRESTRICTED_GROUP_BIT)
#define VPRINT_SERVER_GROUP	(STATIC_GID(5)|0x20|UNRESTRICTED_GROUP_BIT)
#define VTERMINAL_SERVER_GROUP	(STATIC_GID(0)|0x24|UNRESTRICTED_GROUP_BIT)
#define VTEST_SERVER_GROUP	(STATIC_GID(6)|0x28|UNRESTRICTED_GROUP_BIT)
#define VPIPE_SERVER_GROUP	(STATIC_GID(7)|0x2C|UNRESTRICTED_GROUP_BIT)
#define VEXEC_SERVER_GROUP	(STATIC_GID(0)|0x30)
#define VAUTH_SERVER_GROUP	(STATIC_GID(8)|0x34)
#define VCSNH_SERVER_GROUP	(STATIC_GID(9)|0x38|UNRESTRICTED_GROUP_BIT) 
					/* all name-handling servers */
#define VCONF_SERVER_GROUP	(STATIC_GID(10)|0x3C|UNRESTRICTED_GROUP_BIT)
#define VTALIESIN_SERVER_GROUP	(STATIC_GID(11)|0x40|UNRESTRICTED_GROUP_BIT)
#define VDISPLAY_SERVER_GROUP	(STATIC_GID(12)|0x44|UNRESTRICTED_GROUP_BIT)
#define VINTERFACE_SERVER_GROUP	(STATIC_GID(13)|0x48|UNRESTRICTED_GROUP_BIT)


/* Local groups for each host.  Note: many are currently unused. */
#define THIS_HOST_GID GROUP_ID_BIT|LOCAL_GROUP_BIT|STATIC_GROUP_BIT

#define LKERNEL_SERVER_GROUP	(THIS_HOST_GID|0x00)
#define LTEAM_SERVER_GROUP	(THIS_HOST_GID|0x04)
#define LSTORAGE_SERVER_GROUP	(THIS_HOST_GID|0x08|UNRESTRICTED_GROUP_BIT)
#define LSERVICE_SERVER_GROUP	(THIS_HOST_GID|0x0C)
#define LTIME_SERVER_GROUP	(THIS_HOST_GID|0x10|UNRESTRICTED_GROUP_BIT)
#define LEXCEPTION_SERVER_GROUP	(THIS_HOST_GID|0x14)
#define LDEVICE_SERVER_GROUP	(THIS_HOST_GID|0x18)
#define LINTERNET_SERVER_GROUP	(THIS_HOST_GID|0x1C|UNRESTRICTED_GROUP_BIT)
#define LPRINT_SERVER_GROUP	(THIS_HOST_GID|0x20|UNRESTRICTED_GROUP_BIT)
#define LTERMINAL_SERVER_GROUP	(THIS_HOST_GID|0x24|UNRESTRICTED_GROUP_BIT)
#define LTEST_SERVER_GROUP	(THIS_HOST_GID|0x28|UNRESTRICTED_GROUP_BIT)
#define LPIPE_SERVER_GROUP	(THIS_HOST_GID|0x2C|UNRESTRICTED_GROUP_BIT)
#define LEXEC_SERVER_GROUP	(THIS_HOST_GID|0x30)
#define LAUTH_SERVER_GROUP	(THIS_HOST_GID|0x34)
#define LCSNH_SERVER_GROUP	(THIS_HOST_GID|0x38|UNRESTRICTED_GROUP_BIT)
#define LCONF_SERVER_GROUP	(THIS_HOST_GID|0x3C|UNRESTRICTED_GROUP_BIT)
#define LTALIESIN_SERVER_GROUP	(THIS_HOST_GID|0x40|UNRESTRICTED_GROUP_BIT)
#define LDISPLAY_SERVER_GROUP	(THIS_HOST_GID|0x44|UNRESTRICTED_GROUP_BIT)
#define LINTERFACE_SERVER_GROUP	(THIS_HOST_GID|0x48|UNRESTRICTED_GROUP_BIT)
#define LDIALOGUE_MANAGER_GROUP	(THIS_HOST_GID|0x4C|UNRESTRICTED_GROUP_BIT)
#define LEDITOR_GROUP		(THIS_HOST_GID|0x50|UNRESTRICTED_GROUP_BIT)

#endif VGROUPIDS
