/* Vexec.h: definitions for communication with the Exec Server, which creates
 * and manages executives.
 */

/* we include this to define RELEASE_INPUT, RELEASE_OUTPUT, and RELEASE_ERR */
#include <Vteams.h>

typedef struct 
  {
#ifndef LITTLE_ENDIAN
    SystemCode	requestcode;
    short	execid;
#else LITTLE_ENDIAN
    short	execid;
    SystemCode	requestcode;
#endif LITTLE_ENDIAN
    ProcessId	stdinserver;	/* the following are for CreateExec only */
    ProcessId	stdoutserver;
    ProcessId	stderrserver;
#ifndef LITTLE_ENDIAN
    InstanceId	stdinfile;
    InstanceId	stdoutfile;
    InstanceId	stderrfile;
    short	flags;
#else LITTLE_ENDIAN
    InstanceId	stdoutfile;
    InstanceId	stdinfile;
    short	flags;
    InstanceId	stderrfile;
#endif LITTLE_ENDIAN
    ProcessId nameserver;
    ContextId context;
  }  
    ExecRequest;

typedef struct
  {
    SystemCode  requestcode ;
    ProcessId   execPid ;
    int		removeAll ; 
     /* 
      * if 1, all execs with same user number are deleted, if 0, only set them
      * to UNKNOWN_USER.
      */
  }
LogoutExecReq;

typedef struct 
  {
#ifndef LITTLE_ENDIAN
    SystemCode	replycode;
    short	execid;
#else LITTLE_ENDIAN
    short	execid;
    SystemCode	replycode;
#endif LITTLE_ENDIAN
    ProcessId	pid;	/* pid of the exec */
    ProcessId	program; /* pid of the program running under it, if any */
#ifndef LITTLE_ENDIAN
    short	status;
    short	fill;
#else LITTLE_ENDIAN
    short	fill;
    short	status;
#endif LITTLE_ENDIAN
  }  
    ExecReply;

/* exec server request codes */
#define CREATE_EXEC 		0x4040
#define START_EXEC		0x6041
#define DELETE_EXEC		0x6042
#define KILL_PROGRAM		0x6043
#define QUERY_EXEC		0x6044
#define CHECK_EXECS		0x4045
#define LOGOUT_EXECS		0x4046
#define AUTH_EXEC		0x4847
#define DEAUTH_EXEC		0x4848

/* exec status codes */
#define EXEC_HOLD	0
#define EXEC_FREE	1
#define EXEC_LOADING	2
#define EXEC_RUNNING	3

/* exec i/o codes: these live in the same flags word with
 * RELEASE_INPUT, RELEASE_OUTPUT, etc.
 */
#define EXEC_ECHO	0x1000
#define EXEC_NOPROMPT	0x2000

#define EXEC_ROOTFLAGS	0x00FF
#define EXEC_IOFLAGS	0x3000
