/*
 * V Kernel - Copyright (c) 1982 by David Cheriton, Tim Mann
 * (Transliterated from Zed and Verex Kernel)
 *
 * VAX Exception handler manifests.
 * Exception vector addresses serve as the type code in the
 * exception message.  The following is a list of VAX exceptions.
 */

#include "Venviron.h"

#ifndef VEXCEPTION_CODES
#define VEXCEPTION_CODES

/*
 * These are longword indices into the SCB, as to where the interrupt
 * vectors reside.  Some are specific to certain architectures.  Read
 * the comments.  Undefined numbers are reserved by Digital.
 * The number of longwords pushed on the stack in the case of each trap
 * is also listed.
 */

#define	NumExceptions		256

#define	VecMachineChk		1	/* implementation (4 on mVAX I & II) */
#define	VecKernStackInval	2	/* 0 */
#define	VecPwrFail		3	/* 0 */
#define	VecResPrivInstrn	4	/* 0 */
#define	VecXFC			5	/* 0 */
#define	VecOperandReserved	6	/* 0 */
#define	VecAddrModeReserved	7	/* 0 */
#define	VecAccessCntlViol	8	/* 2 */
#define	VecXlationInval		9	/* 2 */
#define	VecTracePending		10	/* 0 */
#define	VecBreakPoint		11	/* 0 */
#define VecCompatibility	12	/* 1, Unused in the mVAX */
#define	VecArithmetic		13	/* 1 */

#define	VecCHMK			16	/* 1 */
#define	VecCHME			17	/* 1 */
#define	VecCHMS			18	/* 1 */
#define	VecCHMU			19	/* 1 */
#define	VecSBI_SILO		20	/* 0, Vax11/780 only */
#define	VecCorrMemRead		21	/* implementation, unused in mVAX */
#define	VecSBI_Alert		22	/* 0, VAX11/780 only */
#define	VecSBI_Fault		23	/* 0, VAX11/780 only */
#define	VecBusTimeout		24	/* implementation (0 on mVAX) */

#define	VecTrap1		33	/* 0 */
#define	VecTrap2		34	/* 0 */
#define	VecTrap3		35	/* 0 */
#define	VecTrap4		36	/* 0 */
#define	VecTrap5		37	/* 0 */
#define	VecTrap6		38	/* 0 */
#define	VecTrap7		39	/* 0 */
#define	VecTrap8		40	/* 0 */
#define	VecTrap9		41	/* 0 */
#define	VecTrapA		42	/* 0 */
#define	VecTrapB		43	/* 0 */
#define	VecTrapC		44	/* 0 */
#define	VecTrapD		45	/* 0 */
#define	VecTrapE		46	/* 0 */
#define	VecTrapF		47	/* 0 */
#define	VecIntervalTimer	48	/* 0 */

#define	VecUndoneEMT		50	/* 10, mVAX only */
#define	VecDoneEMT		51	/* 0, mVAX only */

#define	VecRxConsStor		60	/* 0, VAX11/750 only */
#define	VecTxConsStor		61	/* 0, VAX11/750 only */
#define	VecRxConsole		62	/* 0 */
#define	VecTxConsole		63	/* 0 */

#define	VecIntStart		64	/* 0 */
#ifdef VAX780
#define	VecIntBase		64	/* 0 */
#define	NumIntVecs		64
#else !VAX780
#define	VecIntBase		128	/* 0 */
#define VecDeqna		128
#define VecQvssUart		129
#define VecQvssMousePoll	130
#define	NumIntVecs		128
#endif
#define	VecInterrupt		256	/* an unused number to identify a
					*  generic interrupt occurrence */

/* a Machine independent Trap type -- Really shouldn't be here, but
 *	you know how it is...
 */
#define SUSPENDED	0x101

/* This does not include the pc and psl that are pushed on the
 *	stack in the case of ALL exceptions/interrupts.
 */
typedef union
  {

    /* Changing modes, Arithmetic, and Compatibility faults */
    struct
      {
	unsigned int	type;
      } one_param;

    /* Memory Management Faults */
    struct
      {
	unsigned int	acctype;
	unsigned long	virtaddr;
      } MM;

    /* Emulator Trap with FPD clear */
    struct
      {
	unsigned int	ir;
	unsigned int	oldpc;
	unsigned int	params[8];
      } EMT;

#if !defined(VAX780) && !defined(VAX750)
    /* Machine Check */
    struct
      {
	int		numbytes;	/* number of bytes of parameters */
	unsigned long	type;
	unsigned long	par1;
	unsigned long	par2;
      } MCheck;
#endif
  }
ExceptionStackFrame;

/* MicroVAX I Machine Check Codes */
#define	MC_MemControl_I	0
	/* Memory controller reached an invalid state.
	*  Par1 is usually the physical address of the last function.
	*  Par2 is the address that the MC had at the start of the function.
	*/
#define	MC_BadRead_I	1
	/* Unrecoverable read, parity, or ECC error.
	*  Par1 is the physical address of the page having the error
	*  Par2 is the address that the MC had at the start of the function.
	*/
#define	MC_NoMem_I	2
	/* Nonexistent Memory.
	*  Par1 has the physical address of the nonexistent memory.
	*  Par2 is the address that the MC had at the start of the function.
	*/
#define	MC_IllOp_I	3
	/* Accessing an unaligned word in I/O space.
	*  Par1 is the physical address of the bad I/O reference.
	*  Par2 is the address that the MC had at the start of the function.
	*/
#define	MC_PTRead_I	4
	/* BadRead of a Page Table.
	*  Par1 is the physical address of the page table entry.
	*  Par2 is the virtual address that caused this page reference.
	*/
#define	MC_PTWrite_I	5
	/* BadWrite of a Page Table (bad hardware).
	*  Par1 is the physical address of the page table entry.
	*  Par2 is the virtual address that caused this page reference.
	*/
#define	MC_CPUStore_I	6
	/* Control Store Parity error.  Par1 is zero, Par2 is zero. */
#define	MC_Micro_I	7
	/* Invalid state in micromachine, DIE.  Par1 is zero, Par2 is zero. */
#define	MC_Q22Bus_I	8
	/* Can't read vector from Q22 bus.  Par1 is zero, Par2 is zero. */
#define	MC_ParWrite_I	9
	/* Error writing on the stack, after checking that it would succeed.
	*  Par1 is the virtual address being written.  Par2 is zero.
	*/
/* Note: if the last 9 bits of the physical address above were:
 *	001 and the data length was word
 *	001 and the data length was long
 *	002 and the data length was long
 *	003 and the data length was long
 * then the page in which the error occurred could also have been the
 * one logically preceding the one specified.
 */


/*
 * MicroVAX II Machine Check codes:
 *   If we believe the manual, then all of these have:
 *	par1 = "most recent virtual address" (well, sometimes physical;
 *	       Manual also calls it "current contents of VAP register")
 *      par2 = sundry state information; however, since this is pretty obscure
 *	       and especially since we haven't left room for it in an
 *	       ExceptionRequest, we ignore all this good stuff.
 */
#define	MC_MicroFSD_II	1
	/* Impossible microcode state (FSD), whatever that means */
#define MC_MicroSSD_II	2
	/* Impossible microcode state (SSD) - ditto.		 */
#define MC_UndefFPU0_II	3
	/* Undefined FPU error code 0 - hope it makes sense to them. */
#define MC_UndefFPU7_II	4
	/* Undefined FPU error code 7 - likewise.		     */
#define MC_UndefMMTB_II	5
	/* Undefined memory management status (TB miss) */
#define MC_UndefMMM0_II	6
	/* Undefined memory management status (M = 0)   */
#define MC_PTE_P0_II	7
	/* Process PTE address in P0 space */
#define MC_PTE_P1_II	8
	/* Process PTE address in P1 space */
#define MC_InterruptID	9
	/* Undefined interrupt ID code */
#define MC_BusError_II	0x80
	/* Well, 80..83.  If:
	 *   bit 1 = 0 then read, else write
	 *   bit 0 = 0 then par2 is virtual address, else physical.
	 */

/*
 * MicroVAX Arithmetic trap/fault codes.  VAX architecture defines all values
 *   from 1 to 10, but MicroVAX I's and II's only generate these.
 */
#define	A_IOverflow	1	/* Integer Overflow */
#define	A_IDivBy0	2	/* Integer Divide By Zero */
#define	A_SubRange	7	/* Subscript Range */
#define	A_FOverflow	8	/* Floating point overflow */
#define	A_FDivBy0	9	/* Floating Point divide by zero */
#define	A_FUnderflow	10	/* Floating point underflow */

/* Masks for Memory Management faults */
#define	MM_Length	01	/* Fault was a length violation */
#define	MM_ProcessPT	02	/* Process (vs. System) page table fault */
#define	MM_Write	04	/* A Write/Modify access caused the fault */


/*
 * Format of message received from a kernel exception,
 * as sent to the exception server
 */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		requestcode;	/* EXCEPTION_REQUEST */
    unsigned short	type;		/* Machine-specific exception type */
    unsigned short	subtype;	/* Additional detail on exception type */
    unsigned short	code;		/* Type of memory reference */
#else LITTLE_ENDIAN
    unsigned short	type;		/* Machine-specific exception type */
    SystemCode		requestcode;	/* EXCEPTION_REQUEST */
    unsigned short	code;		/* Type of memory reference */
    unsigned short	subtype;	/* Additional detail on exception type */
#endif LITTLE_ENDIAN
    unsigned		accaddr;	/* Access address for bus and address errors */
    unsigned		instruction;	/* First word of instruction causing fault */
    unsigned		status;		/* status register */
    unsigned		errpc;		/* Program counter */
    char		*segment;	/* Beginning of team segment */
    unsigned		segmentsize;	/* Team segment size */
  } ExceptionRequest;


/* Format of message used to register an exception handler.
 */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode	requestcode;		/* REGISTER_HANDLER */
    short	fill;
#else LITTLE_ENDIAN
    short	fill;
    SystemCode	requestcode;		/* REGISTER_HANDLER */
#endif LITTLE_ENDIAN
    int regFlag;			/* Indicates whether to register (1)
					   or unregister (0) handler. */
    ProcessId handlerPid;		/* Pid of exception handler */
    ProcessId regPid;			/* Pid of process registering for */
  } RegHandlerRequest;

#endif VEXCEPTION_CODES
