/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1983 Stanford University, all rights reserved.
 *
 * Vkernel Environment manifests and types.
 */

#ifndef VENVIRON

#define VENVIRON

typedef unsigned short SystemCode;

typedef long Message[8];

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode	sysCode;
    short	fill;
#else LITTLE_ENDIAN
    short	fill;
    SystemCode	sysCode;
#endif LITTLE_ENDIAN
    unsigned	unspecified[4];
    unsigned	delivery;	/* Amount to deliver or delivered. */
    char	*segmentPtr;
    unsigned	segmentSize;
  }
MsgStruct;

/* Bit assignments for sysCode field */
#define SYSTEM_CODE		0x4000

/* Bit assignments for sysCode field when a requestcode. */
#define READ_BIT		0x0800
#define WRITE_BIT		0x0400
#define DATAGRAM_SEND_BIT	0x0200
#define SEGMENT_PRESENT		0x0C00 /* If READ or WRITE_BIT's are on */

/* Bit assignments for sysCode field when a replycode. */
#define REPLY_BIT		0x8000	/* Indicates this is a reply code. */
#define SYS_REPLY_CODE		0xC000	/* Else a request code */
#define ANONYMOUS_REPLY_BIT	0x1000	/* Reply as the forwarder of message.*/
#define REPLY_SEGMENT_BIT	0x0800	/* Reply segment has been specified. */
#define IMMEDIATE_REPLY_BIT	0x0400	/* Don't delay this reply, even if
					 * it is to a group send.
					 */
#define REPLY_RETURN_CODE	0xFF	/* Only low-order byte indicates the
					 * the actual return error code from
					 * request.
					 */

typedef unsigned long ProcessId;
#define GroupId		ProcessId
#define Process_id	ProcessId /* Temporary kludge */

typedef unsigned long ContextId;

typedef struct
  {
    ProcessId pid;
    ContextId cid;
  }
ContextPair;

#define	OK		0	/* no error */
#define NULL	0
#define MAXUNSIGNED	(0-1)
#define MSG_SIZE	(8*sizeof(long)) /* Size in bytes of a message */
#define MAX_APPENDED_SEGMENT 1024  /* Maximum amount of data from segment
				    * appended to a send or reply message. */

/* Fields in a process identifier (pid) or process group identifier (gid) */
#define GROUP_ID_BIT		0x00010000 /* 0 ==> pid, 1 ==> gid */
#define LOGICAL_HOST_PART	0xFFFE0000 /* pid or local gid: logical host id
					    * global gid: host group id */
#define LITTLE_ENDIAN_HOST	0x00020000 /* logical host id: byte order */
#define LOCAL_PID_PART		0x00007FFF /* pid: locally defined part */
#define REMOTE_ALIAS_PROCESS	0x00008000 /* pid: 1 ==> remote alias */
#define SPECIFIC_GROUP_PART	0x00003FFC /* gid: process grp w/in host grp */
#define STATIC_GROUP_BIT	0x00004000 /* gid: 1 ==> pre-assigned */
#define UNRESTRICTED_GROUP_BIT	0x00000002 /* gid: 1 ==> any user # may join */
#define LOCAL_GROUP_BIT		0x00000001 /* gid: 1 ==> local, 0 ==> global */

/* The following are the special user numbers in the system */
#define INVALID_USER		(0-1)
#define SUPER_USER		0
#define SYSTEM_USER		1
#define UNKNOWN_USER		2

/* Scopes for GetPid and SetPid */
/* REMOTE_PID is no longer supported */
#define	LOCAL_PID		2
#define ANY_PID			0

/* Logical Id's for GetPid and SetPid */
/* NOTE: GetPid and SetPid are being phased out in favor of
 *  well-known group ids and/or character-string naming.
 */
#define ACTIVE_PROCESS		0
#define EXCEPTION_SERVER	1
#define DEVICE_SERVER		2
#define INTERNET_SERVER		3
#define STORAGE_SERVER		4
#define UNIX_SERVER		5
#define TIME_SERVER		6
#define PRINT_SERVER		7
#define VGT_SERVER		8
#define NAME_SERVER		9
#define CONTEXT_SERVER		10
#define TEAM_SERVER		11
#define PIPE_SERVER		12
#define KERNEL_PROCESS		13
#define SERVICE_SERVER		14
#define VSTORAGE_SERVER		15
#define VMS_SERVER		16
#define EXEC_SERVER		18
#define LINK_SERVER		17
#define XVSTORAGE_SERVER        19
#define AUTH_SERVER		20
#define SERVICE_SERVER_WATCHDOG	21

/* Standard system reply and request codes.
 * These are designed to fit into 16 bits. The high-order 2 bits
 * flag these as system codes and indicate if a request or a reply
 * code. Only the low-order 8-bits are considered significant in reply codes
 * for generic error reporting. The remaining 6 bits can freely be used
 * to encode server-specific information.
 * Application-specific request and reply codes should be values with the
 * 16-th bit turned off.
 */

/* Standard system reply codes: returned as error reports and return
 * codes by reply messages from system processes.
 */
#define ILLEGAL_REQUEST		0xC001
#define NO_REPLY		0xC002
#define RETRY			0xC003
#define BAD_ARGS		0xC004
#define BAD_ADDRESS		0xC005
#define BAD_BUFFER		0xC006
#define NO_SERVER_RESOURCES	0xC007
#define NO_MEMORY		0xC008
#define NO_PERMISSION		0xC009
#define POWER_FAILURE		0xC00A
#define NOT_FOUND		0xC00B
#define BUSY			0xC00C
#define TIMEOUT			0xC00D
#define BAD_STATE		0xC00E
#define ABORTED			0xC00F
#define NONEXISTENT_PROCESS	0xC010
#define NOT_AWAITINGREPLY	0xC011
#define BAD_PROCESS_PRIORITY	0xC012
#define NO_PDS			0xC013
#define INVALID_FILE_ID		0xC014
#define NOT_READABLE		0xC015
#define NOT_WRITEABLE		0xC016
#define END_OF_FILE		0xC017
#define INVALID_MODE		0xC018
#define MODE_NOT_SUPPORTED	0xC019
#define BAD_BYTE_COUNT		0xC01A
#define BAD_BLOCK_NO		0xC01B
#define IO_BREAK		0xC01C
#define INTERNAL_ERROR		0xC01D
#define DEVICE_ERROR		0xC01E
#define REQUEST_NOT_SUPPORTED	0xC01F
#define NONEXISTENT_SESSION	0xC020
#define DUPLICATE_NAME		0xC021
#define SERVER_NOT_RESPONDING	0xC022
#define INVALID_CONTEXT_ID	0xC023	/* Invalid context identifier */
#define NOT_A_CONTEXT		0xC024	/* Named object not a context */
#define INVALID_CONTEXT INVALID_CONTEXT_ID /* temporary kludge */
#define KERNEL_TIMEOUT		0xC025
#define ILLEGAL_NAME		0xC026
#define HAS_SUBSTRUCTURE	0xC027
#define BAD_FORWARD		0xC028  /* Forward fails, reply to sender. */
#define AWOKEN			0xC029  /* Delay terminated by Wakeup */
#define NO_TDS			0xC02A  /* No team descriptors. */
#define NO_GROUP_DESC		0xC02B  /* No free group descriptors. */
#define BAD_REPLY_SEGMENT	0xC02C  /* Bad reply segment in reply message*/
#define DISCARD_REPLY		0xC02D  /* Kernel will discard reply. */
#define NOT_HERE		0xC02E
#define RETRY_UNICAST		0xC02F
#define MULTI_MANAGER		0xC030	/* Op illegal on multi-mgr object */
#define MORE_REPLIES		0xC031	/* GetReply may return more replies */

/* More reply codes will be added as needed */


/* System Standard Request Codes: to be used requesting all standard
 * system services.
 *
 */
#define NO_OPERATION		0x6000
#define CREATE_INSTANCE		0x5801
#define CREATE_INSTANCE_RETRY	0x4801
#define QUERY_INSTANCE		0x6002
#define RELEASE_INSTANCE	0x6003
#define READ_INSTANCE		0x7404
#define WRITE_INSTANCE		0x7805
#define WRITESHORT_INSTANCE	0x6005
#define SET_BREAK_PROCESS	0x6006
#define SET_INSTANCE_OWNER	0x6007
#define QUERY_FILE		0x6008
#define MODIFY_FILE		0x6009
#define SET_PROMPT		0x600A
#define EXCEPTION_REQUEST	0x5C0B
#define REGISTER_HANDLER	0x600C
#define NQUERY_FILE		0x780E
#define NMODIFY_FILE		0x780F
#define GET_TIME		0x6010
#define TERMINATE_TEAM		0x6012
#define LOOKUP_SERVER		0x7813
#define READ_AND_FORWARD	0x7414
#define REMOVE_FILE		0x5815
#define GET_ABSOLUTE_NAME	0x6C17
#define GET_CONTEXT_ID		0x7818
#define GET_CONTEXT_NAME	0x7419
#define GET_FILE_NAME		0x741A
#define READ_DESCRIPTOR		0x741B
#define NREAD_DESCRIPTOR	0x7C1C
#define WRITE_DESCRIPTOR	0x781D
#define NWRITE_DESCRIPTOR	0x781E
#define CREATE_FILE             0x581F

/* Kernel opcodes */
#define CREATE_PROCESS		0x4020
#define DESTROY_PROCESS		0x6021
#define QUERY_PROCESS		0x7422
#define MODIFY_PROCESS		0x7823
#define CREATE_TEAM		0x4024
#define SET_TEAM_PRIORITY	0x6025
#define SET_TEAM_SIZE		0x6026
#define DELAY			0x4027
#define WAKEUP			0x6028
#define GETTIME 		0x6029
#define SETTIME 		0x602A
#define SETPID			0x602B
#define QUERY_KERNEL		0x402C

#define CREATE_GROUP		0x602D
#define QUERY_GROUP		0x602E
#define JOIN_GROUP		0x602F
#define LEAVE_GROUP		0x6030

#define CREATE_HOST		0x4031

#define SET_USER_NUMBER		0x6032
#define GET_USER_NUMBER		0x6033
#define FORCE_EXCEPTION		0x4034
#define SET_DEBUG_MODE		0x6035

/* Authentication server requests */
#define AUTHENTICATE		0x4C36 /* Authenticate the given name */
#define ADD_USER		0x5C37
#define DELETE_USER	  	0x4C38
#define MODIFY_USER		0x4C39
#define MAP_USER_NAME		0x5C3A /* Map a name to an auth record */
#define MAP_USER_NUMBER		0x5C3B /* Map from a uid */

#define QUERY_PROCESSOR_USAGE	0x603F
#define GET_PID			0x6040
#define REBOOT			0x6041
#define KMEM			0x7442
#define PROFILE			0x7443
#define QUERY_PROCESS_PRIORITY	0x6044
#define SET_PROCESS_PRIORITY	0x6045
#define GET_FORWARDER		0x6046
#define CLEAR_MODIFIED_PAGES	0x7047
#define RETURN_MODIFIED_PAGES	0x7448
#define GET_OBJECT_OWNER	0x6049
#define SET_OBJECT_OWNER	0x604A
#define FREEZE_HOST		0x404B
#define UNFREEZE_HOST		0x404C
#define FORCE_SEND		0x404D
#define DESTROY_HOST		0x404E
#define EXTRACT_HOST		0x744F

#define RENAME_OBJECT		0x5850
#define RENAME_FILE		RENAME_OBJECT	/* temporary */
#define QUERY_STORAGE_STATS     0x6051
#define MODIFY_STORAGE_STATS    0x6052
#define PUT_ON_GREEN_HAT	0x7C53 /* Only works when facing east */
#define GET_STATUS_REQUEST	0x6054
#define QUERY_NAME		0x6855
#define DELETE_USER_CORRESPONDENCE	0x6056
#define ADD_USER_CORRESPONDENCE		0x6857
#define	CREATE_DUPLEX_INSTANCE	0x4058

#define TRANSFER_HOST		0x7859

#define COPY_FROM		0x405A
#define COPY_TO			0x405B
#define PASSWORD		0x485C	/* Authserver request */


/* Kernel request format */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    unsigned short opcode;
    short	garbage;
#else LITTLE_ENDIAN
    short	garbage;
    unsigned short opcode;
#endif LITTLE_ENDIAN
    ProcessId	pid;
    unsigned	unspecified[4];
    char	*segment;
    unsigned	length;
  } 
    KernelRequest;

/* Motorola 68000, VAX, and SUN workstation specific definitions */

#define INIT_STACK_SIZE 1024

typedef char *Unspec;

#define BYTES_PER_WORD	4

#define CLICKS_PER_SEC 100	/* Clock interrupts per second */

#ifdef LITTLE_ENDIAN
#define DifferentByteOrder(pid) (!(pid & LITTLE_ENDIAN_HOST))
#else
#define DifferentByteOrder(pid) (pid & LITTLE_ENDIAN_HOST)
#endif

#endif VENVIRON
