/*
 * framebuf.h - constants for the SUN graphics board version 1
 *
 * Bill Nowicki 	June 14, 1981
 * Vaughan Pratt	added GXleft etc. July 18, 1981
 * Bill Nowicki		October 26, 1981
 *	Updated for PC board
 *	Removed redundant definitions
 * Dave Brown		January 19, 1982
 *	GXsetMask, GXpattern, GXsetSource now use reg. set 3 
 *	(previously they used set 0 -- probably not a good idea)
 * Jeffrey Mogul	April 7, 1982
 *	Added definitions for GXUnit<n>Base, 0 < n < 7.  New
 *	"default" frame buffer address is GXUnit6Base; additional
 *	frame buffers live at successively lower addresses.
 * Jeffrey Mogul	April 8, 1982
 *	Changed all uses of GXUnit0Base to GXBase. This (GXBase) is
 *	not defined in this file; thus, it can be defined elsewhere
 *	as a constant, variable (especially, a register), or an extern.
 *	It should really be an address type, but is currently an int.
 * Vaughan Pratt	May 27, 1982
 *	Added definitions for GXSOURCE, GXDEST, and GXMASK, for use in
 *	Boolean expressions in SETGXFUNC().
 * Per Bothner		May 1985
 *	Pulled some relatively machine-independent "function" codes
 *	into a new file <bitbltops.h>.
 */

#include <bitbltops.h>

# define GXUnit0Base	(0x100000)	/* device 0 base adress */
# define GXUnit1Base	(0x120000)	/* device 1 base adress */
# define GXUnit2Base	(0x140000)	/* device 2 base adress */
# define GXUnit3Base	(0x160000)	/* device 3 base adress */
# define GXUnit4Base	(0x180000)	/* device 4 base adress */
# define GXUnit5Base	(0x1A0000)	/* device 5 base adress */
# define GXUnit6Base	(0x1C0000)	/* device 6 base adress */
/* Note: no GXUnit7Base, this would overlap Multibus I/O Space. */
#define	GXDefaultBase	GXUnit6Base	/* default Frame buffer */

/* Framebuffer base addresses for Sun-2 upgrades and Sun-2s. */
#define SUN2upgFbBase 0xFC0000/* Address of Sun-1 framebuffer in Sun-2(upg). */
#define SUN2FbBase 0xEC0000 /* Address of Sun-2 framebuffer in Sun-2 (proper).*/

/*
 * The low order 11 bits consist of the X or Y address times 2.
 * The lowest order bit is ignored, so word addressing works efficiently.
 */

# define GXselectX (0<<11)	/* the address is loaded into an X register */
# define GXselectx (0<<11)	/* the address is loaded into an X register */
# define GXselectY (1<<11)	/* the address is loaded into an Y register */
# define GXselecty (1<<11)	/* the address is loaded into an Y register */

/*
 * The screen is of size 1024x800 pixels.  It includes the left and top edges
 * and excludes the right and bottom edges of the following square.
 * NOTE: This assumes a portrait monitor.
 */

# define GXleft 0
# define GXright 800
# define GXtop 0
# define GXbottom 1024

/*
 * There are four sets of X and Y register pairs, selected by the following bits
 */

# define GXaddressSet0  (0<<12)
# define GXaddressSet1  (1<<12)
# define GXaddressSet2  (2<<12)
# define GXaddressSet3  (3<<12)
# define GXset0  (0<<12)
# define GXset1  (1<<12)
# define GXset2  (2<<12)
# define GXset3  (3<<12)

/*
 * The following bits indicate which registers are to be loaded
 */

# define GXnone    (0<<14)
# define GXothers  (1<<14)
# define GXsource  (2<<14)
# define GXmask    (3<<14)
# define GXpat     (3<<14)

# define GXupdate (1<<16)	/* actually update the frame buffer */


/*
 * These registers can appear on the left of an assignment statement.
 * Note they clobber X register 3.
 */

# define GXfunction *(short *)(GXBase+GXset3+GXothers+(0<<1) )
# define GXwidth    *(short *)(GXBase+GXset3+GXothers+(1<<1) )
# define GXcontrol  *(short *)(GXBase+GXset3+GXothers+(2<<1) )
# define GXintClear *(short *)(GXBase+GXset3+GXothers+(3<<1) )

# define GXsetMask    *(short *)(GXBase+GXset3+GXmask )
# define GXsetSource  *(short *)(GXBase+GXset3+GXsource )
# define GXpattern    *(short *)(GXBase+GXset3+GXpat )

/*
 * The following bits are written into the GX control register.
 * It is reset to zero on hardware reset and power-up.
 * The high order three bits determine the Interrupt level (0-7)
 */

# define GXintEnable   (1<<8)
# define GXvideoEnable (1<<9)
# define GXintLevel0	(0<<13)
# define GXintLevel1	(1<<13)
# define GXintLevel2	(2<<13)
# define GXintLevel3	(3<<13)
# define GXintLevel4	(4<<13)
# define GXintLevel5	(5<<13)
# define GXintLevel6	(6<<13)
# define GXintLevel7	(7<<13)

/*
 * These may appear in statement contexts to just
 * set the X and Y registers of set number zero to the given values.
 */

# define GXsetX(X)	*(short *)(GXBase|GXselectX|GXset0|((X)<<1)) = 1;
# define GXsetY(Y)	*(short *)(GXBase|GXselectY|GXset0|((Y)<<1)) = 1;

