/* A FontEntry is used in a FontTable, as described below.
 * It describes a font at a more user-oriented level
 */
#ifndef NOFONT
#define NOFONT 0xFF	/* code for illegal/non-existant font */

#ifndef FONT
#define FONT struct FontPrefix
#endif

typedef struct 
  {
    char *name;			/* String name of font */
    FONT *font;			/* pointer to font itself */
    unsigned char number;	/* number of font */
    unsigned char italic;	/* number of italic/not-italic version of
			current font. If zero, there is none. If this is an
			italic font, points to the corresponding roman font,
			whose number is LESS.
			*/
    unsigned char bold;		/* like italic, but for boldface */
    unsigned char filler[5];	/* to make this an even 16 bytes */
  } FontEntry;

/* These links are used if a program uses more than 16 fonts */
typedef struct _FontLink 
  {
    FontEntry fontEntry;
    struct _FontLink *next;
  } FontLink;

typedef struct
  {
    FontEntry first16[16];	/* first 16 fonts are statically allocated */
    FontLink *next;		/* list of fonts 17:255 */
  } FontTable;

extern FontTable Fonts;

/* codes returned by GetFontEntry if no font found: */
#define TooManyFonts	-1
#define FontFileNotFound -2
#define FontNotInFile -3	
#define BadFontFile -4		/* bad format of font file or archive */
#define NoFontMemory -5		/* malloc returned 0 */
#endif
