/* Processor-dependent definitions and typedefs. */

#ifndef VPROCESSOR
#define VPROCESSOR

/* Team origin address (lowest valid address in team space) */
#define TEAM_ORIGIN	0x20000

/* Processor State as stored in the process descriptor */
typedef struct
  {
	/* Machine dependent fields */
	Unspec	regs[16];	/* 8 data + 8 address registers */
				/* Supervisory stack ptr not stored */
	short	sr;		/* Status register for rte */
	Unspec	pc;		/* Pc register for rte */
	short	context;	/* Context of associated team */

	/* Machine independent fields */
        Unspec	*perProcess;	 /* Pointer to per process area */
        Unspec	**perProcessLoc; /* perProcess pointer stored at
				  * this address on a process switch */
  } Processor_state;
 
#define ByteSwapProcessor_state(ps) do { \
    ByteSwapLongInPlace(&((ps)->regs[0]), 16*sizeof(long)); \
    ByteSwapShortInPlace(&((ps)->sr), 1*sizeof(short)); \
    ByteSwapLongInPlace(&((ps)->pc), 1*sizeof(long)); \
    ByteSwapShortInPlace(&((ps)->context), 1*sizeof(short)); \
    ByteSwapLongInPlace(&((ps)->perProcess), 2*sizeof(long)); \
  } while (0)

#define USER_STACK_POINTER regs[15]		/* User Stack pointer in A7 */

/* Bits in status register */
#define TRACE_MODE		(1<<15)
#define SUPERVISOR_STATE	(1<<13)
#define INTERRUPT_MASK		(7<<8)
#define EXTEND_BIT		(1<<4)
#define NEGATIVE_BIT		(1<<3)
#define ZERO_BIT		(1<<2)
#define OVERFLOW_BIT		(1<<1)
#define CARRY_BIT		(1<<0)

#endif VPROCESSOR
