/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * V-System naming manifests, types and structures.
 */

#ifndef VNAMING
#define VNAMING

#include "Venviron.h"
#include "Vio.h"

/* Structures defining the template structure of standard name request
 * and reply messages.
 */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		requestcode;
    short unsigned	nameindex;	/* First byte of name to use */
#else LITTLE_ENDIAN
    short unsigned	nameindex;
    SystemCode		requestcode;
#endif LITTLE_ENDIAN
    unsigned		unspecified[4];	/* Name server-dependent */
    ContextId		namecontextid;	/* Context used to interpret name */
    char		*nameptr;
    unsigned		namelength;
  } NameRequest;

/* Structures defining the template structure of context request
 * and reply messages.
 */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		requestcode;
    short unsigned	nameindex;	/* First byte of name to use */
#else LITTLE_ENDIAN
    short unsigned	nameindex;
    SystemCode		requestcode;
#endif LITTLE_ENDIAN
    ContextPair		context;	/* Context being enquired about */
#ifndef LITTLE_ENDIAN
    short unsigned	flags;		/* Operation-dependent */
    InstanceId		instanceid;
#else LITTLE_ENDIAN
    InstanceId		instanceid;	/* Instance id being enquired about */
    short unsigned	flags;
#endif LITTLE_ENDIAN
    unsigned		filler2;
    ContextId		namecontextid;	/* Context used to interpret name */
    char		*nameptr;
    unsigned		namelength;
  } ContextRequest;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		replycode;
    short unsigned	nameindex;
#else LITTLE_ENDIAN
    short unsigned	nameindex;
    SystemCode		replycode;
#endif LITTLE_ENDIAN
    ContextPair		context;	/* Context being enquired about */
#ifndef LITTLE_ENDIAN
    short unsigned	flags;		/* Operation-dependent */
    InstanceId		instanceid;
#else LITTLE_ENDIAN
    InstanceId		instanceid;	/* Instance id being enquired about */
    short unsigned	flags;
#endif LITTLE_ENDIAN
    unsigned		filler2;
    ContextId		namecontextid;	/* Context used to interpret name */
    char		*nameptr;
    unsigned		namelength;
  } ContextReply;

/* Values for flags */
#define GROUP_PREFIX	1	/* Returned by QueryName to indicate all
				 *  names beginning with the returned
				 *  prefix are implemented cooperatively
				 *  by the returned group id.
				 */

/* Well known context manifests */
#define DEFAULT_CONTEXT			0
#define PUBLIC_CONTEXT			1
#define LOGIN_CONTEXT			2
#define ANY_CONTEXT			3
#define GLOBAL_ROOT_CONTEXT		4
#define TEAM_SERVER_CONTEXT		5
#define STORAGE_SERVER_CONTEXT		6
#define SERVICE_SERVER_CONTEXT		7
#define TIME_SERVER_CONTEXT		8
#define EXCEPTION_SERVER_CONTEXT	9	/*??*/
#define DEVICE_SERVER_CONTEXT		10	/*??*/
#define INTERNET_SERVER_CONTEXT		11
#define PRINT_SERVER_CONTEXT		12
#define VGT_SERVER_CONTEXT		13
#define PIPE_SERVER_CONTEXT		14
#define EXEC_SERVER_CONTEXT		15	/*??*/
#define AUTH_SERVER_CONTEXT		16
#define TEST_SERVER_CONTEXT		17
#define MAX_WELL_KNOWN_CONTEXTS		18 /* must be 1 greater than largest */

/* Define standard name component delimiters */
#define IsDelimiter(c) ((c)=='/' || (c)==']' || (c)=='\0')
#define ROOT_ESCAPE_CHAR '['

#define ContextPairEqual(cp1, cp2) \
	( (cp1).pid==(cp2).pid && (cp1).cid == (cp2).cid )

#endif VNAMING
