/*
 * V Kernel - Copyright (c) 1982 by David Cheriton, Tim Mann
 * (Transliterated from Zed and Verex Kernel)
 *
 * MC68000 and MC68010 Exceptions
 */

#ifndef BUSERROR
#include "Venviron.h"

/* MC 68000 exception types and addresses */

#define BUSERROR	0x008
#define ADDRERROR	0x00c
#define ILLINST		0x010
#define ZERODIV		0x014
#define CHKINST		0x018
#define TRAPVINST	0x01c
#define PRIVVIOL	0x020
#define TRACETRAP	0x024
#define EMU1010		0x028
#define EMU1111		0x02c
#define FORMATERR	0x038
#define UNINITINT	0x03c	
#define SPURINT		0x060
#define INT1		0x064
#define INT2		0x068
#define INT3		0x06c
#define INT4		0x070
#define INT5		0x074
#define INT6		0x078
#define INT7		0x07c
#define TRAP0		0x080
#define TRAP1		0x084
#define TRAP2		0x088
#define TRAP3		0x08c
#define TRAP4		0x090
#define TRAP5		0x094
#define TRAP6		0x098
#define TRAP7		0x09c
#define TRAP8		0x0a0
#define TRAP9		0x0a4
#define TRAP10		0x0a8
#define TRAP11		0x0ac
#define TRAP12		0x0b0
#define TRAP13		0x0b4
#define TRAP14		0x0b8
#define TRAP15		0x0bc

#define SUSPENDED	0x101


/* Exception stack frame formats */

typedef union
  {
    struct
      {
        unsigned short	   :11;
        unsigned short	rw :1;		/* Read/Write flag (1=read) */
        unsigned short	in :1;		/* Instruction flag (0=instruction) */
        unsigned short	fc :3;		/* Function Code */
      }
    field;

    unsigned short word;
  }
MC68000StatusWord;

typedef union
  {
    /* Address or bus error */
    struct
      {
	MC68000StatusWord	code;	/* Function code and flags */
	unsigned long		accaddr;
	unsigned short		ir;	/* Instruction register */
        unsigned short		sr;	/* Status register */
        unsigned long		pc;	/* Program counter */
      } ab;
    /* Other exceptions */
    struct
      {
        unsigned short	sr;		/* Status register */
        unsigned long	pc;		/* Program counter */
      } oe;
  }
MC68000ExceptionStackFrame;


typedef union
  {
    struct
      {
        unsigned short	rrf :1;		/* Re-Run flag (1=software) */
        unsigned short	    :1;
        unsigned short	iff :1;		/* Instruction Fetch flag */
        unsigned short	dff :1;		/* Data Fetch flag */
        unsigned short	rmf :1;		/* Read/Modify/Write flag */
        unsigned short	hbf :1;		/* High Byte flag */
        unsigned short	byf :1;		/* BYte transfer flag */
        unsigned short	rwf :1;		/* Read/Write flag (1=read) */
        unsigned short	    :5;
        unsigned short	fc  :3;		/* Function Code */
      }
    field;

    unsigned short word;
  }
MC68010StatusWord;

typedef struct
  {
    unsigned short	sr;		/* Status register */
    unsigned long	pc;		/* Program counter */
    unsigned short	format :4;	/* Format code */
    unsigned short	       :2;
    unsigned short	vector :10;	/* Vector offset */

    /* The following are only stacked on address or bus errors */
    MC68010StatusWord	sw;
    unsigned long	faultAddress;
    unsigned short	reserved1;
    unsigned short	dataOutputBuffer;
    unsigned short	reserved2;
    unsigned short	dataInputBuffer;
    unsigned short	reserved3;
    unsigned short	instructionInputBuffer;

    unsigned short	microRegisters[16];
  }
MC68010ExceptionStackFrame;


typedef union
  {
    struct
      {
	unsigned short	fc  :1;		/* Fault on stage C of pipeline */
	unsigned short	fb  :1;		/* Fault on stage B of pipeline */
	unsigned short	rc  :1;		/* Rerun stage C of pipeline */
	unsigned short	rb  :1;		/* Rerun stage B of pipeline */
	unsigned short	    :3;
	unsigned short	df  :1;		/* Data cycle fault */
	unsigned short	rm  :1;		/* Data cycle read-modify-write */
	unsigned short	rw  :1;		/* Data cycle write (0) / read (1) */
	unsigned short	siz :2;		/* Data cycle operand size */	
	unsigned short	    :1;
	unsigned short	fnc :3;		/* Data cycle function code */
      }
    field;

    unsigned short word;
  }
MC68020StatusWord;

typedef struct
  {
    unsigned long	iaddr;		/* Instruction address */
  }
MC68020SixWordStackFrame;

typedef struct
  {
    unsigned long	iaddr;		/* Instruction address */
    unsigned short	i[4];		/* Internal registers */
  }
MC68020CoprocessorExceptionStackFrame;

typedef struct
  {
    unsigned short	i1;		/* Internal register */
    MC68020StatusWord	sw;
    unsigned short	pipec;
    unsigned short	pipeb;
    unsigned long	faultaddr;
    unsigned short	i2;
    unsigned short	i3;
    unsigned long	dataOutputBuffer;
    unsigned short	i4;
    unsigned short	i5;
  }
MC68020ShortBusFaultStackFrame;

typedef struct
  {
    unsigned short	i1;		/* Internal register */
    MC68020StatusWord	sw;
    unsigned short	pipec;
    unsigned short	pipeb;
    unsigned long	faultaddr;
    unsigned short	i2;
    unsigned short	i3;
    unsigned long	dataOutputBuffer;
    unsigned short	i4;
    unsigned short	i5;
    unsigned short	i6;
    unsigned short	i7;
    unsigned long	baddr;
    unsigned short	i8;
    unsigned short	i9;
    unsigned long	dataInputBuffer;
    unsigned short	i10[22];
  }
MC68020LongBusFaultStackFrame;

typedef struct
  {
    unsigned short	sr;		/* Status register */
    unsigned long	pc;		/* Program counter */
    unsigned short	format :4;	/* Format code */
    unsigned short	       :2;
    unsigned short	vector :10;	/* Vector offset */

    union
      {
	MC68020SixWordStackFrame f1;
	MC68020CoprocessorExceptionStackFrame f2;
	MC68020ShortBusFaultStackFrame f3;
	MC68020LongBusFaultStackFrame f4;
      } frame;
  }
MC68020ExceptionStackFrame;


/* Unions of 68000, 68010 and 68020 types, for programs that must run on 
 *  any without recompiling */

typedef union
  {
    MC68000ExceptionStackFrame	x00;
    MC68010ExceptionStackFrame	x10;
    MC68020ExceptionStackFrame	x20;
  }
ExceptionStackFrame;

typedef union
  {
    MC68000StatusWord		s00;
    MC68010StatusWord		s10;
    MC68020StatusWord		s20;
  }
StatusWord;


/* Function codes */
#define FC_USER_DATA		1
#define FC_USER_PROGRAM		2
#define FC_SUN2_CPU_LAYER	3
#define FC_SUPER_DATA		5
#define FC_SUPER_PROGRAM	6
#define FC_CPU_SPACE		7


/* Further information about bus errors, supplied by kernel */
#define OUT_OF_RANGE	0	/* Address bits 24-31 nonzero */
#define SPURIOUS	1	/* Spurious bus error */
#define SYSTEM_SPACE	2	/* Access to system space (above 0x200000) */
#define PROTECTION	3	/* Memory protection violation */
#define PAGE_INVALID	4	/* Invalid page */
#define SEG_INVALID	5	/* Invalid segment */
#define MB_TIMEOUT	6	/* Multibus access timed out */
#define PARITY		7	/* Parity error in onboard memory */
/* Sun-3 */
#define WATCHDOG	8	/* Watchdog or user reset */
#define FPAENERR	9	/* Cpu access to a disabled FPA */
#define FPABERR		10	/* FPA bus error */
#define	VMEBERR		11	/* VME bus error */
#define	BUS_TIMEOUT	12	/* Access to a non-existing device */

/* Format of message received from a kernel exception,
 * as sent to the exception server
 */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		requestcode;	/* EXCEPTION_REQUEST */
    unsigned short	type;		/* Machine-specific exception type */
    unsigned short	buserrortype;	/* Additional detail on bus errors */
    unsigned short	code;		/* Type of memory reference */
#else LITTLE_ENDIAN
    unsigned short	type;		/* Machine-specific exception type */
    SystemCode		requestcode;	/* EXCEPTION_REQUEST */
    unsigned short	code;		/* Type of memory reference */
    unsigned short	buserrortype;	/* Additional detail on bus errors */
#endif LITTLE_ENDIAN
    unsigned		accaddr;	/* Access address for bus and address errors */
    unsigned		instruction;	/* First word of instruction causing fault */
    unsigned		status;		/* status register */
    unsigned		errpc;		/* Program counter */
    char		*segment;	/* Beginning of team segment */
    unsigned		segmentsize;	/* Team segment size */
  } ExceptionRequest;

/* Format of message used to register an exception handler.
 */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode	requestcode;		/* REGISTER_HANDLER */
    short	fill;
#else LITTLE_ENDIAN
    short	fill;
    SystemCode	requestcode;		/* REGISTER_HANDLER */
#endif LITTLE_ENDIAN
    int regFlag;			/* Indicates whether to register (1)
					   or unregister (0) handler. */
    ProcessId handlerPid;		/* Pid of exception handler */
    ProcessId regPid;			/* Pid of process registering for */
  } RegHandlerRequest;

#endif
