/*
 * net.c
 *
 * Reverse Address Resolution Protocol server
 * Copyright (c) 1984 Stanford University.
 *
 * Routines that handle network I/O, and process RARP packets.
 *
 * HISTORY:
 *
 * 28 May 1984	Sally Ahnger	Stanford (Gregorio)
 *	- Created
 *
 * Ross Finlayson, October 1984.
 * Moved this code to a separate file.
 *
 */

#include "rarpd.h"

EtherRead(fid)
    int fid;
/* EtherRead reads the packet and checks to see it's the right opcode, etc. */
  {
    register PerNet *pn = FidMap[fid];
    struct NetPacket packet;
    register struct ether_arp *RARPpkt;
    
    if (enreadquick(fid, &(pn->DevP), &(packet.Pup)) != OK)
	return(0);
    
    RARPpkt = (struct ether_arp *)&(packet.Pup);
    
    if (debug)
      {
	printf("Received: ");
	PrintRARPpkt(RARPpkt);
      }
    if (((getshort(RARPpkt->arp_op)) ==  RARPOP_REQUEST) &&
	((getshort(RARPpkt->arp_hrd)) == ARPHRD_ETHER) &&
	((getshort(RARPpkt->arp_pro)) == ETHERPUP_IPTYPE) &&
	((RARPpkt->arp_pln) == sizeof(IPAddr)))
      {
	/* Make sure we're looking for the right kind of Ethernet address. */
	if ( ((pn->enetType == enet10) &&
	      (RARPpkt->arp_hln != enet10AddrSize)) ||
	     ((pn->enetType == enet3) &&
	      (RARPpkt->arp_hln != enet3AddrSize)) )
	    if (debug)
		printf("inconsistent arp_hln field.\n");
	/* A correct RARP packet!  Now look it up in our table. */
	if (LookUp(RARPpkt->arp_xtha, RARPpkt->arp_xtpa, pn))
	    RespondTo(RARPpkt, pn);
      }
    else if (debug)
	  printf("unknown address type or OpCode: %o\n", 
		 getshort(RARPpkt->arp_op));
  }


RespondTo(rarpPacket, pn)
    register struct ether_arp *rarpPacket; /*already contains targets, etc*/
    register PerNet *pn;
/* Send a response packet with our addresses in 'source' addresses.  rarpPacket
   comes in with the target addresses filled in, as well as the sizes, etc. */
  {
    EtherAddr dest;

    /* remember sender's hardware address, so the packet can be returned */
    bcopy(rarpPacket->arp_xsha, dest, rarpPacket->arp_hln);

    /* fill in reply opcode and source addresses */
    rarpPacket->arp_op = makeshort(RARPOP_REPLY);
    bcopy(pn->Our_Eth_Addr, rarpPacket->arp_xsha, rarpPacket->arp_hln);
    bcopy(pn->Our_IP_Addr, rarpPacket->arp_xspa, rarpPacket->arp_pln);
    
    enwrite(dest, makeshort(ETHERTYPE_RARPTYPE),
	    pn->Fid, &(pn->DevP), rarpPacket, sizeof(*rarpPacket));
	
    if (debug)
      {
	printf("Sent (response): ");
	PrintRARPpkt(rarpPacket);
      }
  }
