/*
 * debug.c
 *
 * Reverse Address Resolution Protocol server
 * Copyright (c) 1984 Stanford University.
 *
 * Miscellaneous routines used in debugging.
 *
 * HISTORY:
 *
 * 28 May 1984	Sally Ahnger	Stanford (Gregorio)
 *	- Created
 *
 * Ross Finlayson, October 1984.
 * Moved this code to a separate file.
 *
 */

#include "rarpd.h"

PrintRARPpkt(rarpPacket)
    struct ether_arp *rarpPacket;
/* prints out the contents of a RARP (or ARP) packet */
  {
    printf("RARP packet, OpCode %o\n", getshort(rarpPacket->arp_op));
    printf("Target Ethernet address: ");
    PrintEtherAddr(rarpPacket->arp_xtha,
    		   (rarpPacket->arp_hln == enet10AddrSize) ? enet10 : enet3);
    printf("Target IP Address: ");
    PrintIPAddr(rarpPacket->arp_xtpa);
    printf("Source_Eth_Addr: ");
    PrintEtherAddr(rarpPacket->arp_xsha,
    		   (rarpPacket->arp_hln == enet10AddrSize) ? enet10 : enet3);
    printf("Source_IP_Addr: ");
    PrintIPAddr(rarpPacket->arp_xspa);
  }

PrintEtherAddr(addr, type)
    uchar *addr;
    EnetType type;
 {
    register int i;
    int size = (type == enet10) ? enet10AddrSize : enet3AddrSize;

    for (i = 0; i < size; i++)
      {
	printf("%x", *addr++);
	if (i < size-1)
	    printf(".");
      }
    printf("\n");
  }

PrintIPAddr(addr)
    uchar *addr;
  {
    register int i;

    for (i = 0; i < sizeof(IPAddr); i++)
      {
	printf("%d", *addr++);
	if (i < sizeof(IPAddr)-1)
	    printf(".");
      }
    printf("\n");
  }

