/*
 * CPARSE syntax tree output stuff
 */

#include "defs.h"

/*
 * Tprint - print a subtree
 */
public Tprint(t)
Tnode t;
{
	printf("\nTprint\n\n");
	if (t==TNIL)
		printf("TNIL\n");
	else
		_Tprint(t, 0);
}

_Tprint(t, level)
register Tnode t;
register Integer level;
{
	register i = level;
	Tnode ts;

	if (t==TNIL)
		return;

	while (i-- > 0)
		printf("\t");

	switch (t->T_op) {

	case T_CLASS: {
		printf("class %s\n", xSymclass(t->cl.class));
		break;
	    }
	case T_TYPE: {
		if (t->ty.symptr->s_name==NNIL)
			printf("type %s\n", xSymtype(t->ty.symptr->s_type));
		else
			printf("type %s\n", Nstring(t->ty.symptr->s_name));
		break;
	    }
	case T_NAME: {
		if (t->nm.name != NNIL)
			printf("%s\n", Nstring(t->nm.name));
		else
			printf("(null)\n");
		break;
	    }
	case T_SYM: {
		if (t->sym.symptr==SNIL)
			printf("sym (null)\n");
		else if (t->sym.symptr->s_name==NNIL)
			printf("sym name (null)\n");
		else
			printf("%s\n", Nstring(t->sym.symptr->s_name));
		break;
	    }
	case T_FIELD:
	case T_UARRAY: {
		if (t->sz.dim==TNIL)
			printf("%s = nil\n", xTop(t));
		else {
			printf("%s =\n", xTop(t));
			_Tprint(t->sz.dim, level+1);
		}
		break;
	    }
	case T_ICON: {
		printf("%ld\n", t->ic.value);
		break;
	    }
	case T_FCON: {
		printf("%3.3f\n", t->fc.value);
		break;
	    }
	case T_SCON: {
		printf("\"%s\"\n", t->sc.string);
		break;
	    }
	default:
		if (t->T_type==TUNDEF)
			printf("%s\n", xTop(t));
		else {
			printf("%s (", xTop(t));
			Stprint(t->T_type, TNIL);
			printf(")\n");
		}
		break;
	}

	_Tprint(t->T_son, level+1);
	_Tprint(t->T_sib, level);
}
