/*
 * CPARSE type checking stuff
 */

#include "defs.h"
#include "y.tab.h"

struct Op_init {
	Token op;
	String opstr;
	unsigned short optype;
};

private struct Op_init Op_init[] = {
	UNARY MINUS, "U-", UTYPE,
	UNARY MUL, "U*", UTYPE,
	UNARY AND, "U&", UTYPE,
	NOT, "!", UTYPE|LOGFLG,
	COMPL, "~", UTYPE,
	PLUS, "+", BITYPE,
	ASG PLUS, "+=", BITYPE|ASGFLG,
	MINUS, "-", BITYPE,
	ASG MINUS, "-=", BITYPE|ASGFLG,
	MUL, "*", BITYPE,
	ASG MUL, "*=", BITYPE|ASGFLG,
	AND, "&", BITYPE,
	ASG AND, "&=", BITYPE|ASGFLG,
	ANDAND, "&&", BITYPE|LOGFLG,
	OROR, "||", BITYPE|LOGFLG,
	ASSIGN, "=", BITYPE|ASGFLG,
	DIV, "/", BITYPE,
	ASG DIV, "/=", BITYPE|ASGFLG,
	MOD, "%", BITYPE,
	ASG MOD, "%=", BITYPE|ASGFLG,
	LS, "<<", BITYPE,
	ASG LS, "<<=", BITYPE|ASGFLG,
	RS, ">>", BITYPE,
	ASG RS, ">>=", BITYPE|ASGFLG,
	OR, "|", BITYPE,
	ASG OR, "|=", BITYPE|ASGFLG,
	ER, "^", BITYPE,
	ASG ER, "^=", BITYPE|ASGFLG,
	EQ, "==", BITYPE|LOGFLG,
	NE, "!=", BITYPE|LOGFLG,
	LE, "<=", BITYPE|LOGFLG,
	LT, "<", BITYPE|LOGFLG,
	GE, ">=", BITYPE|LOGFLG,
	GT, ">", BITYPE|LOGFLG,
	0,SNULL,0
};

/*
 * Opinit - initialize operator vectors
 */
public void Opinit()
{
	register struct Op_init *o;

	for (o=Op_init; o->op != 0; o++) {
		Op_type[o->op] = o->optype;
		Op_str[o->op] = o->opstr;
	}
}

/*
 * Opaction - return action associated with an operator
 */
public unsigned short Opaction(op, left, right)
Token op;
Tnode left, right;
{
	unsigned short Opmod();
	register unsigned short mt12, mt1, mt2;

	mt12 = 0;

	TTtrace(2, printf("Opaction %s %s %s\n",Opstr(op),xTop(left),xTop(right)));
	switch (Optype(op)) {
	case BITYPE:
		TTtrace(2, printf("right type = "));
		TTtrace(2, Stprint(right->T_type, TNIL));
		TTtrace(2, printf("\n"));
		mt12 = mt2 = Opmod(right->T_type);
	case UTYPE:
		TTtrace(2, printf("left type = "));
		TTtrace(2, Stprint(left->T_type, TNIL));
		TTtrace(2, printf("\n"));
		mt1 = Opmod(left->T_type);
		mt12 &= mt1;
	}

	switch (op) {
	case UNARY MUL:
		return(OTHER);
	case UNARY MINUS:
		if (mt1 & MDBI)
			return(TYPL);
		break;
	case COMPL:
		if (mt1 & MINT)
			return(TYPL);
		break;
	case UNARY AND:
		return(OTHER);
	case NOT:
	case ANDAND:
	case OROR:
		return(0);
	case MUL:
	case DIV:
		if (mt12 & MDBI)
			return(TYMATCH);
		break;
	case MOD:
	case AND:
	case OR:
	case ER:
		if (mt12 & MINT)
			return(TYMATCH);
		break;
	case LS:
	case RS:
		if (mt12 & MINT)
			return(TYMATCH+OTHER);
		break;
	case EQ:
	case NE:
	case LT:
	case LE:
	case GT:
	case GE:
		if ((mt1&MENU) || (mt2&MENU))
			return(PTMATCH+PUN);
		if (mt12 & MDBI)
			return(TYMATCH);
		if (mt12 & MPTR)
			return(PTMATCH+PUN);
		if (mt12 & MPTI)
			return(PTMATCH+PUN);
		break;
	case ASSIGN:
	case RETURN:
		if (mt12 & MSTR)
			return(LVAL+TYPL+OTHER);
		if (mt12 & MDBI)
			return(LVAL+TYPL+TYMATCH);
		if ((mt1&MENU) || (mt2&MENU))
			return(LVAL+TYPL+PTMATCH+PUN);
		if (mt12==0)
			break;
		if (mt1 & MPTR)
			return(LVAL+PTMATCH+PUN);
		if (mt12 & MPTI)
			return(LVAL+TYPL+TYMATCH+PUN);
		break;
	case ASG LS:
	case ASG RS:
		if (mt12 & MINT)
			return(LVAL+TYPL+OTHER);
		break;
	case ASG MUL:
	case ASG DIV:
		if (mt12 & MDBI)
			return(LVAL+TYMATCH);
		break;
	case ASG MOD:
	case ASG AND:
	case ASG OR:
	case ASG ER:
		if (mt12 & MINT)
			return(LVAL+TYMATCH);
		break;
	case ASG PLUS:
	case ASG MINUS:
		if (mt12 & MDBI)
			return(LVAL+TYMATCH);
		if ((mt1&MPTR) && (mt2&MINT))
			return(LVAL+TYPL);
		break;
	case MINUS:
		if (mt12 & MPTR)
			return(PTMATCH+PUN);
		if (mt2 & MPTR)
			break;
	case PLUS:
		if (mt12 & MDBI)
			return(TYMATCH);
		if ((mt1&MPTR) && (mt2&MINT))
			return(TYPL);
		if ((mt1&MINT) && (mt2&MPTR))
			return(TYPR);
		break;
	}

	uerror("operands of %s have incompatible types", Opstr(op));
	return(0);
}

/*
 * Opmod - abstract the given type for type checking
 */
public unsigned short Opmod(type)
Stype type;
{
	TTtrace(2, printf("Opmod "));
	TTtrace(2, Stprint(type, TNIL));
	TTtrace(2, printf("\n"));
	switch (type) {
	case TVOID:
	case TUNDEF:
		return(0);
	case TENUMTY:
	case TMOETY:
		return(MENU);
	case TSTRTY:
	case TUNIONTY:
		return(MSTR);
	case TCHAR:
	case TSHORT:
	case TUCHAR:
	case TUSHORT:
		return(MINT|MDBI|MPTI);
	case TUNSIGNED:
	case TULONG:
	case TINT:
	case TLONG:
		return(MINT|MDBI|MPTI);
	case TFLOAT:
	case TDOUBLE:
		return(MDBI);
	default:
		return(MPTR|MPTI);
	}
}

/*
 * Oplval - check to see that a node is addressable
 */
public Boolean Oplval(t)
register Tnode t;
{
	switch (t->T_op) {
	case T_UNOP:
		/* check for &(st1 = st2) and f().a */
		/* fall through */
	case T_SYM:
	case T_STREF:
		if (ISARY(t->T_type) || ISFTN(t->T_type))
			return(false);
		/* fall through */
	case T_ARYREF:
		return(true);
	default:
		return(false);
	}
}

/*
 * Opchkpun - check for a PUN
 */
public void Opchkpun(t)
Tnode t;
{
}

/*
 * Optymatch - check for type match
 */
public void Optymatch(t)
Tnode t;
{
	t->T_type = t->T_son->T_type;
}

/*
 * Opptmatch - check for pointer match
 */
public void Opptmatch(t)
Tnode t;
{
	t->T_type = t->T_son->T_type;
}
