/*
 * CPARSE internal identifier representation
 *
 * Alan Hastings 2/17/85
 */

#include "defs.h"

#define NHASHSIZE	2003
#define Nhash(h, s)		\
		Strhash(h, s);	\
		h %= NHASHSIZE;

private Name Nhashtab[NHASHSIZE];
private Integer Nfakenum = 0;

/*
 * given a string, convert it to a name pointer
 */
private Name Nenter(s)
register String s;
{
	register Hashval hval;
	register String p;
	register Name n;

	Nhash(hval, s);
	n = Nhashtab[hval];

	while (n != NNIL && !streq(n->n_string, s)) {
		n = n->n_next;
	}

	/* make a new entry? */
	if (n == NNIL) {
		Strace(3, printf("new "));
		n = new(Name);
		n->n_string = strdup(s);
		n->n_next = Nhashtab[hval];
		Nhashtab[hval] = n;
	}

	Strace(3, printf("name='%s'\n", n->n_string));

	return(n);
}

/*
 * Nlookup - lookup name in name table
 */
public Name Nlookup(s)
String s;
{
	register Name n;

	n = Nenter(s);
	/* at this point, just return it */
	return(n);
}

/*
 * Nstring - return the real string
 */
public String Nstring(n)
Name n;
{
	if (n==NNIL)
		return("");
	else
		return(n->n_string);
}

/*
 * Nfakename - return unique fake (internal) name
 */
public Name Nfakename()
{
	Byte xname[32];

	/* the dot assures no overlap with user symbols */
	(void) sprintf(xname, ".FAKE%d", Nfakenum++);
	return(Nenter(strdup(xname)));
}
