/*
 * CPARSE main program and initialization stuff
 *
 * Alan Hastings 2/14/85
 */

#include "defs.h"

private Integer Tracedump = 0;

main(argc, argv)
Integer argc;
String argv[];
{
	register String p;		/* for Progname adjustment */
	register Short cmd;		/* command line option */
	extern Integer getopt();	/* command line parser */
	extern String optarg;		/* for getopt() */

	Progname = argv[0];
	for (p=Progname; *p; p++)
		if (*p=='/')
			Progname = ++p;

	/*
	 * get options from the command line
	 */
	while ((cmd = getopt(argc, argv, "Lrt:")) != EOF) {
		switch (cmd) {
		case 'L':	/* produce lint library version of functions */
			LintFlag = true;
			break;
		case 'r':	/* version info */
			fprintf(stderr, "%s version %s\n", Progname, Version);
			(void) fflush(stderr);
			break;

		case 't':	/* trace options */
			Settrace(optarg);
			break;

		default:	/* getopt also prints a message */
			Usage();
			Quit(UERROR);
		}
	}

	Init();
	
	yyparse();

	Ptrace(2, Tprint(Program));

	Quit(0);
}

private Usage()
{
	fprintf(stderr, "usage: %s [-tdilpstTy] [-r] files...\n", Progname);
	(void) fflush(stderr);
}

private Init()
{
	static Byte Bufstderr[BUFSIZ];

	setbuf(stderr, Bufstderr);

	Signals();

	Nerrors = 0;
	Filename = "\"\"";

	Opinit();
	Lxinit();
	Keyinit();
}

private Settrace(opts)
register String opts;
{
#ifdef	YYDEBUG
	extern yydebug;
#endif	YYDEBUG

	while (*opts) {
		switch (*opts++) {
		case 'l':	/* trace lexical analysis */
			Tracelex = true;
			break;
		case 'i':	/* trace initialization */
			Traceinit = true;
			break;
		case 'p':	/* print syntax tree at intervals */
			Tracepgm++;
			break;
		case 's':	/* trace symbols */
			Tracesym++;
			break;
		case 'd':	/* dump the symbol table at the end */
			Tracedump++;
			break;
		case 't':	/* trace tree operations */
			Tracetree++;
			break;
		case 'T':	/* trace type checking operations */
			Tracetype++;
			break;
		case 'y':	/* turn on YACC debugging if compiled */
#ifdef	YYDEBUG
			yydebug = 1;
#else
			fprintf(stderr, "%s: not compiled with YYDEBUG\n", Progname);
			Quit(UERROR);
#endif	YYDEBUG
			break;
		default:
			Usage();
			Quit(UERROR);
		}
	}
}

private Signals()
{
}

public yyerror(s)
String s;
{
	uerror(s);
}

#define Errheader (void) fflush(stdout);fprintf(stderr, "%s (%d): ", Filename, Lineno)

/* VARARGS1 */
public uerror(s, a)
String s;
{
	Errheader;
	++Nerrors;
	fprintf(stderr, s, a);
	fprintf(stderr, "\n");
	(void) fflush(stderr);

	if (Nerrors > MAXERRORS) {
		cerror("too many errors");
	}
}

/* VARARGS1 */
public werror(s, a)
String s;
{
	Errheader;
	fprintf(stderr, "warning: ");
	fprintf(stderr, s, a);
	fprintf(stderr, "\n");
	(void) fflush(stderr);
}

/* VARARGS1 */
public cerror(s, a, b, c)
String s;
{
	Errheader;
	fprintf(stderr, "compiler error: ");
	fprintf(stderr, s, a, b, c);
	fprintf(stderr, "\n");
	(void) fflush(stderr);

	Quit(CERROR);
}

public Quit(code)
{
	if (Tracedump)
		Symdump(Tracedump > 1);
	exit(code);
}
