/*
 * CPARSE enumeration type management
 */

#include "defs.h"

/*
 * Enuminst - construct an enum node
 */
public Tnode Enuminst(name, memlist)
Name name;
Tnode memlist;
{
	register Tnode t, tt, memp;
	register Symbol s, tagptr;
	Integer memval;			/* value for enum symbols */
	Boolean mustmatch = false;

	if (name==NNIL)
		name = Nfakename();

	Strace(2, printf("Enuminst of %s\n", Nstring(name)));
	tagptr = Symlookup(name, S_STAG, Curlevel);
	if (tagptr==SNIL) {
		tagptr = Syminsert(name, SMOE, Curlevel, true);
		tagptr->s_flag = S_STAG;
	} else {
		/* previously defined... must match ALL members */
		mustmatch = true;
	}
	t = Talloc(T_SYM);
	t->sym.symptr = tagptr;

	if (tagptr->s_class==SNULL) {
		tagptr->s_class = SMOE;
	}
	Symdef(t, SENAME, TENUMTY, IN_ENUM);

	tt = Talloc(T_ENUM);
	tt->T_son = t;
	tt->T_sib = memlist;
	tt->ty.symptr = tagptr;

	memval = 0;
	for (memp=memlist; memp != TNIL; memp = memp->T_sib, memval++) {
		assert(memp->T_op==T_NAME);
		if (memp->T_son != TNIL) {
			/* assigned enum value */
			memval = Iconval(memp->T_son);
		}
		s = Symlookup(memp->nm.name, 0, Curlevel);
		if (s==SNIL) {
			if (mustmatch)
				uerror("redeclaration of %s", Nstring(tagptr->s_name));
			s = Syminsert(memp->nm.name, SMOE, Curlevel, true);
		} else {
			if (s->s_level < Curlevel) {
				s = Syminsert(s->s_name, SMOE, Curlevel, true);
			} else {
			   /* symbol previously defined */
			   /* must be an enum member and have the same value */
			   if (   s->s_class != SMOE
			       || s->s_intval != memval
			       || s->s_typtr != tagptr)
				uerror("redeclaration of %s", Nstring(s->s_name));
			   else {
				/* symbol has same value, it's ok */
				Tmksym(memp, s);
				continue;
			   }
			}
		}
		s->s_intval = memval;
		s->s_typtr = tagptr;
		s->s_type = TENUMTY;
		Tmksym(memp, s);
	}

	return(tt);
}
