/*
 * CPARSE constant expression tree handling
 */

#include "defs.h"
#include "y.tab.h"

/*
 * Icon - integer constant
 */
public Tnode Icon(iptr)
Intcon iptr;
{
	register Tnode t;

	t = Talloc(T_ICON);
	t->T_type = TINT;
	t->ic.value = iptr->i_value;
	t->ic.islong = iptr->i_islong;
	return(t);
}

/*
 * Fcon - float constant
 */
public Tnode Fcon(fptr)
Floatcon fptr;
{
	register Tnode t;

	t = Talloc(T_FCON);
	t->T_type = TDOUBLE;
	t->fc.value = fptr->f_value;
	return(t);
}

/*
 * Scon - string constant
 */
public Tnode Scon(sptr)
String sptr;
{
	register Tnode t;

	t = Talloc(T_SCON);
	t->T_type = TARY|TCHAR;
	t->sc.string = sptr;
	return(t);
}

/*
 * Iconval - evaluate constant node (return int)
 */
public Integer Iconval(node)
register Tnode node;
{
	register Integer i;

	if (node==TNIL)
		return(1);
	switch (node->T_op) {
	case T_ICON:
		return(node->ic.value);
	case T_FCON:
		return((Integer)node->fc.value);
	case T_BINOP:
		switch (node->ic.value) {
		case PLUS:
			return(Iconval(node->T_son) + Iconval(node->T_son->T_sib));
		case MINUS:
			return(Iconval(node->T_son) - Iconval(node->T_son->T_sib));
		case MUL:
			return(Iconval(node->T_son) * Iconval(node->T_son->T_sib));
		case DIV:
			if ((i = Iconval(node->T_son->T_sib))==0) {
				uerror("division by zero in int const");
				i = 1;
			}
			return(Iconval(node->T_son) / i);
		case MOD:
			return(Iconval(node->T_son) % Iconval(node->T_son->T_sib));
		case LS:
			return(Iconval(node->T_son) << Iconval(node->T_son->T_sib));
		case RS:
			return(Iconval(node->T_son) >> Iconval(node->T_son->T_sib));
		case AND:
			return(Iconval(node->T_son) & Iconval(node->T_son->T_sib));
		case OR:
			return(Iconval(node->T_son) | Iconval(node->T_son->T_sib));
		case ER:
			return(Iconval(node->T_son) ^ Iconval(node->T_son->T_sib));
	}
	case T_SIZEOF:
		return(1);	/* all sizes are the same for us */
	default:
		Strace(2, printf("bad icon node op=%s\n",xTop(node)));
		uerror("unimplemented int con node");
		return(1);
	}
}
