/*
 * CPARSE typedefs
 *
 * Alan Hastings 2/14/85
 */

/*
 * common types
 */
typedef long		Integer;
typedef short		Short;
typedef char		Byte;
typedef	char *		String;
typedef float		Real;
typedef double		Double;
typedef enum { false, true } Boolean;

typedef unsigned Short	Token;
typedef unsigned Short	Lnum;
typedef unsigned Integer Hashval;

/*
 * symbol table types
 */
typedef union Tnode *	Tnode;		/* needed for forward reference */
typedef struct Symbol *	Symbol;
typedef struct Name *	Name;
typedef unsigned long	Stype;
typedef Byte		Sclass;
typedef Byte		Sflag;

#define	NNIL		((Name)0)
#define	SNIL		((Symbol)0)

struct Symbol {
	Name s_name;		/* pointer to symbol name */
	Stype s_type;		/* symbol type */
	Sclass s_class;		/* symbol storage class */
	Sflag s_flag;		/* symbol flags (S_STAG, S_SMOS, etc) */
	Integer s_level;	/* scoping level (0=global,1=param,>1=in_func */
	String s_file;		/* filename where defined */
	Lnum s_line;		/* line number in file */
	Symbol s_xlink;		/* cross link (also struct/union membership) */
	Symbol s_next;		/* hash overflow chaining */
	Integer s_intval;	/* enum val, field size */
	Symbol s_typtr;		/* pointer to type symbol */
	Tnode s_szptr;		/* pointer to list of dimension nodes */
};

/*
 * symbol locations
 */
typedef enum {
	IN_OTHER,		/* i.e. not in one of the following: */
	IN_STRUCT,		/* we are working on a structure */
	IN_UNION,		/* we are working on a union */
	IN_ENUM			/* we are working on a enum */
} Slocation;

/*
 * string hash access structure
 */
struct Name {
	String n_string;	/* pointer to string itself */
	Name n_next;		/* hash overflow chaining */
};

/*
 * lexical return types for constants
 */

typedef struct Intcon *		Intcon;
typedef struct Floatcon *	Floatcon;

struct Intcon {
	Integer	i_value;
	Boolean i_islong;
};

struct Floatcon {
	/* may be other things required? */
	Double f_value;
};

/*
 * keyword types
 */

typedef struct Keyword * Keyword;

struct Keyword {
	String k_name;		/* string to match */
	Short k_action;		/* action for Lxres() */
	Short k_value;		/* could be type, class, token */
	Keyword k_next;		/* hash overflow chain */
};

/*
 * syntax tree node types
 */

typedef enum {
	T_NULL, T_VARDEF, T_TYPEDEC, T_FUNDEF, T_TYPE, T_CLASS, T_NAME, T_UNION,
	T_STRUCT, T_ENUM, T_UMUL, T_UCALL, T_UARRAY, T_FIELD,
	T_STMTLIST, T_DECLIST, T_IF, T_WHILE, T_DO, T_FOR, T_SWITCH,
	T_BREAK, T_CONTINUE, T_RETURN, T_GOTO, T_CAST, T_SIZEOF, T_BLOCK,
	T_LABEL, T_SYM, T_ICON, T_FCON, T_SCON, T_FUNARGS, T_FUNHEAD,
	T_BINOP, T_UNOP, T_STREF, T_ARYREF, T_INCPRE, T_INCPOST, T_COND,
	T_CMEXPR, T_DIM,
} Ttype;

#define	TNIL	((Tnode)0)

#define	T_op	in.t_op
#define	T_sib	in.t_sib
#define	T_son	in.t_son
#define T_type	in.t_type

union Tnode {
	struct basic {
		Ttype t_op;
		Tnode t_son;		/* offspring pointer */
		Tnode t_sib;		/* sibling pointer */
		Stype t_type;
	} in;
	struct /* symbol pointer */ {
		struct basic x;
		Symbol symptr;
	} sym;
	struct /* type info */ {
		struct basic x;
		Symbol symptr;
		Tnode dimptr;
	} ty;
	struct /* class info */ {
		struct basic x;
		Name name;
		Sclass class;
	} cl;
	struct /* name info */ {
		struct basic x;
		Name name;
		Tnode dimptr;
	} nm;
	struct /* int constant */ {
		struct basic x;
		Integer value;
		Boolean islong;
	} ic;
	struct /* float constant */ {
		struct basic x;
		Double value;
	} fc;
	struct /* string constant */ {
		struct basic x;
		String string;
	} sc;
	struct /* node list */ {
		struct basic x;
		Tnode last;
	} list;
	struct /* dimension modified node */ {
		struct basic x;
		Tnode dim;
	} sz;
	struct /* label name/case expression pointer */ {
		struct basic x;
		Tnode ptr;
	} label;
};
