/*
 * rawio.c
 *
 * This used to be emt.c, the file which contains raw io routines for the
 * uvax.  It is logically equivalent to rawio.c in ../m68k and ../ff68k,
 * which used to call this fakeemt.c.
 *
 */

#include "ipl.h"

/*
 *	Get a character c from the console
 */
int K_mayget()
  {
    register int i;

    ;asm("	mfpr	$rxcs, r11");
    if( !(i & 0x80) )
	return( -1 );

    /* return the character RXDB */
    ;asm("	mfpr	$rxdb, r11");
    i &= 0377;
    return( i );
  }

/*
 * K_putchar
 * Prints the character c on the console.
 */
K_putchar( c )
    int c;
  {
    register int r11;	/* the first variable declared register is */
			/* allocated by the compiler to be r11, I believe. */
    int i;

    if (c == '\n')
      {
	for( i = 0; i < 1000; i++ );
	K_putchar('\r');
	for( i = 0; i < 1000; i++ );
      }
	
    asm("	mfpr	$txcs, r11");
    while( !(r11 & 0x80) )
      {
	;asm("	mfpr	$txcs, r11");
      }
    r11 = c & 0377;
    asm("	mtpr	r11, $txdb");
    asm("	mfpr	$txcs, r11");
    while( !(r11 & 0x80) )
      {
	;asm("	mfpr	$txcs, r11");
      }
  }

/*
 * K_getchar:
 * Busy waits for a character to be typed in from the keyboard and returns it.
 * Used to be called GetChar and lived in /xV/kernel/vax/machine.c
 */
K_getchar()
  {
	register int r11;
	int i;

	do
	  {
	    ;asm("    mfpr    $rxcs, r11");
	  }
	while (!(r11 & 0x80));  /* Wait for character */
	;asm("    mfpr    $rxdb, r11"); /* Read it in */
	if ((r11 & 0xff00) != 0)/* Check for break or errors */
	{
	    return( -1 );
	}
	r11 &= 0x7f;    /* Turn off parity */
	if ((char)r11 == '\r')  /* CRMOD translation */
	    r11 = '\n';
	K_putchar( r11 );
	return( r11 );
}

Kput_str( str ) char *str;

  /* Output a string busy wait on the console from the kernel.
   */
  {
    register char c;

    while( c = *str++ ) K_putchar( c );
  }

/* K_ticks
 *	Return the current number of ticks.
 *	Actually just calls the routine which resides in initints.c.
 *	I would like to alleviate the extra function call, but return_K_ticks
 *	returns "Time", a static long declared in initints.c, and I don't want
 *	to break anything right now.  Someday, somebody should rename "Time"
 *	to something weird like "_Tick_Time_", make it global (declared and
 *	allocated in this module), have it initialized where it is now (in 
 *	initints.c), and document all those changes sufficiently.
 */
long
K_ticks()
  {
    return( return_K_ticks() );
  }
