#include "Vio.h"
#include "ipl.h"

extern int	ResVec();
extern int	MachineChk();
extern int	KernStackInval();
extern int	PwrFail();
extern int	ResPrivInstrn();
extern int	XFC();
extern int	OperandReserved();
extern int	AddrModeReserved();
extern int	AccessCntlViol();
extern int	XlationInval();
extern int	TracePending();
extern int	BreakPoint();
extern int	Arithmetic();
extern int	CHMK();
extern int	CHME();
extern int	CHMS();
extern int	CHMU();
extern int	BusTimeout();
extern int	Software();
extern int	IntervalTimer();
extern int	UndoneEMT();
extern int	DoneEMT();
extern int	RxConsole();
extern int	TxConsole();
extern int	Q22();

static	char	*intname[] = {
		"ResVec",
		"MachineChk",
		"KernStackInval",
		"PwrFail",
		"ResPrivInstrn",
		"XFC",
		"OperandReserved",
		"AddrModeReserved",
		"AccessCntlViol",
		"XlationInval",
		"TracePending",
		"BreakPoint",
		"Arithmetic",
		"CHMK",
		"CHME",
		"CHMS",
		"CHMU",
		"BusTimeout",
		"Software",
		"IntervalTimer",
		"UndoneEMT",
		"DoneEMT",
		"RxConsole",
		"TxConsole",
		"Q22"
		};

static	SCB_t	*SCBB;
static	long	Time;

long
K_ticks()
{
	return(Time);
}


GotAnInt(type, numparams)
int	type, numparams;
{
	register int	r11;
	int	*param = &numparams + 13;
	int	i;

	switch (type) {

		case VecIntervalTimer:
			Time++;
			break;

		default:
			asm("	mfpr	$ipl, r11");
			printf("Got a %s, ipl is %x, %d parameters were pushed\n",
				intname[type], r11, numparams);
			for (i = 0; i < numparams; i++, param++) {
				printf("%d: %x\n", i, *param);
			}
			printf("pc: %x\npsl: %x\n", *param, *(param+1));
			exit(0);
			break;
	}
}

initints()
{
	register int	r11;
	SCB_t *SCB;

	asm("	mfpr	$scbb, r11");	/* Assume scbb already points to */
	SCB = (SCB_t *) r11;		/*   a valid 1K block		 */
	for (r11 = 0; r11 < 0x100; r11++) {
		SCB->vec[r11] = ResVec;
	}
	SCB->vec[VecMachineChk]		= MachineChk;
	SCB->vec[VecKernStackInval]	= KernStackInval;
	SCB->vec[VecPwrFail]		= PwrFail;
	SCB->vec[VecResPrivInstrn]	= ResPrivInstrn;
	SCB->vec[VecXFC]		= XFC;
	SCB->vec[VecOperandReserved]	= OperandReserved;
	SCB->vec[VecAddrModeReserved]	= AddrModeReserved;
	SCB->vec[VecAccessCntlViol]	= AccessCntlViol;
	SCB->vec[VecXlationInval]	= XlationInval;
	SCB->vec[VecTracePending]	= TracePending;
	SCB->vec[VecBreakPoint]		= BreakPoint;
	SCB->vec[VecArithmetic]		= Arithmetic;
	SCB->vec[VecCHMK]		= CHMK;
	SCB->vec[VecCHME]		= CHME;
	SCB->vec[VecCHMS]		= CHMS;
	SCB->vec[VecCHMU]		= CHMU;
	SCB->vec[VecBusTimeout]		= BusTimeout;
	for (r11 = VecBegSoftware; r11 <= VecEndSoftware; r11++)
		SCB->vec[r11] = Software;
	SCB->vec[VecIntervalTimer]	= IntervalTimer;
	SCB->vec[VecUndoneEMT]		= UndoneEMT;
	SCB->vec[VecDoneEMT]		= DoneEMT;
	SCB->vec[VecRxConsole]		= RxConsole;
	SCB->vec[VecTxConsole]		= TxConsole;
	for (r11 = VecQ22Base; r11 < 0x100; r11++)
		SCB->vec[r11] = Q22;

	/* Initialize variables */
	Time = 0;

	/* lower my IPL to 1 */
	asm("	mtpr	$1, $ipl");
}
